import threading
import time
import wx
import wx.lib.newevent

(ExecStartEvent , EVT_EXEC_START ) = wx.lib.newevent.NewEvent()
(ExecEndEvent   , EVT_EXEC_END   ) = wx.lib.newevent.NewEvent()

class ExecCommandCommon:
    def __init__(self,func,event=None,args=(),objs=[],onfunc=None,offfunc=None):
        self.func   = func
        self.event  = event
        self.objs   = objs
        self.onfunc = onfunc
        self.offfunc= offfunc

        if self.event!=None:
            self.obj=event.GetEventObject()
            self.obj.Bind(EVT_EXEC_START,self.execCommandStart)
            self.obj.Bind(EVT_EXEC_END,  self.execCommandEnd)
        else:
            self.obj=None

        for obj in self.objs:
            obj.Bind(EVT_EXEC_START,self.execCommandStart)
            obj.Bind(EVT_EXEC_END  ,self.execCommandEnd)

        if isinstance(args, tuple):
            self.args=args
            pass
        elif isinstance(args, tuple):
            self.args=args
            pass
        else:
            self.args=(args,)

        self.threadProcess   = threading.Thread(target=self.func, args=self.args)
        self.watchDogProcess = threading.Thread(target=self.watchDog)
        self.execCommand()
#-----------------------------------------------------------------------------------
    def execCommand(self):
        if self.obj!=None:
            evt = ExecStartEvent()
            evt.SetEventObject(self.obj)
            wx.PostEvent(self.obj, evt)

        if len(self.objs)>0:
            for obj in self.objs:
                evt = ExecStartEvent()
                evt.SetEventObject(obj)
                wx.PostEvent(obj, evt)

        if self.onfunc!=None:
            self.onfunc()

        self.threadProcess.start()
        self.watchDogProcess.start()
#-----------------------------------------------------------------------------------
    def watchDog(self):
        while 1:
            if self.threadProcess.isAlive():
                time.sleep(1)
            else:
                break

        if self.obj!=None:
            evt = ExecEndEvent()
            evt.SetEventObject(self.obj)
            wx.PostEvent(self.obj, evt)

        if len(self.objs)>0:
            for obj in self.objs:
                evt = ExecEndEvent()
                evt.SetEventObject(obj)
                wx.PostEvent(obj, evt)

        if self.offfunc!=None:
            self.offfunc()
#-----------------------------------------------------------------------------------
    def execCommandStart(self,event):
        obj=event.GetEventObject()
        obj.Disable()
#-----------------------------------------------------------------------------------
    def execCommandEnd(self,event):
        obj=event.GetEventObject()
        obj.Enable()
