#!/usr/bin/python
import wx
import wx.lib.newevent

import xrc.base
import time

import execCommandCommon as ecc
(ExecCommandEvent, EVT_EXEC_COMMOND) = wx.lib.newevent.NewEvent()

#-----------------------------------------------------------------------------------
class MainPanel(xrc.base.PanelBase):
    def __init__(self, parent):
        xrc.base.PanelBase.__init__(self, parent, 'demo01.xrc', 'base')
        btn=self.getControl("Ctrl_Btn")
        btn.Bind(wx.EVT_BUTTON,self.onBtn)
        self.Bind(EVT_EXEC_COMMOND,self.progress)
        self.Fit()
#-----------------------------------------------------------------------------------
    def onBtn(self,event):
        target=self.getControl("Ctrl_Target")
        try:
            val=int(target.GetValue())
        except:
            val=5

        ecc.ExecCommandCommon(self.counter,event,args=(val),objs=[target]) # *******
#-----------------------------------------------------------------------------------
    def progress(self,event):
        present=self.getControl("Ctrl_Present")
        present.SetLabel(event.text)
#-----------------------------------------------------------------------------------
    def counter(self,wait=10):
        for i in range(wait):
            text = str(i+1)+" / "+str(wait)
            evt = ExecCommandEvent(text = text)
            wx.PostEvent(self, evt)
            time.sleep(1)
#-----------------------------------------------------------------------------------
class MainFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, wx.ID_ANY, 'demo01')

        sizer = wx.BoxSizer(wx.VERTICAL)
        self.SetSizer(sizer)
        self.panel = MainPanel(self)
        sizer.Add(self.panel, flag = wx.ALL | wx.EXPAND, border = 1, proportion = 1)
        self.Fit()
        return
#-----------------------------------------------------------------------------------
if __name__ == "__main__":
    app = wx.App()
    frame = MainFrame()
    app.SetTopWindow(frame)
    frame.Show()
    app.MainLoop()
#-----------------------------------------------------------------------------------
