#include "UtsusemiFilterTrignetDNA.hh"
//////////////////////////////////////////////////////////
UtsusemiFilterTrignetDNA::
UtsusemiFilterTrignetDNA(){
    _UCRC = new UtsusemiChopCondInfoReaderTrignet();
    MessageTag = "UtsusemiFilterTrignet::";
    _eventSize = 8;
    isChopCondInfoReady = false;
    isChopTrigTableReady = false;
    isFilterChopReady = false;
    filterChopCaseTable = NULL;
    filterChopPulseIdList.clear();
    filterChopInstClockList.clear();

    _filterChopCaseTables=NULL;
    _filterChopPulseIdLists=NULL;
    _filterChopInstClockLists=NULL;

    MulthChopCaseTable = NULL;
    MulthChopPulseIdLists = NULL;
    MulthChopInstClockLists = NULL;

    fastChopperModeTag = std::numeric_limits<UInt4>::max();

}
//////////////////////////////////////////////////////////
UtsusemiFilterTrignetDNA::
~UtsusemiFilterTrignetDNA(){

    if (_filterChopCaseTables!=NULL)
    for (UInt4 i=0; i<_filterChopCaseTables->size(); i++)
        ClearAllChopTables(i, false);

    UInt4 multh_num = MULTH;
    if (_UCRC->PutTrignetCounterInfo()!=NULL) multh_num = 1;
    if (MulthChopCaseTable!=NULL)
    for (UInt4 i=0; i<MulthChopCaseTable->size(); i++)
        //ClearAllMulthChopTables(i, multh_num, true);
        ClearAllMulthChopTables(i, multh_num, false); //AS ??
    ChopClear();

    if (_filterChopCaseTables!=NULL) delete _filterChopCaseTables;
    if (_filterChopPulseIdLists!=NULL) delete _filterChopPulseIdLists;
    if (_filterChopInstClockLists!=NULL) delete _filterChopInstClockLists;

    if (MulthChopCaseTable!=NULL) delete MulthChopCaseTable;
    if (MulthChopPulseIdLists!=NULL) delete MulthChopPulseIdLists;
    if (MulthChopInstClockLists!=NULL) delete MulthChopInstClockLists;

    delete _UCRC;
}

//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
SetLambdaParam(Double lambdaCenter,Double deltaLambda){
    LambdaCenter = lambdaCenter;
    DeltaLambda  = deltaLambda;
    LambdaMin    = lambdaCenter-0.5*deltaLambda;
    LambdaMax    = lambdaCenter+0.5*deltaLambda;
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
SetTOFOffset(Double tofOffset){
    TOFoffset=tofOffset;
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
SetTOFResolver(Double tofResolver){
    TOFresolver1=tofResolver;
    TOFresolver2=tofResolver;
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
SetTOFResolver(Double tofResolver1,Double tofResolver2){
    TOFresolver1=tofResolver1;
    TOFresolver2=tofResolver2;
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
SetTimeParamAtSource(Double tofMinSource, Double tofMaxSource){
    TOFminSource = tofMinSource;
    TOFmaxSource = tofMaxSource;
    }

//////////////////////////////////////////////////////////
//void UtsusemiFilterTrignetDNA::
//SetInstrumentPosition(Double lchopper, Double lband, Double l1){
//
//    LChopper = lchopper; // high speed chopper[mm]
//    LBand    = lband;    // low speed band-chopper[mm]
//    L1       = l1;       // distance from neutron-source position to sample position[mm]
//    }
//
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
SetChopCondFile(std::string w_file, std::string d_file,std::string cc_file){

    std::cout << "ReadChopCondFile start" << std::endl;
    _UCRC->ImportCaseInfo(cc_file);
    _UCRC->ImportDetectorInfo(d_file);
    _UCRC->ImportWiringInfo(w_file);

    numOfChopCases = _UCRC->PutNumOfCases();

    fastChopperFrequency = _UCRC->PutFastChopperFrequency();
    std::cout << "  freq:" << fastChopperFrequency << std::endl;

    fastChopperNumOfSlit = _UCRC->PutNumOfFastChopperSlit();
    std::cout << "  numOfSlit:" << fastChopperNumOfSlit << std::endl;
    fastChopperSlitWidths.clear();
    fastChopperSlitWidths = _UCRC->PutFastChopperSlitWidth();
    for (UInt4 i=0;i<fastChopperNumOfSlit;i++)
        {
        std::cout << "  slit" << i <<"width:"<< fastChopperSlitWidths[i] << std::endl;
        }

    fastChopperSlitAngles.clear();
    fastChopperSlitAngles = _UCRC->PutFastChopperSlitAngle();
    for (UInt4 i=0;i<fastChopperNumOfSlit;i++)
        {
        std::cout << "  slit" << i <<"angle:"<< fastChopperSlitAngles[i] << std::endl;
        }

    fastChopperMode = _UCRC->PutFastChopperMode();
    std::cout << "  mode:" << fastChopperMode << std::endl;


    L1      =_UCRC->PutL1();
    std::cout << "  L1:"<<L1<<std::endl;

    LChopper=_UCRC->PutLChopper();
    std::cout << "  LChopper:"<<LChopper<<std::endl;

    LBand   =_UCRC->PutLBandChopper();
    std::cout << "  LBand:"<<LBand<<std::endl;

    if (_UCRC->PutTOFbintype()==27 || _UCRC->PutTOFbintype()==28 || _UCRC->PutTOFbintype()==21 ||_UCRC->PutTOFbintype()==2 )
        {
        LambdaCenter = _UCRC->PutLambdaCenter();
        DeltaLambda  = _UCRC->PutDeltaLambda();
        }

    std::cout << "  LambdaCenter:"<<LambdaCenter<<std::endl;
    std::cout << "  DeltaLambda:"<<DeltaLambda<<std::endl;

    LambdaMin    = LambdaCenter-0.5*DeltaLambda;
    std::cout << "  LambdaMin:"<<LambdaMin<<std::endl;

    LambdaMax    = LambdaCenter+0.5*DeltaLambda;
    std::cout << "  LambdaMax:"<<LambdaMax<<std::endl;

    TOFoffset    = _UCRC->PutTOFoffset();

    std::cout << "  TOFoffset:"<<TOFoffset<<std::endl;

    TOFresolver1  = _UCRC->PutTOFResolver1();

    std::cout << "  TOFresolver1:"<<TOFresolver1<<std::endl;

    TOFresolver2  = _UCRC->PutTOFResolver2();

    std::cout << "  TOFresolver2:"<<TOFresolver2<<std::endl;

    TOFminSource = _UCRC->PutTOFSourceMin();

    std::cout << "  TOFminSource:"<<TOFminSource<<std::endl;

    TOFmaxSource = _UCRC->PutTOFSourceMax();

    std::cout << "  TOFmaxSource:"<<TOFmaxSource<<std::endl;

    std::cout << "ReadChopCondFile end" << std::endl;

    isChopCondInfoReady=true;
}
//////////////////////////////////////////////////////////
Int4 UtsusemiFilterTrignetDNA::
LoadTrignetChopEventFile( UInt4 index, std::vector<std::string> evt_files, std::vector<std::string> t0b_files ){

ReadTrignetChopEvent(evt_files,t0b_files ,index);
return 0;
}

//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ReadTrignetChopEvent( std::vector<std::string> trig_event_files, std::vector<std::string> trig_t0_files, UInt4 index ){
    isChopTrigTableReady=false;
    bool debug = false;

    T0TreatToolsNeunet *TT = new T0TreatToolsNeunet();
    Int4 ret = TT->readT0IndexEvent( trig_t0_files );
    if (ret<0){
    std::cout << MessageTag + "ReadTrigEvent >> fails to read T0Index File" << std::endl;
    return;
    }
    std::vector<UInt8> T0Table = TT->putVectorT0Index();
    delete TT;

    if ((T0Table.size()==1)&&(T0Table[0]==0)) return;
    if (!(isChopCondInfoReady)) return;

    std::vector<UInt4> trig_event_files_size( trig_event_files.size(), 0 );
    for (UInt4 i=0; i<trig_event_files.size(); i++){
    const boost::filesystem::path trig_event_files_path( trig_event_files[i].c_str() );
    const boost::uintmax_t size = boost::filesystem::file_size(trig_event_files_path);
    trig_event_files_size[i] = size;
    }

    ClearChopCaseTables(index, true);
    ClearChopPIDLists(index, true);
    ClearChopICLists(index, true);

    std::vector<FILE*> fp_list( trig_event_files.size() );
    for (UInt4 i=0; i<trig_event_files.size(); i++)
    fp_list[i] = fopen( trig_event_files[i].c_str(), "rb" );

    UInt4 ReadingNumOfEvents = T0Table[0];
    UInt4 ind = 0;

    if (fseek( fp_list[ind], ReadingNumOfEvents*_eventSize, SEEK_SET )!=0){
    std::string msg = MessageTag+"ReadTrigEvent : Cannot read enough event data from file";
    std::cout << msg << std::endl;
    return;
    }
    // The block of event-data before first T0-data should be removed.
    size_t ii;
    UInt4 ReadingStep = 1500;

    UInt4 ReadingTimes = T0Table.size() / ReadingStep;
    UInt4 StepRemainder = T0Table.size() % ReadingStep;

    if( StepRemainder==0 ){
    StepRemainder = ReadingStep;
    ReadingTimes = ReadingTimes -1;
    }

    std::vector<UInt4> NewT0( ReadingStep+1, 0.0 );

    StringTools *_stools = new StringTools();

    bool isRead = true;
    bool isReadLast = true;
    UInt4 current_posi = 0;
    for( UInt4 k=0; k<ReadingTimes; k++ ){
        ReadingNumOfEvents = T0Table[(k+1)*ReadingStep] - T0Table[k*ReadingStep];
        UInt4 StartPoint = T0Table[ k * ReadingStep ];
        UChar *Dat = new UChar [ ReadingNumOfEvents * _eventSize ];


        if ((current_posi+(ReadingNumOfEvents*(_eventSize))) <= trig_event_files_size[ind]){
            ii = fread( Dat, _eventSize, ReadingNumOfEvents, fp_list[ind] );
            if (ii==ReadingNumOfEvents){
            current_posi += ReadingNumOfEvents*(_eventSize);
            }else{
            isRead = false;
            }
        }else{
            if (ind==(fp_list.size()-1)){
            isRead = false;
            }else{
            UInt4 RE_tmp = (trig_event_files_size[ind]-current_posi)/(_eventSize);
            UChar *Dat_tmp = new UChar [RE_tmp*(_eventSize)];
            ii = fread( Dat_tmp, _eventSize, RE_tmp, fp_list[ind] );
            if (ii==RE_tmp){
                for (UInt4 l=0;l<(ii*(_eventSize));l++) Dat[l]=Dat_tmp[l];
            }else{
                isRead = false;
            }
            delete [] Dat_tmp;

            if (isRead){
                ind++;
                RE_tmp = ReadingNumOfEvents - ii;
                UChar *Dat_tmp = new UChar [RE_tmp*(_eventSize)];
                UInt4 ii_tmp = fread( Dat_tmp, _eventSize, RE_tmp, fp_list[ind] );
                if (ii_tmp==RE_tmp){
                for (UInt4 l=0;l<(ii_tmp*(_eventSize));l++) Dat[(ii*(_eventSize))+l]=Dat_tmp[l];
                current_posi = ii_tmp*(_eventSize);
                }else{
                isRead = false;
                }
                delete [] Dat_tmp;
            }
            }
        }

        if (isRead){
            for( UInt4 i=k*ReadingStep; i<=(k+1)*ReadingStep; i++ ){
            NewT0[i-k*ReadingStep] = T0Table[i]-StartPoint ;
            }
            PreChopCondSorting( Dat, NewT0, index );

        }else{
            std::string msg = MessageTag+"ReadTrigEvent : Cannot read enough event data from file (ReadingNumOfEvents,ii)";
            msg+=_stools->UInt4ToString(ReadingNumOfEvents)+","+_stools->UInt4ToString(ii)+")";
            std::cout << msg << std::endl;
            delete [] Dat;
            break;
        }

        delete [] Dat;
    }

    if (isRead){
        ReadingNumOfEvents = T0Table[ T0Table.size()-1 ] - T0Table[ ReadingTimes*ReadingStep ];
        UInt4 StartPoint = T0Table[ ReadingTimes*ReadingStep ];
        UChar *Dat = new UChar [ ReadingNumOfEvents * _eventSize ];

        isReadLast = true;
        if ((current_posi+(ReadingNumOfEvents*(_eventSize))) <= trig_event_files_size[ind]){
            ii = fread( Dat, _eventSize, ReadingNumOfEvents, fp_list[ind] );
            if (ii!=ReadingNumOfEvents) isReadLast = false;
        }else{
            if (ind==(fp_list.size()-1)){
            isReadLast = false;
            }else{
            UInt4 RE_tmp = (trig_event_files_size[ind] - current_posi)/(_eventSize);
            UChar *Dat_tmp = new UChar [RE_tmp*(_eventSize)];
            ii = fread( Dat_tmp, _eventSize, RE_tmp, fp_list[ind] );
            if (ii==RE_tmp){
                for (UInt4 l=0;l<(ii*(_eventSize));l++) Dat[l]=Dat_tmp[l];
            }else{
                isReadLast = false;
            }
            delete [] Dat_tmp;

            if (isReadLast){
                ind++;
                RE_tmp = ReadingNumOfEvents - ii;
                UChar *Dat_tmp = new UChar [RE_tmp*(_eventSize)];
                UInt4 ii_tmp = fread( Dat_tmp, _eventSize, RE_tmp, fp_list[ind] );
                if (ii_tmp==RE_tmp) {
                for (UInt4 l=0;l<(ii_tmp*(_eventSize));l++) Dat[(ii*(_eventSize))+l]=Dat_tmp[l];
                } else {
                isReadLast = false;
                }
                delete [] Dat_tmp;
            }
            }
        }

        if (isReadLast){
            NewT0.clear();
            NewT0.resize( StepRemainder,0 );
            for( UInt4 i=ReadingTimes*ReadingStep; i<ReadingTimes*ReadingStep+StepRemainder; i++ ){
            NewT0[i-ReadingTimes*ReadingStep] = T0Table[i]-StartPoint;
            }
            PreChopCondSorting( Dat, NewT0, index );
        }else{
            std::string msg = MessageTag+"ReadTrigEvent : Cannot read enough event data from file (ReadingNumOfEvents,ii)";
            msg+=_stools->UInt4ToString(ReadingNumOfEvents)+","+_stools->UInt4ToString(ii)+")";
            std::cout << msg << std::endl;
        }
        delete [] Dat;
        }

    std::vector<FILE*>::iterator it = fp_list.begin();
    while(it!=fp_list.end()){
    fclose( *it );
    it++;
    }

    delete _stools;

    if (isReadLast){

    isChopTrigTableReady=true;
    MakeChopCondTable();

    }

}

//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
PreChopCondSorting( const UChar* data, std::vector<UInt4> T0Table, UInt4 index ){

    UInt4 multh_num = MULTH;
    if ( _UCRC->PutTrignetCounterInfo()!=NULL){
        multh_num = 1;
    }

    ClearMulthChopCaseTable(index, multh_num, true);
    ClearMulthChopPIDLists(index, multh_num, true);
    ClearMulthChopICLists(index, multh_num, true);

    UInt4 TableSize = T0Table.size();
    UInt4 size = T0Table[ TableSize-1 ];
    UChar *CopyData = new UChar [ size * _eventSize ];

#ifdef MULTH
    omp_set_num_threads( multh_num );
#endif


#pragma omp parallel for
    for( UInt4 i=0; i<TableSize-1; i++){
    UInt4 Ini = T0Table[i];
    UInt4 DataSize = T0Table[i+1]-T0Table[i];
    UInt4 ThNum = 0;

#ifdef MULTH
    ThNum = omp_get_thread_num();
#endif
    try{
        ChopCondSorting( data+(Ini*_eventSize), DataSize, index, ThNum );
    }
    catch(...){
        std::cout << MessageTag+"preChopCondSorting >> ERROR in preChopCondSorting; ThNum=" << ThNum << std::endl;
    }
    }

    // make _filterChopCaseTable
    std::vector<UInt4> mul_index( multh_num, 0 );
    //UInt4 lastCase = 0;
    UInt4 lastCase = _UCRC->_InitialCase;
    if (_filterChopCaseTables->at(index)->empty()){
    }else{
    std::vector<UInt4> *case_info = _filterChopCaseTables->at(index)->back();
    if ((case_info==NULL)||(case_info->empty())){
    }else{
        lastCase = case_info->at( case_info->size() -2 );
    }
    }
    std::vector<UInt4> flagTable( multh_num, 0 );
    bool isContinue = true;
    while(isContinue){

    UInt8 min_PID = 0;
    UInt4 min_index = 0;
    for (UInt4 i=0;i<multh_num;i++){
        if (flagTable[i]==0){
        min_PID = MulthChopPulseIdLists->at(index)->at(i)->at(mul_index[i]);
        min_index = i;
        break;
        }
    }
    for(UInt4 i=0;i<multh_num;i++){
        if (flagTable[i]==0){
            if (MulthChopPulseIdLists->at(index)->at(i)==NULL){
                flagTable[i]=1;
            }else if ( min_PID>(MulthChopPulseIdLists->at(index)->at(i)->at(mul_index[i])) ){
                min_PID = MulthChopPulseIdLists->at(index)->at(i)->at(mul_index[i]);
                min_index = i;
            }
        }
    }

    if (_filterChopPulseIdLists->at(index)==NULL){
        _filterChopPulseIdLists->at(index) = new std::vector<UInt8>;
        _filterChopInstClockLists->at(index) = new std::vector<Double>;
        _filterChopCaseTables->at(index) = new std::vector< std::vector<UInt4>* >;
    }

    _filterChopPulseIdLists->at(index)->push_back( min_PID );
    _filterChopInstClockLists->at(index)->push_back( MulthChopInstClockLists->at(index)->at(min_index)->at(mul_index[min_index]) );
    std::vector<UInt4> *tmp = new std::vector<UInt4>;

    //ORIGINAL
    //tmp->push_back(lastCase);
    //tmp->push_back(0);


    std::vector<UInt4>* org = MulthChopCaseTable->at(index)->at(min_index)->at(mul_index[min_index]);
    for (UInt4 i=0; i<(org->size()); i+=2){

        //ORIGINAL
        //if (org->at(i)!=lastCase){
        //    tmp->push_back( org->at(i) );
        //    tmp->push_back( org->at(i+1) );
        //    lastCase = org->at(i);
        //}
        //FOR CHOP Mode
        //if (org->at(i)!=0 && org->at(i+1)!=0){
        if (org->at(i)!=0){
            tmp->push_back( org->at(i) );
            tmp->push_back( org->at(i+1) );
            lastCase = org->at(i);
            }
    }
    _filterChopCaseTables->at(index)->push_back( tmp );
    //lastCase = tmp->at( tmp->size()-2 );

    ++mul_index[min_index];
    if (mul_index[min_index]>=MulthChopPulseIdLists->at(index)->at(min_index)->size()) flagTable[min_index]=1;

    UInt4 sum = 0;
    for (UInt4 i=0;i<multh_num; i++) sum+=flagTable[i];
    if (sum==multh_num) isContinue=false;

    }
//AS add for valgrind
delete[] CopyData;
//AS end

}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ChopCondSorting( const UChar* data, UInt4 size, UInt4 index, UInt4 ThNum ){
    bool debug = false;
    std::vector< std::vector< UtsusemiTrignetCondGroup* >* >* ti = _UCRC->PutTrignetInfo();

    UInt4 current_case = 0;
    UInt4 prev_case = 0;

    std::vector<UInt4> *caseTableInAFrame = new std::vector<UInt4>;
    caseTableInAFrame->clear();
    UInt8 pulse_id = 0;
    bool isPulseIdDecoded = false;
    Double clock = 0.0;
    Double first_clock = 0.0;

    for (UInt4 i=0; i<size; i++){
        UInt4 evt_index = i*_eventSize;
        UChar evt = *(data+evt_index);
        // if T0 event
        if ( _UTD->isHeaderT0(evt) ){
            pulse_id = _UTD->decodePulseIdEvent( data+evt_index );
            isPulseIdDecoded = true;
        }

        // if clock event
        if ( _UTD->isHeaderClock(evt) ) {
            clock = _UTD->decodeInstClockEvent( data+evt_index );
            if (first_clock==0.0) first_clock = clock;
        }

        // if TrigEvent
        if ( _UTD->isTrigEvent(evt) ){
            std::vector<UInt4> *values = new std::vector<UInt4> (12,0);
            if ( -1<( _UTD->DecodeTrigEvent( (data+evt_index), values, index ) ) ){
                UInt4 tof  = values->at(0);
                UInt4 ind  = values->at(1);
                UInt4 sid1 = values->at(2);
                UInt4 sid2 = values->at(3);
                std::vector<UInt4>* cond = new std::vector<UInt4>(8,0);
                for (UInt4 i=4;i<(values->size());i++){
                    cond->at(i-4)=values->at(i);
                    }
                bool isDecided=false;
                bool isDecidedTmp=false;
                current_case = 0;
                if (ti!=NULL){
                    for(UInt4 caseNo=0;caseNo<ti->size();caseNo++){
                        if (ti->at(caseNo)==NULL) continue;
                        for (UInt4 i=0;i<ti->at(caseNo)->size();i++){

                            UtsusemiTrignetCondGroup* utg = ti->at(caseNo)->at(i);
                            if (utg==NULL) continue;

                            Int4 filterflag = utg->TrigFilter(index,sid1,sid2,cond);

                            if ( filterflag==0  ) continue;
                            if ( filterflag==-1 ){
                                current_case = 0;
                                isDecidedTmp = true;
                                }else{
                                current_case = caseNo;
                                isDecided = true;
                                }
                            if (isDecided) break;
                        }
                        if (isDecided) break;
                        }
                    if (isDecided){
                    }else if (isDecidedTmp){
                    current_case = 0;
                    }else{
                    current_case = prev_case;
                    }
                }
                delete cond;
            //ORIGINAL
                //if (current_case!=prev_case){
                //    caseTableInAFrame->push_back( current_case );
                //    caseTableInAFrame->push_back( tof );
                //    prev_case = current_case;
                //}

            //FOR CHOP Mode
                if (current_case!=0){
                    caseTableInAFrame->push_back( current_case );
                    caseTableInAFrame->push_back( tof );
                }
            }
            delete values;
        }
        }

    if (isPulseIdDecoded){
        if (MulthChopPulseIdLists->at(index)->at(ThNum)==NULL){
            MulthChopPulseIdLists->at(index)->at(ThNum)= new std::vector<UInt8>;
            MulthChopInstClockLists->at(index)->at(ThNum)= new std::vector<Double>;
            MulthChopCaseTable->at(index)->at(ThNum)=new std::vector< std::vector<UInt4>* >;
            }
        MulthChopPulseIdLists->at(index)->at(ThNum)->push_back( pulse_id );
        MulthChopInstClockLists->at(index)->at(ThNum)->push_back( clock );
        MulthChopCaseTable->at(index)->at(ThNum)->push_back( caseTableInAFrame );
        }else{
        std::cout << MessageTag+"CaseSorting :: data includes no PulseId" << std::endl;
        }

}

//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
MakeChopCondTable(){

    /* unify all CaseTables */
    isFilterChopReady=false;
    //std::cout << "@@@ UtsusemiFilterTrignet::MakeCaseTable start" << std::endl;
    if (isChopTrigTableReady){
        ChopClear();
        //std::cout << "@@@ UtsusemiFilterTrignet::MakeCaseTable step1" << std::endl;
        filterChopCaseTable = new std::vector< std::vector<UInt4>* >;
        for (UInt4 i=0;i<_filterChopCaseTables->at(0)->size();i++){
            filterChopCaseTable->push_back( new std::vector<UInt4> );
            for (UInt4 j=0;j<_filterChopCaseTables->at(0)->at(i)->size();j++){
            filterChopCaseTable->back()->push_back( _filterChopCaseTables->at(0)->at(i)->at(j) );
            }
            filterChopPulseIdList.push_back( _filterChopPulseIdLists->at(0)->at(i) );
            filterChopInstClockList.push_back( _filterChopInstClockLists->at(0)->at(i)*4.0e7 );
            //filterChopInstClockList.push_back( _filterChopInstClockLists->at(0)->at(i) );
        }
    }
    isFilterChopReady=true;
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ClearMulthChopCaseTable(UInt4 index, UInt4 multh_num, bool makeNew){
    if (MulthChopCaseTable!=NULL){
    if (index<MulthChopCaseTable->size()){
        if (MulthChopCaseTable->at(index)!=NULL){
        for (UInt4 i=0;i<MulthChopCaseTable->at(index)->size();i++){
            if (MulthChopCaseTable->at(index)->at(i)!=NULL) {
            for (UInt4 j=0;j<MulthChopCaseTable->at(index)->at(i)->size();j++){
                if (MulthChopCaseTable->at(index)->at(i)->at(j)!=NULL){
                delete MulthChopCaseTable->at(index)->at(i)->at(j);
                }
            }
            delete MulthChopCaseTable->at(index)->at(i);
            }
        }
        delete MulthChopCaseTable->at(index);
        MulthChopCaseTable->at(index) = NULL;
        }
    }
    }

    if (makeNew){
    if (MulthChopCaseTable==NULL) MulthChopCaseTable = new std::vector< std::vector< std::vector< std::vector<UInt4>* >* >* >;
    if (MulthChopCaseTable->size()<(index+1)) MulthChopCaseTable->resize( (index+1), NULL);
    if (MulthChopCaseTable->at(index)==NULL)  MulthChopCaseTable->at(index) = new std::vector< std::vector< std::vector<UInt4>* >* >( multh_num, NULL );
    }
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ClearMulthChopPIDLists( UInt4 index, UInt4 multh_num, bool makeNew ){
    if (MulthChopPulseIdLists!=NULL){
    if (index<MulthChopPulseIdLists->size()){
        if (MulthChopPulseIdLists->at(index)!=NULL){
        for (UInt4 i=0;i<MulthChopPulseIdLists->at(index)->size();i++){
            if (MulthChopPulseIdLists->at(index)->at(i)!=NULL){
            delete MulthChopPulseIdLists->at(index)->at(i);
            }
        }
        delete MulthChopPulseIdLists->at(index);
        MulthChopPulseIdLists->at(index) = NULL;
        }
    }
    }

    if (makeNew){
    if (MulthChopPulseIdLists==NULL) MulthChopPulseIdLists = new std::vector< std::vector< std::vector<UInt8>* >* >;
    if (MulthChopPulseIdLists->size()<(index+1)) MulthChopPulseIdLists->resize( (index+1), NULL);
    if (MulthChopPulseIdLists->at(index)==NULL)  MulthChopPulseIdLists->at(index) = new std::vector< std::vector<UInt8>* >( multh_num, NULL );
    }
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ClearMulthChopICLists( UInt4 index, UInt4 multh_num, bool makeNew ){
    if (MulthChopInstClockLists!=NULL){
    if (index<MulthChopInstClockLists->size()){
        if (MulthChopInstClockLists->at(index)!=NULL){
        for (UInt4 i=0;i<MulthChopInstClockLists->at(index)->size();i++){
            if (MulthChopInstClockLists->at(index)->at(i)!=NULL){
            delete MulthChopInstClockLists->at(index)->at(i);
            }
        }
        delete MulthChopInstClockLists->at(index);
        MulthChopInstClockLists->at(index) = NULL;
        }
    }
    }

    if (makeNew){
    if (MulthChopInstClockLists==NULL) MulthChopInstClockLists = new std::vector< std::vector< std::vector<Double>* >* >;
    if (MulthChopInstClockLists->size()<(index+1)) MulthChopInstClockLists->resize( (index+1), NULL);
    MulthChopInstClockLists->at(index) = new std::vector< std::vector<Double>* >( multh_num, NULL );
    }
}

//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ClearAllMulthChopTables(UInt4 index, UInt4 multh_num, bool makeNew){
    ClearMulthChopCaseTable(index, multh_num, makeNew);
    ClearMulthChopPIDLists(index, multh_num, makeNew);
    ClearMulthChopICLists(index, multh_num, makeNew);
}

//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ClearChopCaseTables(UInt4 index, bool makeNew){

    if (_filterChopCaseTables!=NULL){
        if (index<_filterChopCaseTables->size()){
            if (_filterChopCaseTables->at(index)!=NULL){
                for (UInt4 j=0;j<_filterChopCaseTables->at(index)->size();j++){
                    if (_filterChopCaseTables->at(index)->at(j)!=NULL){
                        delete _filterChopCaseTables->at(index)->at(j);
                        }
                    }
                delete _filterChopCaseTables->at(index);
                _filterChopCaseTables->at(index)=NULL;
                }
            }
        }

    if (makeNew){
        if (_filterChopCaseTables==NULL) _filterChopCaseTables = new std::vector< std::vector< std::vector<UInt4>* >* >;
        if (_filterChopCaseTables->size()<(index+1)) _filterChopCaseTables->resize( (index+1), NULL );
        if (_filterChopCaseTables->at(index)==NULL)  _filterChopCaseTables->at(index) = new std::vector< std::vector<UInt4>* >;
        }
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ClearChopPIDLists(UInt4 index, bool makeNew){
    if (_filterChopPulseIdLists!=NULL){
    if (index<_filterChopPulseIdLists->size()){
        if (_filterChopPulseIdLists->at(index)!=NULL){
        delete _filterChopPulseIdLists->at(index);
        }
    }
    }
    if (makeNew){
    if (_filterChopPulseIdLists==NULL) _filterChopPulseIdLists = new std::vector< std::vector<UInt8>* >;
    if (_filterChopPulseIdLists->size()<(index+1)) _filterChopPulseIdLists->resize( (index+1), NULL );
    if (_filterChopPulseIdLists->at(index)==NULL)  _filterChopPulseIdLists->at(index) = new std::vector<UInt8>;
    }
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ClearChopICLists(UInt4 index, bool makeNew){
    if (_filterChopInstClockLists!=NULL){
    if (index<_filterChopInstClockLists->size()){
        if (_filterChopInstClockLists->at(index)!=NULL){
        delete _filterChopInstClockLists->at(index);
        }
    }
    }

    if (makeNew){
    if (_filterChopInstClockLists==NULL) _filterChopInstClockLists = new std::vector< std::vector<Double>* >;
    if (_filterChopInstClockLists->size()<(index+1)) _filterChopInstClockLists->resize( (index+1), NULL );
    if (_filterChopInstClockLists->at(index)==NULL)  _filterChopInstClockLists->at(index) = new std::vector<Double>;
    }
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ChopClear(){
    if (filterChopCaseTable!=NULL){
    for (UInt4 i=0;i<filterChopCaseTable->size();i++)
        if (filterChopCaseTable->at(i)!=NULL)
        delete filterChopCaseTable->at(i);
    delete filterChopCaseTable;
    }
    filterChopPulseIdList.clear();
    filterChopInstClockList.clear();
}


//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ClearAllChopTables(UInt4 index, bool makeNew){
    ClearChopCaseTables(index, makeNew);
    ClearChopPIDLists(index, makeNew);
    ClearChopICLists(index, makeNew);
}

//////////////////////////////////////////////////////////
Int4 UtsusemiFilterTrignetDNA::
ReadCaseEvent( UInt4 index, std::vector<std::string> evt_files, std::vector<std::string> t0b_files ){
    ReadTrigEvent( evt_files, t0b_files, index );
    if (isFilterReady){
    return 0;
    }else{
    return -1;
    }
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
ReadTrigEvent( std::vector<std::string> trig_event_files, std::vector<std::string> trig_t0_files, UInt4 index ){
    UtsusemiFilterTrignet::ReadTrigEvent( trig_event_files,  trig_t0_files, index );
    MakeCaseTable();
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::MakeCaseTable()
    {
    if (filterCaseTable==NULL)
        UtsusemiFilterTrignet::MakeCaseTable();
    MergeCaseTable();
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::MergeCaseTable()
    {
    //Choppert Trignet => filterChopCaseTable => ChopperCaseTables1, ChopperCaseTables2
    std::vector<std::vector<UInt4> > ChopperCaseTables1; //For fast-chopper-1
    std::vector<std::vector<UInt4> > ChopperCaseTables2; //For fast-chopper-2
    CaseExtractionFromCaseTable(ChopperCaseTables1,ChopperCaseTables2);

    //TOF slit
    std::vector<std::vector<Double> > tofSlitVect;
    if (fastChopperMode==1)
         {
         tofSlitVect    = CalcTOFSlit(ChopperCaseTables1,filterChopInstClockList);
         }
    else
         {
         tofSlitVect    = CalcTOFSlit(ChopperCaseTables1,ChopperCaseTables2,filterChopInstClockList);
         }

    //TOF range
    //std::vector<std::vector<Double> > tofSampleRange = CalcTOFRange(tofSlitVect);
    std::vector<std::vector<Double> > tofSampleRange;
    if (fastChopperMode==1)
         {
         tofSampleRange  = CalcTOFRange(ChopperCaseTables1,filterChopInstClockList);
         }
    else
         {
         tofSampleRange  = CalcTOFRange(ChopperCaseTables1,ChopperCaseTables2,filterChopInstClockList);
         }

    //std::vector<std::vector<Double> > tofSampleRangeDebug = CalcTOFRangeDebug(tofSlitVect);

    DumpCaseTable(tofSlitVect,     "TOFSlit ");
    DumpCaseTable(tofSampleRange,  "TOFRange");

    //DumpCaseTable(tofSampleRangeDebug, "T3");
    UInt4 fvecSize = filterCaseTable->size();
    for (UInt4 i=0;i<fvecSize;i++)
        {
        std::vector <UInt4>* tmpVec = new std::vector<UInt4>;
        //Add Header
        UInt4 sign  = 0;
        UInt4 shift = 0;

        //UInt4 chop1VecSize=tofSampleRangeDebug.at(i).size();
        UInt4 chop1VecSize=tofSampleRange.at(i).size();
        Int4 k=chop1VecSize-1;
        UInt4 filtVecSize = filterCaseTable->at(i)->size();
        for (UInt4 j=filtVecSize-1; j>0; j-=2){
            UInt4 boundary = filterCaseTable->at(i)->at(j);   // boundary from large value to small value
            bool hasData = false;
            while (k>0){
                //UInt4 chopValUp  = UInt4(tofSampleRangeDebug.at(i).at(k));
                UInt4 chopValUp  = UInt4(tofSampleRange.at(i).at(k));
                k-=1;

                //UInt4 chopValLow = UInt4(tofSampleRangeDebug.at(i).at(k));
                UInt4 chopValLow = UInt4(tofSampleRange.at(i).at(k));
                shift=tofSlitVect.at(i).at(UInt4(k/2));
                k-=1;

                if (chopValLow <boundary){
                    k+=2;
                    break;
                    }

                // ---Shift value Calcuration End
                tmpVec->push_back(shift);          // delta TOF for fastChopper
                tmpVec->push_back(sign);           // sign of delta TOF
                tmpVec->push_back(chopValUp );     // TOF max for fastChopper
                tmpVec->push_back(chopValLow);     // TOF min for fastChopper
                hasData=true;
                }

            if (hasData){
                tmpVec->push_back(boundary);                          // boundary
                //tmpVec->push_back(filterCaseTable->at(i)->at(j-1));   // caseNo
                tmpVec->push_back(1);                                   // caseNo Fix
                tmpVec->push_back(fastChopperModeTag);
                }

            if (j==1) break;
            }

        reverse(tmpVec->begin(),tmpVec->end());
        std::swap(filterCaseTable->at(i),tmpVec); //swap tmpVec (new table) and filterCaseTable->at(i) (old)
        delete tmpVec;
        }

    //DumpCaseTable(filterCaseTable,"C1");

    }
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::MergeCaseTableTest()
    {

    std::vector<std::vector<UInt4> > ChopperCaseTables1; //For fast-chopper-1
    std::vector<std::vector<UInt4> > ChopperCaseTables2; //For fast-chopper-2

    CaseExtractionFromCaseTable(ChopperCaseTables1,ChopperCaseTables2);

    //DumpCaseTable(filterCaseTable,"F1");


    UInt4 fvecSize = filterCaseTable->size();
    for (UInt4 i=0;i<fvecSize;i++)
        {
        std::vector <UInt4>* tmpVec = new std::vector<UInt4>;
        //Add Header
        UInt4 min   = 10;
        UInt4 max   = 100;
        UInt4 sign  = 1;
        UInt4 shift = 100;

        UInt4 chop1VecSize=ChopperCaseTables1.at(i).size();

        Int4 k=chop1VecSize-1;
        UInt4 filtVecSize = filterCaseTable->at(i)->size();

        for (UInt4 j=filtVecSize-1; j>0; j-=2)
            {
            UInt4 boundary = filterCaseTable->at(i)->at(j);   // boundary from large value to small value

            while (k>-1)
                {

                //---for test start,
                UInt4 chopValLow=ChopperCaseTables1.at(i).at(k); // boundary from large value to small value
                UInt4 chopValUp;
                if (k==chop1VecSize-1)
                    chopValUp=chopValLow+177760;
                else
                    chopValUp=ChopperCaseTables1.at(i).at(k+1);
                //---for test end,

                if (chopValLow <boundary)
                    break;

                // for test -start
                if (9000*40<chopValLow && chopValLow<12000*40)
                    {
                    shift=0;
                    sign =1;
                    }
                else if (18000*40<chopValLow && chopValLow<22000*40)
                    {
                    shift=0;
                    sign =0;
                    }
                else if (32000*40<chopValLow && chopValLow<34000*40)
                    {
                    shift=0;
                    sign =0;
                    }
                else
                    {
                    shift=0;
                    sign=1;
                    }
                // for test -end
                tmpVec->push_back(shift);     // delta TOF for fastChopper
                tmpVec->push_back(sign);           // sign of delta TOF
                tmpVec->push_back(chopValUp );     // TOF max for fastChopper
                tmpVec->push_back(chopValLow);     // TOF min for fastChopper
                if (k==0)
                    break;
                k--;
                }

            tmpVec->push_back(boundary);                        // boundary
            tmpVec->push_back(filterCaseTable->at(i)->at(j-1));   // caseNo
            tmpVec->push_back(fastChopperModeTag);

            if (j==1) break;
            }

        reverse(tmpVec->begin(),tmpVec->end());
        std::swap(filterCaseTable->at(i),tmpVec); //swap tmpVec (new table) and filterCaseTable->at(i) (old)
        delete tmpVec;
        }

    }

//////////////////////////////////////////////////////////

void UtsusemiFilterTrignetDNA::CaseExtractionFromCaseTable(std::vector<std::vector<UInt4> > &ChopperCaseTables1,std::vector<std::vector<UInt4> > &ChopperCaseTables2)
    {
    if (filterChopCaseTable!=NULL)
        {
        for (UInt4 i=0;i<filterChopCaseTable->size();i++){
            std::vector<UInt4> tmpTable1;
            std::vector<UInt4> tmpTable2;
            for (UInt4 j=0;j<filterChopCaseTable->at(i)->size();j+=2)
                {
                if (filterChopCaseTable->at(i)->at(j)==1)
                    {
                    tmpTable1.push_back(filterChopCaseTable->at(i)->at(j+1));
                    }
                if (filterChopCaseTable->at(i)->at(j)==2)
                    {
                    tmpTable2.push_back(filterChopCaseTable->at(i)->at(j+1));
                    }
                }

            ChopperCaseTables1.push_back(tmpTable1);
            ChopperCaseTables2.push_back(tmpTable2);
            }
        }
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::DumpCaseTable(std::vector<Double> ChopperCaseTables1,std::string tag)
{
        for (UInt4 i=0;i<ChopperCaseTables1.size();i++){
            std::cout << tag <<" : "<< i <<"   \t: "<<ChopperCaseTables1.at(i)<<std::endl;
            if (i>15) break;
            }
        std::cout << std::endl;
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::DumpCaseTable(std::vector<Double> ChopperCaseTables1,std::string tag,Double offset)
{
        for (UInt4 i=0;i<ChopperCaseTables1.size();i++){
            std::cout << tag <<" : "<< i <<"   \t: "<<ChopperCaseTables1.at(i)-offset<<std::endl;
            if (i>15) break;
            }
        std::cout << std::endl;
}
//////////////////////////////////////////////////////////

void UtsusemiFilterTrignetDNA::DumpCaseTable(std::vector<std::vector<Double> > ChopperCaseTables1,std::string tag)
{
        for (UInt4 i=0;i<ChopperCaseTables1.size();i++){
            std::cout << tag <<" : "<< std::setw(2) << i <<" : ";
            for (UInt4 j=0;j<ChopperCaseTables1.at(i).size();j++)
                {
                if (fastChopperModeTag == (UInt4)ChopperCaseTables1.at(i).at(j))
                    std::cout << "  #" << " ";
                else
                    //std::cout <<  std::fixed << std::setprecision(2)<< std::setw(12) << std::right << ChopperCaseTables1.at(i).at(j) << ",";
                    std::cout << std::setw(9)<< ChopperCaseTables1.at(i).at(j)/40.0 << ", ";
                }
            std::cout << std::endl;
            if (i>9) break;
            }
        std::cout << std::endl;
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::DumpCaseTable(std::vector<std::vector<UInt4> > ChopperCaseTables1,std::string tag)
{
        for (UInt4 i=0;i<ChopperCaseTables1.size();i++){
            std::cout << tag <<" : "<< i <<" : ";
            for (UInt4 j=0;j<ChopperCaseTables1.at(i).size();j++)
                {
                if (fastChopperModeTag == (UInt4)ChopperCaseTables1.at(i).at(j))
                    std::cout << "  #" << " ";
                else
                    //std::cout << std::setw(12) << std::right << ChopperCaseTables1.at(i).at(j) << ",";
                    std::cout << std::right << ChopperCaseTables1.at(i).at(j) << ", ";
                }
            std::cout << std::endl;
            if (i>9) break;
            }
        std::cout << std::endl;
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::DumpCaseTable(std::vector< std::vector<UInt4>* >* ChopperCaseTables1,std::string tag)
{
        for (UInt4 i=0;i<ChopperCaseTables1->size();i++){
            std::cout << tag <<" : "<< i <<std::endl;
            for (UInt4 j=0;j<ChopperCaseTables1->at(i)->size();j++)
                {
                if (fastChopperModeTag == (UInt4)ChopperCaseTables1->at(i)->at(j))
                    std::cout << "  #" << " ";
                else
                    //std::cout <<  std::setw(12) << std::right << ChopperCaseTables1->at(i)->at(j) << ",";
                    std::cout << ChopperCaseTables1->at(i)->at(j) << ",";
                }
            std::cout << std::endl;
            if (i>15) break;
            }
        std::cout << std::endl;
}
//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::DumpCaseTable(std::vector<std::vector<UInt4> > ChopperCaseTables1, std::vector<std::vector<Double> > ChopperCaseTables2)
    {
   if (filterPulseIdList.size()!=0)
        {
        //std::cout << "DEBUG---1"<<std::endl;
        for (UInt4 i=0;i<filterPulseIdList.size();i++){
            std::cout << "FP1: " << i << ":::" << filterPulseIdList.at(i) <<std::endl;
            std::cout << "D1 : " << i << ":::";
            for (UInt4 j=0;j<filterCaseTable->at(i)->size();j++)
                {
                std::cout << filterCaseTable->at(i)->at(j) << ", ";
                }
            std::cout << std::endl;
            if (i>15) break;
            }
        std::cout << std::endl;
        }

    if (filterChopPulseIdList.size()!=0)
        {
        for (UInt4 i=0;i<filterChopPulseIdList.size();i++)
            {
            std::cout <<"FP2: "<< i << ":::" << filterChopPulseIdList.at(i) <<std::endl;
            std::cout <<"TP2: "<< i << ":::" << filterChopInstClockList.at(i) <<std::endl;
            if (i<ChopperCaseTables1.size())
                {
                std::cout << "D2 : ";
                for (UInt4 j=0;j<ChopperCaseTables1.at(i).size();j++)
                    {
                    std::cout << ChopperCaseTables1.at(i).at(j)<<"\t" ;
                    }
                std::cout << std::endl;
                }

            if (i<ChopperCaseTables2.size())
                {
                std::cout << "D3 : ";
                for (UInt4 j=0;j<ChopperCaseTables2.at(i).size();j++)
                    {
                    std::cout << ChopperCaseTables2.at(i).at(j)<<"\t" ;
                    }
                std::cout << std::endl;
                }
            //if (i>15) break;
            }
        std::cout << std::endl;
        }
    }
//////////////////////////////////////////////////////////
UInt4 UtsusemiFilterTrignetDNA::
GetCaseFromTof( const UInt4 pixelId, Double* tof, std::vector<UInt4>* caseVec )
    {
    UInt4 ret=0;
    UInt4 num_of_cases = caseVec->size();
    if (num_of_cases==1){
        ret = caseVec->at(0);
        }
    else{
        if (caseVec->at(0)==fastChopperModeTag){
            // Fast Chopper Mode
            Int4 i,j;
            Double shift=0.0;
            UInt4 factor=0;

//std::cout << (*tof) << std::endl;

            UInt4 j0=caseVec->size();

            Double tofSample;
            if (_tofL2L3.size()>pixelId){
                tofSample=(*tof)-_tofL2L3[pixelId] - TOFoffset;
                }
            else{
                tofSample=(*tof) - TOFoffset;
                }
            for (i=((caseVec->size())-1); i>-1; i--){
                if ((caseVec->at(i))==fastChopperModeTag){
                    if (j0-i>=7){
                        ret = caseVec->at(i+1);
                        j=i;
                        while(j<=j0-7){
                            if ( ( tofSample*40.0 >=caseVec->at(j+3) ) && (caseVec->at(j+4)>tofSample*40.0 ) ){
                                if (caseVec->at(j+5)==0){
                                    shift = -1.0*Double(caseVec->at(j+6))/40.0;
                                    }
                                else{
                                    shift =  Double(caseVec->at(j+6))/40.0;
                                    }
                                factor=1;
                                break;
                                }
                            j+=4;
                            }
                        }
                     else
                        {
                        }
                    j0=i;
                    }
                if (factor==1){
                    break;
                    }
                }
            // DEBUG //
            //if (factor==1)
            //    std::cout <<(*tof)*40<<"\t#"<<factor<<"#"<<shift<<"#"<<(*tof)+shift+1.0<<std::endl;
            /*
            if (_tofL2L3.size()>pixelId)
                {
                if (pixelId==5728)
                    {
                    std::cout << "pid:" << pixelId <<std::endl;
                    std::cout << "shift:" << shift <<std::endl;
                    std::cout << "tof:" << (*tof )<<std::endl;
                    std::cout << "tofL2L3:" << _tofL2L3[pixelId] <<std::endl;
                    std::cout << "tofSample:" << tofSample <<std::endl;
                    }
                }
            */
            (*tof) += shift;
            (*tof) -= TOFoffset; //us
            (*tof) *= factor;
            //(*tof) += 1.0;
            }
        else
            {
            // Original Mode
            for (UInt4 i=((caseVec->size())-1); i>0; i-=2)
                {
                if ( (*tof)*40.0 >= (caseVec->at(i) ) )
                    {// Unit of tof in cases is [clock(25nano-sec)]
                    ret = caseVec->at(i-1);
                    break;
                    }
                }
            //*tof+=1.0;
            }
        }

    return ret;
    }

//////////////////////////////////////////////////////////
void UtsusemiFilterTrignetDNA::
SetTOFL2L3(std::vector <Double> pixelTOFL2L3)
{
_tofL2L3=pixelTOFL2L3;
}
