#ifndef UTSUSEMIFILTERWHSCDNA
#define UTSUSEMIFILTERWHSCDNA

#include "Header.hh"
//#include "UtsusemiFilterBase.hh"
#include "UtsusemiFilterTrignet.hh"
//#include "UtsusemiCaseInfoReaderTrignet.hh"
#include "UtsusemiChopCondInfoReaderTrignet.hh"
#include "UtsusemiTrignetDictionary.hh"
#include "UtsusemiTrignetEventDecoderBase.hh"
#include "UtsusemiFilterTrignetConditionDNA.hh"
#include "T0TreatToolsNeunet.hh"
#include "StringTools.hh"
#include <boost/filesystem.hpp>
#include <limits>
#ifdef MULTH
    #include <omp.h>
#endif

//////////////////////////////////
// UtsusemiFilterHSChopperDNA
/////////////////////////////////

//!
/*!
 *
 */

class UtsusemiFilterHSChopperDNA:
    public UtsusemiFilterTrignet,public UtsusemiFilterTrignetConditionDNA
{
private:
    std::string MessageTag;

    UInt4 numOfChopCases;

    std::vector<Double> _tofL2L3;

    std::vector<Double> _TOFslit;

    std::vector<Double> _TOFrange;

public:
    UtsusemiFilterHSChopperDNA();

    ~UtsusemiFilterHSChopperDNA();

    void SetTOFL2L3(std::vector <Double> pixelTOFL2L3);

    void SetChopCondFile(std::string w_file, std::string d_file,std::string cc_file);

    void SetLambdaParam(Double lambdaCenter,Double deltaLambda);

    void SetTOFOffset(Double offset);

    void SetTOFResolver(Double offset);

    void SetTOFResolver(Double offset1,Double offset2);

    void SetTimeParamAtSource(Double tofSourceMin, Double tofSourceMax);

    //void SetInstrumentPosition(Double lchopper, Double lband, Double l1);

    bool isChopCondInfoReady;

    void MakeDummyCaseTable();

    UtsusemiChopCondInfoReaderTrignet* _UCRC;

    UInt4 GetCaseFromTof( const UInt4 pixelId, Double* tof, std::vector<UInt4>* caseVec );

};
#endif
