#include "UtsusemiFilterHSChopperDNA.hh"
//////////////////////////////////////////////////////////
UtsusemiFilterHSChopperDNA::
UtsusemiFilterHSChopperDNA(){
    _UCRC = new UtsusemiChopCondInfoReaderTrignet();
    MessageTag = "UtsusemiFilterTrignet::";
    isChopCondInfoReady = false;
}
//////////////////////////////////////////////////////////
UtsusemiFilterHSChopperDNA::
~UtsusemiFilterHSChopperDNA(){

    delete _UCRC;
}

//////////////////////////////////////////////////////////
void UtsusemiFilterHSChopperDNA::
SetLambdaParam(Double lambdaCenter,Double deltaLambda){
    LambdaCenter = lambdaCenter;
    DeltaLambda  = deltaLambda;
    LambdaMin    = lambdaCenter-0.5*deltaLambda;
    LambdaMax    = lambdaCenter+0.5*deltaLambda;
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterHSChopperDNA::
SetTOFOffset(Double tofOffset){
    TOFoffset=tofOffset;
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterHSChopperDNA::
SetTOFResolver(Double tofResolver){
    TOFresolver1=tofResolver;
    TOFresolver2=tofResolver;
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterHSChopperDNA::
SetTOFResolver(Double tofResolver1,Double tofResolver2){
    TOFresolver1=tofResolver1;
    TOFresolver2=tofResolver2;
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterHSChopperDNA::
SetTimeParamAtSource(Double tofMinSource, Double tofMaxSource){
    TOFminSource = tofMinSource;
    TOFmaxSource = tofMaxSource;
    }

//////////////////////////////////////////////////////////
//void UtsusemiFilterHSChopperDNA::
//SetInstrumentPosition(Double lchopper, Double lband, Double l1){
//
//    LChopper = lchopper; // high speed chopper[mm]
//    LBand    = lband;    // low speed band-chopper[mm]
//    L1       = l1;       // distance from neutron-source position to sample position[mm]
//    }
//
//////////////////////////////////////////////////////////
void UtsusemiFilterHSChopperDNA::
SetChopCondFile(std::string w_file, std::string d_file,std::string cc_file){

    std::cout << "ReadChopCondFile start" << std::endl;
    _UCRC->ImportCaseInfo(cc_file);
    _UCRC->ImportDetectorInfo(d_file);
    _UCRC->ImportWiringInfo(w_file);

    numOfChopCases = _UCRC->PutNumOfCases();

    fastChopperFrequency = _UCRC->PutFastChopperFrequency();
    std::cout << "  freq:" << fastChopperFrequency << std::endl;

    fastChopperNumOfSlit = _UCRC->PutNumOfFastChopperSlit();
    std::cout << "  numOfSlit:" << fastChopperNumOfSlit << std::endl;
    fastChopperSlitWidths.clear();
    fastChopperSlitWidths = _UCRC->PutFastChopperSlitWidth();
    for (UInt4 i=0;i<fastChopperNumOfSlit;i++)
        {
        std::cout << "  slit" << i <<"width:"<< fastChopperSlitWidths[i] << std::endl;
        }

    fastChopperSlitAngles.clear();
    fastChopperSlitAngles = _UCRC->PutFastChopperSlitAngle();
    for (UInt4 i=0;i<fastChopperNumOfSlit;i++)
        {
        std::cout << "  slit" << i <<"angle:"<< fastChopperSlitAngles[i] << std::endl;
        }

    fastChopperMode = _UCRC->PutFastChopperMode();
    std::cout << "  mode:" << fastChopperMode << std::endl;


    L1      =_UCRC->PutL1();
    std::cout << "  L1:"<<L1<<std::endl;

    LChopper=_UCRC->PutLChopper();
    std::cout << "  LChopper:"<<LChopper<<std::endl;

    LBand   =_UCRC->PutLBandChopper();
    std::cout << "  LBand:"<<LBand<<std::endl;

    if (_UCRC->PutTOFbintype()==27 || _UCRC->PutTOFbintype()==28 || _UCRC->PutTOFbintype()==21 ||_UCRC->PutTOFbintype()==2 )
        {
        LambdaCenter = _UCRC->PutLambdaCenter();
        DeltaLambda  = _UCRC->PutDeltaLambda();
        }

    std::cout << "  LambdaCenter:"<<LambdaCenter<<std::endl;
    std::cout << "  DeltaLambda:"<<DeltaLambda<<std::endl;

    LambdaMin    = LambdaCenter-0.5*DeltaLambda;
    std::cout << "  LambdaMin:"<<LambdaMin<<std::endl;

    LambdaMax    = LambdaCenter+0.5*DeltaLambda;
    std::cout << "  LambdaMax:"<<LambdaMax<<std::endl;

    TOFoffset    = _UCRC->PutTOFoffset();

    std::cout << "  TOFoffset:"<<TOFoffset<<std::endl;

    TOFresolver1  = _UCRC->PutTOFResolver1();

    std::cout << "  TOFresolver1:"<<TOFresolver1<<std::endl;

    TOFresolver2  = _UCRC->PutTOFResolver2();

    std::cout << "  TOFresolver2:"<<TOFresolver2<<std::endl;

    TOFminSource = _UCRC->PutTOFSourceMin();

    std::cout << "  TOFminSource:"<<TOFminSource<<std::endl;

    TOFmaxSource = _UCRC->PutTOFSourceMax();

    std::cout << "  TOFmaxSource:"<<TOFmaxSource<<std::endl;

    std::cout << "ReadChopCondFile end" << std::endl;

    isChopCondInfoReady=true;
}

//////////////////////////////////////////////////////////
void UtsusemiFilterHSChopperDNA::MakeDummyCaseTable()
    {
    std::cout << "## Make Dummy Case Table " << std::endl;
    isFilterReady   = true;
    filterCaseTable = new std::vector< std::vector<UInt4>* >;

    _TOFslit  = CalcTOFSlit();  // [count]
    _TOFrange = CalcTOFRange(); // [count]
    }
//////////////////////////////////////////////////////////
UInt4 UtsusemiFilterHSChopperDNA::
GetCaseFromTof( const UInt4 pixelId, Double* tof, std::vector<UInt4>* caseVec )
    {
    //std::cout << *tof <<std::endl;

    Double tofSample;
    if (_tofL2L3.size()>pixelId){
        tofSample=(*tof)-_tofL2L3[pixelId] - TOFoffset; // tofSample = tofDetector - tofL2L3 [PSD]
        }
    else{
        tofSample=(*tof) - TOFoffset;                   // Monitor
        }
    if (_TOFslit.size()>0 && _TOFrange.size() >= _TOFslit.size()*2)
        {
        for (UInt4 i=0;i<_TOFslit.size();i++)
            {
            if ((_TOFrange[2*i]/40.0 < tofSample) && (tofSample < _TOFrange[2*i+1]/40.0))
                {
                UInt4 ret=1;
                (*tof) -= (_TOFslit[i]/40.0); //us
                (*tof) -= TOFoffset; //us
                return ret;
                }
            }
        }

    UInt4 ret=0;
    (*tof) += 0.0;       //us
    (*tof) -= TOFoffset; //us

    return ret;
    }
//////////////////////////////////////////////////////////
void UtsusemiFilterHSChopperDNA::
SetTOFL2L3(std::vector <Double> pixelTOFL2L3)
{
_tofL2L3=pixelTOFL2L3;
}
