#include "UtsusemiEventDataConverterDNAWithHSC.hh"
//////////////////////////////////////////////////////////
UtsusemiEventDataConverterDNAWithHSC::
UtsusemiEventDataConverterDNAWithHSC(){
    Initialize();
}

//////////////////////////////////////////////////////////
UtsusemiEventDataConverterDNAWithHSC::
~UtsusemiEventDataConverterDNAWithHSC(){
    delete stools;
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
Initialize(){
    _MessageTag = "UtsusemiEventDataConverterDNAWithHSC >> ";
    stools = new StringTools();
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
LoadParamFiles( std::string w_file, std::string d_file, std::string c_file ){
    SetEventParams( w_file, d_file );
    if (c_file!="") SetCaseInfoParams( c_file );

}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
LoadChopCondFile(std::string w_file, std::string d_file,std::string cc_file){
    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();
    FF->SetChopCondFile( w_file, d_file, cc_file );
    _EventDecoder->SetChopperParametersFromFiles(cc_file);
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetFilterHSChopperMode(){
    // T0TreatToolsNeunet *TT = _CaseDecoder->PutT0TreatTools();
    // std::vector<UInt8> t0_pulse_edb = TT->putVectorPulseId();
    // std::vector<UInt4> t0_index_edb = TT->putVectorT0Index();
    // std::vector<Double> t0_clock_edb = TT->putT0ClockDiffAll();

    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();
    FF->MakeDummyCaseTable();

    std::vector<Double> t1 = FF->CalcTOFSlit();
    std::vector<Double> t2 = FF->CalcTOFRange();
    std::vector<Double> t3 = FF->CalcEiRange();
    std::vector<Double> t4 = FF->CalcEiShift();

    std::cout << "TOFSlitSize::" << t1.size() << std::endl;
    for (UInt4 i=0;i<t1.size();i++)
        {
        std::cout << "TOFSlit[" << i << "]:" << std::fixed << t1[i]/40.0 << std::endl;
        }

    //std::cout << "EiShiftSize::" << t4.size() << std::endl;
    //for (UInt4 i=0;i<t4.size();i++)
    //    {
    //    std::cout << "EiShift[" << i << "]:" << std::fixed << t4[i] << std::endl;
    //    }

    std::cout << "TOFRangeSize::" << t2.size() << std::endl;
    for (UInt4 i=0;i<t2.size();i++)
        {
        if (i%2==0)
            std::cout << "TOFRange[" << i/2 << "]:min:" << std::fixed << t2[i]/40.0 << std::endl;
        else
            std::cout << "TOFRange[" << (i-1)/2 << "]:max:" << std::fixed << t2[i]/40.0 << std::endl;
        }

    //std::cout << "EiRangeSize::" << t3.size() << std::endl;
    //for (UInt4 i=0;i<t2.size();i++)
    //    {
    //    if (i%2==0)
    //        std::cout << "EiRange[" << i/2 << "]:min:" << std::fixed << t3[i] << std::endl;
    //    else
    //        std::cout << "EiRange[" << (i-1)/2 << "]:max:" << std::fixed << t3[i] << std::endl;
    //    }
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetLambdaParam(Double lambdaCenter,Double deltaLambda){
    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();
    FF->SetLambdaParam(lambdaCenter, deltaLambda);
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetTOFOffset(Double tofOffset){
    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();
    FF->SetTOFOffset(tofOffset);
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetTOFResolver(Double tofResolver){
    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();
    FF->SetTOFResolver(tofResolver);
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetTOFResolver(Double tofResolver1,Double tofResolver2){
    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();
    FF->SetTOFResolver(tofResolver1,tofResolver2);
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetTimeParamAtSource(Double tofMinSource, Double tofMaxSource){
    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();
    FF->SetTimeParamAtSource(tofMinSource, tofMaxSource);
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetT0Detector(){
    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();

    FF->SetTOFL2L3(_EventDecoder->_pixelT0Detector);
}
//////////////////////////////////////////////////////////
//void UtsusemiEventDataConverterDNAWithHSC::
//SetInstrumentPosition(Double lchopper, Double lband, Double l1){
//    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();
//    FF->SetInstrumentPosition(lchopper, lband, l1);
//}
//
//////////////////////////////////////////////////////////

void UtsusemiEventDataConverterDNAWithHSC::SetTOFOffsetFile(std::string o_file)
    {
    std::vector<std::vector<Double> > xyValues;
    xyValues=ReadTOFOffsetFile(o_file);

    _EventDecoder->_pixelTOFOffsetFileVect.clear();
    for (UInt4 i=0;i<xyValues.size();i++)
        {
        for (UInt4 j=0;j<xyValues.at(i).size();j++)
            {
            _EventDecoder->_pixelTOFOffsetFileVect.push_back(xyValues.at(i).at(j));
            }
        }
    }
//////////////////////////////////////////////////////////
Int8 UtsusemiEventDataConverterDNAWithHSC::_find(std::string line,std::vector<std::string> tag,Int4 pos)
    {
    UInt8 retpos=line.size();
    UInt8 tmppos=std::string::npos;
    for (UInt4 i=0;i<tag.size();i++)
        {
        tmppos=line.find(tag[i],pos);
        if (tmppos !=std::string::npos && tmppos<retpos)
            retpos=tmppos;
        }
    return retpos;
    }
//////////////////////////////////////////////////////////
std::vector<std::vector<Double> > UtsusemiEventDataConverterDNAWithHSC::ReadTOFOffsetFile(std::string fileName)
    {
    std::ifstream offsetFile;
    std::stringstream ss;
    Double val;
    offsetFile.open(fileName.c_str());
    std::vector<std::string> vecTag;
    vecTag.push_back(" ");
    vecTag.push_back(",");
    UInt8 pos1,pos2;
    std::vector<std::vector<Double> > xyValues;

    if(!offsetFile)
        {
        std::cout <<" can't open "<< fileName<<std::endl;
        }
    else
        {
        std::string line;
        while(offsetFile && getline(offsetFile, line)) { //while A start
            std::vector<Double> xValues;
            if (line.find("#")==0 || line.size()==0)
                { }
            else
                {
                pos1=0;
                while (1)
                    {
                    //pos2 = line.find(tag,pos1);
                    pos2 = _find(line,vecTag,pos1);
                    if (pos2 == std::string::npos) pos2=line.size();
                    if (pos2-pos1!=0)
                        {
                        ss << line.substr(pos1,pos2-pos1);
                        val = 0.0;
                        ss >> val;
                        ss.clear();
                        ss.str("");
                        xValues.push_back(val);
                        }
                    if (pos2==line.size()) break;
                    else pos1=pos2+1;
                    }
                if (xValues.size()!=0)
                    xyValues.push_back(xValues);
                }
            }
        }
    return xyValues;
    }
//////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetElementContainerDNA( UInt4 outer_pixel_id, ElementContainer* ec, UInt4 caseId ){
    if (caseId<=0) return;

    Int4 tof_bin_type = _EventDecoder->PutTofBinType( outer_pixel_id );
    if (tof_bin_type<0){
    std::cout <<_MessageTag<<"There is no information of tof_bin_type."<<std::endl;
    }else{
    SetElementContainer(outer_pixel_id, ec, caseId);
    ExecMaskForEC(outer_pixel_id,tof_bin_type,ec);
    }
}

//////////////////////////////////////////////////////////

void UtsusemiEventDataConverterDNAWithHSC::
ExecMaskForEC(UInt4 outer_pixel_id, Int4 tof_bin_type, ElementContainer *ec)
    {
    //*** EC MASK AS 20141202 ***//
    std::vector< std::vector<Double> > MaskVect;
    UtsusemiFilterHSChopperDNA *FF = _CaseDecoder->PutFilter();

    // PSD(HW)=27,PSD(HW,User)=28,PSD(TOF)=2,MON(E)=21,MON(TOF)=2,
    if (tof_bin_type==27 || tof_bin_type==28 || tof_bin_type==2 || tof_bin_type==21)
        {
        // PSD(HW)=27, PSD(HW,User)=28 ------------------------------------------------------------
        if (tof_bin_type==27 || tof_bin_type==28)
            {
            Double Ef = _EventDecoder->_pixelEfVect[outer_pixel_id];
            std::vector<Double> EiVect = FF->GetEiRange();

            if (EiVect.size()>0)
                {
                for (UInt4 i=0;i<EiVect.size()/2;i++)
                    {
                    std::vector<Double> tmp;
                    tmp.push_back( EiVect[2*i] - Ef );
                    tmp.push_back( EiVect[2*i+1] - Ef );
                    MaskVect.push_back(tmp);
                    }
                }
            reverse(MaskVect.begin(),MaskVect.end());
            }
        // PSD(TOF)=2 , MON(TOF)=2 ----------------------------------------------------------------
        if (tof_bin_type==2)
            {
            std::vector<Double> T0SampleVect = FF->GetTOFRange();
            std::vector<Double> T0SlitVect   = FF->GetTOFSlit();
            if (T0SampleVect.size()>0)
                {
                for (UInt4 i=0;i<T0SampleVect.size()/2;i++)
                    {
                    std::vector<Double> tmp;
                    tmp.push_back( (T0SampleVect[2*i]  -T0SlitVect[i])/40.0 );
                    tmp.push_back( (T0SampleVect[2*i+1]-T0SlitVect[i])/40.0 );
                    //std::cout << (T0SampleVect[2*i]  -T0SlitVect[i])/40.0 << "\t";
                    //std::cout << (T0SampleVect[2*i+1]-T0SlitVect[i])/40.0 <<std::endl;
                    MaskVect.push_back(tmp);
                    }
                }
            }
        // MON(E)=21 ------------------------------------------------------------------------------
        if (tof_bin_type==21)
            {
            std::vector<Double> EiVect = FF->GetEiRange();
            if (EiVect.size()>0)
                {
                for (UInt4 i=0;i<EiVect.size()/2;i++)
                    {
                    std::vector<Double> tmp;
                    tmp.push_back( EiVect[2*i]);
                    tmp.push_back( EiVect[2*i+1]);
                    //std::cout << EiVect[2*i+1] << "\t" << EiVect[2*i] << std::endl;
                    MaskVect.push_back(tmp);
                    }
                }
            reverse(MaskVect.begin(),MaskVect.end());
            }

        std::vector<Double> MaskedRanges;
        if (MaskVect.size()!=0)
            {
            for (UInt4 i=0;i<MaskVect.size();i++)
                {
                MaskedRanges.push_back(MaskVect.at(i).at(0));
                MaskedRanges.push_back(MaskVect.at(i).at(1));
                }
            }
        ec->PutHeaderPointer()->Add("MaskedRanges",MaskedRanges);

        // Mask ElementContainer ------------------------------------------------------------------
        /*
        if (MaskVect.size()>0)
            {
            std::vector<Double> ecX = ec->PutX();
            std::vector<Double> ecY = ec->PutY();
            std::vector<Double> ecE = ec->PutE();

            UInt4 j=0;
            for (UInt4 i=0;i<ecY.size();i++)
                {
                Double x = (ecX[i]+ecX[i+1])*0.5;
                if (j>=MaskVect.size())
                    {
                    ecY[i]= 1;
                    ecE[i]=-1;
                    }
                else
                    {
                    if(ecX[i] < MaskVect[j][0] || MaskVect[j][1] < ecX[i+1])
                        {
                        ecY[i]= 1;
                        ecE[i]=-1;
                        if (MaskVect[j][1] < ecX[i+1])
                            j+=1;
                        }
                    }
                }

            std::string xkey=ec->PutXKey();
            std::string ykey=ec->PutYKey();
            std::string ekey=ec->PutEKey();
            ec->Remove(ykey);
            ec->Remove(ekey);
            ec->Add(ykey,ecY);
            ec->Add(ekey,ecE);

            ec->SetKeys(xkey,ykey,ekey);
            }
        */
        //----------------------------------------------------------------------------------------
        }

    //*** EC MASK AS END 20141202 ***//

    }

//////////////////////////////////////////////////////////
Int4 UtsusemiEventDataConverterDNAWithHSC::
LoadEventDataFiles( UInt4 runNumber, std::string pathToData, std::string pathToT0data ){

    SetT0Detector(); //20140714 Append

    if (pathToData=="") pathToData="/data";
    SetDataPath( pathToData, pathToT0data, runNumber );

    if (_isReady){
    std::vector< std::vector< std::vector< std::vector<Int4>* >* >* >* _PixelInfoStore = _EventDecoder->_wirInfo->PixelInfoStore;
    if (_PixelInfoStore==NULL){
        std::cout << _MessageTag+"ReadEventData >>> There is no information about pixels from WiringInfo.xml" << std::endl;
        return -1;
    }

    for (UInt4 daq=0; daq<(_PixelInfoStore->size()); daq++){
        if (_PixelInfoStore->at(daq)!=NULL){
        for (UInt4 mod=0; mod<(_PixelInfoStore->at(daq)->size()); mod++){
            if (_PixelInfoStore->at(daq)->at(mod)!=NULL){
            std::cout << _MessageTag+"ReadEventData >> Load event data file for daq,mod=" << daq << "," << mod << std::endl;
            ReadEventData( daq, mod );
            if (!(_isReady)){
                std::cout << _MessageTag+"ReadEventData >>> fails to read Event data (daq="<< daq << ", mod=" << mod << std::endl;
            }
            }
        }
        }
    }
    //ReadEventData();
    if (!(_isReady)){
        std::cout << _MessageTag+"LoadEventDataFiles >>> fails to read event data files "<< std::endl;
        return -1;
    }
    }
    return 0;
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId ){
    UInt4 outerPixelId = 0;
    Int4 tofBinType = -1;
    while(true){
    if (_EventDecoder->_wirInfo->TofBinInfo[outerPixelId]!=NULL){
        std::vector<Double>* tofBinInfo = _EventDecoder->_wirInfo->TofBinInfoList[outerPixelId];

        UInt4 tof_pat_id = (UInt4)(tofBinInfo->at(0));
        if (_EventDecoder->_wirInfo->TofBinPtnInfo[ tof_pat_id ]!=NULL){
        tofBinType = _EventDecoder->_wirInfo->TofBinPtnInfo[ tof_pat_id ]->type;
        break;
        }
    }
    outerPixelId++;
    }

    if (tofBinType<0) return;

    _SetElementContainerMatrix(ecm, caseId );

    HeaderBase* hh = ecm->PutHeaderPointer();
    std::vector<std::string> process_h = hh->PutStringVector("DATAPROCESSED");
    //std::cout << "@@@@@@ TOF_BIN_TYPE=" << tofBinType << std::endl;
    if (tofBinType==20){
    process_h.push_back( "TOF TO ENERGY TRANSFER" );
    //std::vector< Double > EfixV( _EventDecoder->_tofBinConv->PutEfixVect() );
    //if (!(EfixV.empty())) {
    //    hh->Add( "Ei", EfixV[0] );
    //    for (UInt4 i=0;i<ecm->PutSize();i++) ecm->PutPointer(i)->PutHeaderPointer()->Add( "Ei", EfixV[0] );
    //}
    }else if (tofBinType==21){
    process_h.push_back( "TOF TO ENERGY" );
    }else if (tofBinType==22){
    process_h.push_back( "TOF TO Q" );
    }else{
    process_h.push_back( "EVENTS TO TOF" );
    }

    hh->OverWrite("DATAPROCESSED",process_h);

}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 runNumber, std::string pathToData, std::string pathToT0data, UInt4 caseId ){
    LoadEventDataFiles( runNumber, pathToData, pathToT0data );
    SetElementContainerMatrix( ecm, caseId );
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
_SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId ){

    std::vector< std::vector< std::vector< std::vector<Int4>* >* >* >* pixelInfoStore = _EventDecoder->_wirInfo->PixelInfoStore;

    HeaderBase* ecm_h = ecm->PutHeaderPointer();
    if (!AddRunInfoToHeader( ecm_h, caseId )){
        UtsusemiError("UtsusemiEventDataConverterDNAWithHSC::_SetElementContainerMatrix >> failed to add RunInfo to Header.");
        return;
    }

    UInt4 outerPixelId=0;
    Int4 tofBinType = -1;
    while(true){
    if (_EventDecoder->_wirInfo->TofBinInfo[outerPixelId]!=NULL){
        std::vector<Double>* tofBinInfo = _EventDecoder->_wirInfo->TofBinInfoList[outerPixelId];

        UInt4 tof_pat_id = (UInt4)(tofBinInfo->at(0));
        if (_EventDecoder->_wirInfo->TofBinPtnInfo[ tof_pat_id ]!=NULL){
        tofBinType = _EventDecoder->_wirInfo->TofBinPtnInfo[ tof_pat_id ]->type;
        break;
        }
    }
    outerPixelId++;
    }

    if (tofBinType<0) return;

    std::vector<std::string> process_h;
    process_h.push_back( "E2H" );

    ecm_h->Add( "DATAPROCESSED", process_h );


    std::vector<Int4> table_ECA;
    UInt4 index_ECA = 0;
    for (UInt4 daqId=0; daqId<(pixelInfoStore->size()); daqId++){
    if (pixelInfoStore->at(daqId)==NULL) continue;
    for (UInt4 modNo=0; modNo<(pixelInfoStore->at(daqId)->size()); modNo++){
        if (pixelInfoStore->at(daqId)->at(modNo)==NULL) continue;
        for (UInt4 psdNo=0; psdNo<(pixelInfoStore->at(daqId)->at(modNo)->size()); psdNo++){
        UInt4 detId = pixelInfoStore->at(daqId)->at(modNo)->at(psdNo)->at(1);
        if (detId<0) continue;
        if (table_ECA.size()<=detId) table_ECA.resize( detId+1,-1 );
        table_ECA[detId]=index_ECA;
        index_ECA++;
        }
    }
    }
    clock_t t1,t2;
    t1=clock();

    ecm->Allocate(index_ECA);

    std::vector<Int4> bankIdList = _EventDecoder->_detInfo->PutBankIdList();
    std::vector<std::string> bankNameList = _EventDecoder->_detInfo->PutBankName();
    bool isSetBankInfo = true;
    if (bankIdList.empty()) isSetBankInfo = false;

    UInt4 num_of_det = (_EventDecoder->_wirInfo->MaxDetId)+1;
    std::vector<Int4> hashTableOfBankId( num_of_det, -1 );
    std::vector<Int4> hashTableOfIndexInBank( num_of_det, -1 );
    std::vector<Int4> bankSizeList( bankIdList.size(), 0 );
    if (isSetBankInfo){
    ecm_h->Add( "BANKIDLIST", bankIdList );
    ecm_h->Add( "BANKNAMELIST", bankNameList );

    for (UInt4 i=0; i<bankIdList.size(); i++){
        std::vector<Int4> tmp = _EventDecoder->_detInfo->PutDetIdInBank( bankIdList[i] );
        if (tmp.empty()){
        }else{
        bankSizeList[i]=(Int4)(tmp.size());
        for (UInt4 j=0; j<tmp.size(); j++){
            if (tmp[j]<0){
            }else{
            if (tmp[j]<num_of_det) {
                hashTableOfBankId[(UInt4)(tmp[j])]=bankIdList[i];
                hashTableOfIndexInBank[(UInt4)(tmp[j])]=j;
            }
            }
        }
        }
    }
    ecm_h->Add( "BANKSIZELIST", bankSizeList );
    }


#ifdef MULTH
    omp_set_num_threads( MULTH );
#endif

    for (UInt4 daqId=0; daqId<(pixelInfoStore->size()); daqId++){
    if (pixelInfoStore->at(daqId)==NULL) continue;
    for (UInt4 modNo=0; modNo<(pixelInfoStore->at(daqId)->size()); modNo++){
        if (pixelInfoStore->at(daqId)->at(modNo)==NULL) continue;
        for (UInt4 psdNo=0; psdNo<(pixelInfoStore->at(daqId)->at(modNo)->size()); psdNo++){
        UInt4 detId = pixelInfoStore->at(daqId)->at(modNo)->at(psdNo)->at(1);
        if (detId<0) continue;
        Int4 head_pixelId = pixelInfoStore->at(daqId)->at(modNo)->at(psdNo)->at(2);
        Int4 num_pixels = pixelInfoStore->at(daqId)->at(modNo)->at(psdNo)->at(3);

        ElementContainerArray* ECA = new ElementContainerArray();
        HeaderBase* h_ECA = ECA->PutHeaderPointer();
        h_ECA->Add( std::string("MASKED"), 0 );
        h_ECA->Add( std::string("TYPE"), std::string("PSD") );
        h_ECA->Add( std::string("PSDID"), Int4(detId) );
        h_ECA->Add( std::string("DETID"), Int4(detId) );
        if (isSetBankInfo) {
            h_ECA->Add( std::string("BANKID"), hashTableOfBankId[detId] );
            h_ECA->Add( std::string("INDEXINBANK"), hashTableOfIndexInBank[detId] );
        }
        std::vector<Int4> maskedEC;
        maskedEC.push_back(-1);
        h_ECA->Add( std::string("MASKEDElementContainer"), maskedEC );

        ECA->Allocate( (UInt4)num_pixels );
        /* UtsusemiEventDataConverterNeunet uses below but no need for DNA reductions
        std::vector< std::vector<Double>* >* detPositionInfoVect = _EventDecoder->_detInfo->detPositionInfoVect;
        if (detPositionInfoVect!=NULL)
            if (detId<detPositionInfoVect->size())
                if (detPositionInfoVect->at(detId)!=NULL)
                    h_ECA->Add( std::string(UTSUSEMI_KEY_HEAD_DETPOSINFO), *(detPositionInfoVect->at(detId)) );
        */
#pragma omp parallel for
        for (UInt4 pixel=0; pixel<(UInt4)num_pixels; pixel++){
            UInt4 pixelId = head_pixelId + pixel;
            ElementContainer* EC = new ElementContainer();
            HeaderBase* h_EC = EC->PutHeaderPointer();
            h_EC->Add(std::string("PSDID"), Int4(detId) );
            h_EC->Add(std::string("DETID"), Int4(detId) );
            h_EC->Add(std::string("MASKED"), 0 );
            h_EC->Add(std::string("PIXELID"), Int4(pixelId) );

            std::string label = "Run"+stools->Int4ToString(_runNumber)+"("+stools->Int4ToString(detId)+","+stools->Int4ToString(pixel)+")";
            h_EC->Add(std::string("Label"), label );

            std::vector<Double> ppv(3,0.0);
            ppv[0] = _EventDecoder->_pixelPositionVect[ pixelId ]->at(0);
            ppv[1] = _EventDecoder->_pixelPositionVect[ pixelId ]->at(1);
            ppv[2] = _EventDecoder->_pixelPositionVect[ pixelId ]->at(2);
            h_EC->Add(std::string("PixelPosition"),ppv);
            //h_EC->Add(std::string("PixelSolidAngle"), _EventDecoder->_pixelSolidAngleVect[ pixelId ] );
            //comment out 20140917 For DNA ,"PixelSolidAngle"
           // Add For DNA -- start
           if (tofBinType==27 || tofBinType==28)
              {
              h_EC->Add(std::string("Ef"), _EventDecoder->_pixelEfVect[ pixelId ] );
              h_EC->Add(std::string("L1"), _EventDecoder->_pixelL1Vect[ pixelId ] );
              h_EC->Add(std::string("L2"), _EventDecoder->_pixelL2Vect[ pixelId ] );
              h_EC->Add(std::string("L3"), _EventDecoder->_pixelL3Vect[ pixelId ] );
              h_EC->Add(std::string("PolarAngle"), _EventDecoder->_pixelPolarAngleVect[ pixelId ] );
              h_EC->Add(std::string("AzimAngle"), _EventDecoder->_pixelAzimAngleVect[ pixelId ]);
              h_EC->Add(std::string("thetaDetector"), _EventDecoder->_pixelThetaDetectorVect[ pixelId ] );
              h_EC->Add(std::string("dthetaDetector"), _EventDecoder->_pixelDThetaDetectorVect[ pixelId ] );
              h_EC->Add(std::string("SolidAngle"), _EventDecoder->_pixelDOmega[ pixelId ] );
              }
            // For DNA --end
            SetElementContainerDNA( pixelId, EC, caseId );

            EC->AddToHeader(std::string("TotalCounts"), EC->Sum() );

            ECA->Set( pixel, EC );

        }
        ecm->Set( table_ECA[detId], ECA );
        }
    }

    }
    t2 = clock();
    std::cout << _MessageTag <<">> Cost of time="<< (t2-t1) << std::endl;
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
MakeCaseTable(UInt4 runno, std::string pathToData, std::string pathToT0data, std::string trigModKey)
{
    SetDataPath( pathToData, pathToT0data, runno );
    if (_isReady){
        std::vector< std::vector<Int4>* >* caseInfoStore = _EventDecoder->_wirInfo->TrigInfoStore;
        if (caseInfoStore!=NULL){
            for (UInt4 i=0; i<caseInfoStore->size(); i++){
                if (caseInfoStore->at(i)!=NULL){
                    Int4 type = caseInfoStore->at(i)->at(0);
                    Int4 daq = caseInfoStore->at(i)->at(1);
                    Int4 mod = caseInfoStore->at(i)->at(2);

                    char key_c[30];
                    std::snprintf( key_c, sizeof(key_c), "%02d_%03d", daq, mod ); //[TY 20141205]
                    //std::sprintf( key_c, "%3s%06d_%02d_%03d", _instCode.c_str(), _runNumber, daq, mod );
                    std::string key( key_c );
                    std::vector<std::string> dfiles = _dataFileList.Put( key );
                    std::vector<std::string> tfiles = _t0dataFileList.Put( key );
                    /*
                    std::cout << "@@@ LoadTrignetEventFile i=" << i << std::endl;
                    std::cout << "@@@ data files = ";
                    for (UInt4 j=0;j<dfiles.size();j++) std::cout << dfiles[j]+",";
                    std::cout << std::endl;
                    std::cout << "@@@ t0data files = ";
                    for (UInt4 j=0;j<tfiles.size();j++) std::cout << tfiles[j]+",";
                    std::cout << std::endl;
                    */
                    ReadCaseEvent( i, dfiles, tfiles );
                }
            }
        }else{
            UtsusemiWarning( _MessageTag+"LoadTrigEventFiles >>> caseInfoStore is NULL " );
            std::vector<std::string> dfiles, tfiles;
            if ((trigModKey!="")&&(_dataFileList.Check( trigModKey )==1)){
                dfiles = _dataFileList.Put( trigModKey );
                tfiles = _t0dataFileList.Put( trigModKey );
            }else{
                dfiles = _dataFileList.Put(0);
                tfiles = _t0dataFileList.Put(0);
            }
            ReadCaseEvent( 0, dfiles, tfiles );
        }
        if (!(_isReady)){
            std::cout << _MessageTag+"LoadTrigEventFiles >>> fails to read event data files "<< std::endl;
            return;
        }
    }
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
LoadTrignetEventFile( UInt4 runno, std::string pathToData, std::string pathToT0data ){
    MakeCaseTable( runno, pathToData, pathToT0data );
}

//DNA TRIG TEST 2014/12
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
LoadTrignetChopFile( UInt4 runno, std::string pathToData, std::string pathToT0data ){
}
//DNA TRIG TEST 2014/12


//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
ReadTrignetEventFile( std::string pathToTrigData, UInt4 index ){
    //std::vector<std::string> files(index+1,"");
    //files[index] = pathToTrigData;
    //ReadCaseEventFiles( files );
    std::vector<std::string> tmp1(1,pathToTrigData);
    std::vector<std::string> tmp2;
    tmp2.clear();
    ReadCaseEventFiles( index, tmp1, tmp2 );
}
//////////////////////////////////////////////////////////
std::vector<UInt4> UtsusemiEventDataConverterDNAWithHSC::
DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size ){
    std::vector<UInt4> ret;
    ret.clear();

    if (_CaseDecoder->PutCaseTable()==NULL){
    std::cout << "@@@@ NULL" << std::endl;
    return ret;
    }
    if (isI1Size){
    ret.push_back( _CaseDecoder->PutCaseTable()->size() );
    }else if (isI2Size){
    if (i1<(_CaseDecoder->PutCaseTable()->size())){
        ret.push_back( (_CaseDecoder->PutCaseTable()->at(i1)->size())/2 );
    }
    }else if (i1<(_CaseDecoder->PutCaseTable()->size())){
    if (i2<((_CaseDecoder->PutCaseTable()->at(i1)->size())/2)){
        ret.push_back( _CaseDecoder->PutCaseTable()->at(i1)->at(i2*2) );
        ret.push_back( _CaseDecoder->PutCaseTable()->at(i1)->at(i2*2+1) );
    }
    }
    return ret;
}

//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetRangeOfSingleTimeSlicing( double startSec, double endSec ){
    _CaseDecoder->SetRangeOfSingleTimeSlicing( startSec, endSec );
}
//////////////////////////////////////////////////////////
Int4 UtsusemiEventDataConverterDNAWithHSC::
SetRangeOfSingleTimeSlicing( std::string startDate, std::string endDate ){
    return _CaseDecoder->SetRangeOfSingleTimeSlicing( startDate, endDate );
}
//////////////////////////////////////////////////////////
void UtsusemiEventDataConverterDNAWithHSC::
SetElementContainerMatrixForPseudOnLineMon( ElementContainerMatrix* ecm, UInt4 caseId, UInt4 runNo ){
    _runNumber=runNo;
    _SetElementContainerMatrix( ecm, caseId );
}
//////////////////////////////////////////////////////////
Int4 UtsusemiEventDataConverterDNAWithHSC::
SetDataPathTest( std::string dataPath, std::string t0Path, UInt4 runNo ){
    std::cout << "@@@ " << dataPath << "," << t0Path << "," << runNo << std::endl;
    SetDataPath( dataPath, t0Path, runNo );
    if (_isReady){
    return 0;
    }else{
    return -1;
    }
}
