#include "UtsusemiDNAILambdaCorrectionUseMonAtSample.hh"
//////////////////////////////////////////////////////////
UtsusemiDNAILambdaCorrectionUseMonAtSample::
UtsusemiDNAILambdaCorrectionUseMonAtSample(){
    _attenuateValue = 4.088585;
}
//////////////////////////////////////////////////////////
UtsusemiDNAILambdaCorrectionUseMonAtSample::
UtsusemiDNAILambdaCorrectionUseMonAtSample(ElementContainerMatrix *ecm){
    SetTarget(ecm);
    _attenuateValue = 4.088585;
}
//////////////////////////////////////////////////////////
UtsusemiDNAILambdaCorrectionUseMonAtSample::
~UtsusemiDNAILambdaCorrectionUseMonAtSample(){
}
//////////////////////////////////////////////////////////
bool UtsusemiDNAILambdaCorrectionUseMonAtSample::
PutILambda(ElementContainer& ec0, ElementContainer& ret, std::string filepath, bool isHighReso, double attenuateVal){
    AdvDetectorManagerDNA *DeMan = new AdvDetectorManagerDNA(filepath);
    std::vector<Double> ENE = ec0.PutX();
    std::vector<Double> II = ec0.PutY();
    std::vector<Double> EE = ec0.PutE();
    std::vector<Double> ene(II.size(), 0.0);
    if (ENE.size() == ene.size()) copy( ENE.begin(), ENE.end(), ene.begin() );
    else if (ENE.size() == (ene.size()+1)){
        for (UInt4 i=0; i<ene.size(); i++) ene[i] = (ENE[i]+ENE[i+1])/2.0;
    }else{
        UtsusemiError("PutILambda Sizes are invalid.");
        std::cout << "ENE.size() = " << ENE.size() << ",  ene.size() = " << ene.size() << std::endl;
        return false;
    }
    std::vector<Double> ii(II.size(), 0.0);
    std::vector<Double> ee(II.size(), 0.0);

    UtsusemiUnitConverter UC;
    for (UInt4 i=0; i<ee.size(); i++){
        Double DetectEff = 1.0;
        DetectEff=DeMan->GetEfficiency(ene[i], 0.0);
        if (isHighReso)
            DetectEff /= exp(-UC.EtoLambda(ene[i])/attenuateVal);

        ii.at(i) = II.at(i)/DetectEff;
        ee.at(i) = EE.at(i)/DetectEff;
        // if (i == 0) std::cout << "DetectEffi = " << DetectEff << std::endl;
    }
    ret.Add("Energy",ENE,"meV");
    ret.Add("Intensity",ii,"counts");
    ret.Add("Error",ee,"counts");
    ret.SetKeys("Energy","Intensity","Error");

    delete DeMan;
    return true;
}
//////////////////////////////////////////////////////////
bool  UtsusemiDNAILambdaCorrectionUseMonAtSample::
ILCorrection(ElementContainerMatrix *ret, ElementContainerMatrix *ecm, ElementContainer& ec0, std::string filepath, bool isHighReso, double attenuateVal ){
    if (ecm==NULL){
        if (Put()==NULL){
            UtsusemiError("Target ElementContainerMatrix is not given.");
            return false;
        }else{
            ecm = Put();
        }
    }

    if ((isHighReso)&&(attenuateVal==0))
        attenuateVal = _attenuateValue;

    ElementContainer ec1;
    if (PutILambda(ec0, ec1, filepath, isHighReso, attenuateVal)){
    }else{
        UtsusemiError("PutILambda Error");
        return false;
    }

    AdvILambdaCorrectionDNA* ILC = new AdvILambdaCorrectionDNA();
    ILC->ILCorrection(ret, ecm, ec1, false, "", false);
    delete ILC;
    return true;
}
