#include "UtsusemiChopCondInfoReaderTrignet.hh"

//////////////////////////////////////////////////////////
UtsusemiChopCondInfoReaderTrignet::
UtsusemiChopCondInfoReaderTrignet():
UtsusemiCaseInfoReaderTrignet(){
    stools = new StringTools();
    _CF_KEY = "CaseInfo";

    _parserDetInfo = new BoostXmlParser();
    _parserDetInfo->Clear();

    _parserWirInfo = new BoostXmlParser();
    _parserWirInfo->Clear();
}
//////////////////////////////////////////////////////////
UtsusemiChopCondInfoReaderTrignet::
UtsusemiChopCondInfoReaderTrignet(std::string filename):
UtsusemiCaseInfoReaderTrignet(filename){
    stools = new StringTools();
    _CF_KEY = "CaseInfo";

    _parserDetInfo = new BoostXmlParser();
    _parserDetInfo->Clear();

    _parserWirInfo = new BoostXmlParser();
    _parserWirInfo->Clear();
}
//////////////////////////////////////////////////////////
UtsusemiChopCondInfoReaderTrignet::
~UtsusemiChopCondInfoReaderTrignet(){
    delete stools;
    delete _parserDetInfo;
    delete _parserWirInfo;
}

//////////////////////////////////////////////////////////

Double UtsusemiChopCondInfoReaderTrignet::PutFastChopperFrequency()
    {
    UInt4 val;
    std::string xmlpath_root = "caseInfo";
    std::string xmlpath = xmlpath_root+"/fastChopper";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath ,"frequency");
        if (s_val!="")
            {
            val = stools->StringToDouble(s_val);
            return val;
            }
        }
    return 0;
    }

//////////////////////////////////////////////////////////

UInt4 UtsusemiChopCondInfoReaderTrignet::PutNumOfFastChopperSlit()
    {
    UInt4 val;
    std::string xmlpath_root = "caseInfo";

    std::string xmlpath = xmlpath_root+"/fastChopper";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath ,"n");
        if (s_val!="")
            {
            val = stools->StringToUInt4(s_val);
            return val;
            }
        }
    return 0;
    }

//////////////////////////////////////////////////////////

std::vector<Double> UtsusemiChopCondInfoReaderTrignet::PutFastChopperSlitWidth()
    {
    std::vector<Double> vals;
    std::string xmlpath_root = "caseInfo";
    std::string xmlpath = xmlpath_root+"/fastChopper";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath ,"n");
        if (s_val!="")
            {
            UInt4 num_of_slits = stools->StringToUInt4(s_val);
            for (UInt4 i=0;i<num_of_slits;i++){
                std::string xmlpath_slit = xmlpath+"/slit,i="+(stools->Int4ToString(i));
                if (mxReader->hasPath(_CF_KEY,xmlpath_slit)){
                    std::string s_wval = mxReader->putTextContent( _CF_KEY, xmlpath_slit, "width" );
                    if (s_wval!="")
                        {
                        Double slitwidth = stools->StringToDouble( s_wval );
                        vals.push_back(slitwidth);
                        }
                    else
                        {
                        vals.push_back(1.0f);
                        }
                    }
                }
            }
        }
    return vals;
    }

//////////////////////////////////////////////////////////

std::vector<Double> UtsusemiChopCondInfoReaderTrignet::PutFastChopperSlitAngle()
    {
    std::vector<Double> vals;
    std::string xmlpath_root = "caseInfo";
    std::string xmlpath = xmlpath_root+"/fastChopper";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath ,"n");
        if (s_val!="")
            {
            UInt4 num_of_slits = stools->StringToUInt4(s_val);
            for (UInt4 i=0;i<num_of_slits;i++){
                std::string xmlpath_slit = xmlpath+"/slit,i="+(stools->Int4ToString(i));
                if (mxReader->hasPath(_CF_KEY,xmlpath_slit)){
                    std::string s_wval = mxReader->putTextContent( _CF_KEY, xmlpath_slit, "angle" );
                    if (s_wval!="")
                        {
                        Double slitangle = stools->StringToDouble( s_wval );
                        vals.push_back(slitangle);
                        }
                    else
                        {
                        vals.push_back(i*360.0/num_of_slits);
                        }
                    }
                }
            }
        }
    return vals;
    }

//////////////////////////////////////////////////////////

UInt4 UtsusemiChopCondInfoReaderTrignet::PutFastChopperMode()
    {
    UInt4 val;
    std::string xmlpath_root = "caseInfo";

    std::string xmlpath = xmlpath_root+"/fastChopper";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath ,"mode");
        if (s_val!="")
            {
            val = stools->StringToUInt4(s_val);
            return val;
            }
        }
    return 0;
    }

//////////////////////////////////////////////////////////

Int4 UtsusemiChopCondInfoReaderTrignet::ImportDetectorInfo(std::string filepath)
    {
    _parserDetInfo->Load(filepath);
/*
    Int4 val;
    std::string xmlpath;
    xmlpath="detectorInfo/instrumentInfo/L1";

    if (_parserDetInfo->hasPath(xmlpath))
        {
        std::string s_val = _parserDetInfo->PutContent(xmlpath);
        if (s_val!="")
            {
            val = stools->StringToUInt4(s_val);
            //std::cout << "&&&&&&&&&" << val << std::endl;
            return val;
            }
        }
*/
    return 0;
    }

//////////////////////////////////////////////////////////

Double UtsusemiChopCondInfoReaderTrignet::PutL1(){
    Double val;
    std::string xmlpath;
    xmlpath="detectorInfo/instrumentInfo/L1";
    if (_parserDetInfo->hasPath(xmlpath))
        {
        std::string s_val = _parserDetInfo->PutContent(xmlpath);
        if (s_val!="")
            {
            val = stools->StringToDouble(s_val);
            val = val/1000.0; //[inamura 141205]  [mm]->[m]
            return val;
            }
        }
    return 0;
}
//////////////////////////////////////////////////////////

Double UtsusemiChopCondInfoReaderTrignet::PutLChopper(){
    Double val;
    std::string xmlpath;
    xmlpath="detectorInfo/instrumentInfo/LChopper";

    if (_parserDetInfo->hasPath(xmlpath))
        {
        std::string s_val = _parserDetInfo->PutContent(xmlpath);
        if (s_val!="")
            {
            val = stools->StringToDouble(s_val);
            val = val/1000.0; //[inamura 141205]  [mm]->[m]
            return val;
            }
        }
    return 0;
}
//////////////////////////////////////////////////////////

Double UtsusemiChopCondInfoReaderTrignet::PutLBandChopper(){
    Double val;
    std::string xmlpath;
    xmlpath="detectorInfo/instrumentInfo/LBandChopper";
    if (_parserDetInfo->hasPath(xmlpath))
        {
        std::string s_val = _parserDetInfo->PutContent(xmlpath);
        if (s_val!="")
            {
            val = stools->StringToDouble(s_val);
            val = val/1000.0; //[inamura 141205]  [mm]->[m]
            return val;
            }
        }
    return 0;
}
//////////////////////////////////////////////////////////

Int4 UtsusemiChopCondInfoReaderTrignet::ImportWiringInfo(std::string filepath)
    {
    _parserWirInfo->Load(filepath);

    std::vector<std::string> s_params;
    if (_parserWirInfo->hasPath("wiringInfo/tofBinInfo/tofBin/") )
        {
        std::string s_val = _parserWirInfo->PutContent("wiringInfo/tofBinInfo/tofBin","patternId");
        if (s_val!="")
            {
            if (_parserWirInfo->hasPath("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val))
                {
                std::string ss_val=_parserWirInfo->PutContent("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val);
                s_params = stools->SplitString( ss_val, "," );
                }
            }
        }
    std::vector<Double> params;
    for (UInt4 i=0;i<s_params.size();i++)
        {
        params.push_back( stools->StringToDouble(s_params.at(i) ) );
        }


    if (params.size()==8)
        {
        std::cout << "  hw_start\t\t= "       << params[0] << std::endl;
        std::cout << "  hw_end\t\t= "         << params[1] << std::endl;
        std::cout << "  hw_delta\t\t= "       << params[2] << std::endl;

        std::cout << "  Lambda_center\t\t= "  << params[3]*1e-10 << std::endl;
        std::cout << "  delta_Lambda\t\t= "   << params[4]*1e-10 << std::endl;
        std::cout << "  t0_offset_from_wf\t= "<< params[5] << std::endl;
        std::cout << "  LaticeSpace\t\t= "    << params[6]*1e-10 << std::endl;
        std::cout << "  L1\t\t\t= "           << params[7] << std::endl;
        std::cout << std::endl;
        }

    else if (params.size()>8)
        {
        std::cout << "  Lambda_center\t\t= "  << params[0]*1e-10 << std::endl;
        std::cout << "  delta_Lambda\t\t= "   << params[1]*1e-10 << std::endl;
        std::cout << "  t0_offset_from_wf\t= "<< params[2] << std::endl;
        std::cout << "  LaticeSpace\t\t= "    << params[3]*1e-10 << std::endl;
        std::cout << "  L1\t\t\t= "           << params[4] << std::endl;
        std::cout << std::endl;
        }

    // Double hw_start          = params[0];
    // Double hw_end            = params[1];
    // Double hw_delta          = params[2];

    // Double Lambda_center     = params[3]*1e-10;
    // Double delta_Lambda      = params[4]*1e-10;
    // Double t0_offset_from_wf = params[5];
    // Double LaticeSpace       = params[6]*1e-10;
    // Double L1                = params[7];

    return 0;
    }

//////////////////////////////////////////////////////////
Double UtsusemiChopCondInfoReaderTrignet::PutLambdaCenter(){
    std::vector<std::string> s_params;
    UInt4 conv_type=0;    //[inamura 170612]
    if (_parserWirInfo->hasPath("wiringInfo/tofBinInfo/tofBin/") ){
        std::string s_val = _parserWirInfo->PutContent("wiringInfo/tofBinInfo/tofBin","patternId");
        if (s_val!=""){
            if (_parserWirInfo->hasPath("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val)){
                std::string ss_val=_parserWirInfo->PutContent("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val);
                s_params = stools->SplitString( ss_val, "," );
                conv_type = stools->StringToUInt4( _parserWirInfo->PutContent("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val,"type") );//[inamura 170612]
                }
            }
        }

    std::vector<Double> params;
    for (UInt4 i=0;i<s_params.size();i++)
        params.push_back( stools->StringToDouble(s_params.at(i) ) );

    //[inamura 170612]-->
    if ((conv_type==2)||(conv_type==21)){
        std::string xmlpath = "caseInfo/lambdaCenter";
        if (mxReader->hasPath(_CF_KEY,xmlpath)){
            std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath);
            if (s_val!="")
                return stools->StringToDouble(s_val);
        }
    }
    //<--[inamura 170612]
    UInt4 index;
    if (params.size()==8)
        {
        index=3;
        }
    else if (params.size()==5)
        {
        index=3;
        }
    else
        {
        index=0;
        }

    if (s_params.size()>index)
        return params[index];
    else
        return 1.0;
    }

//////////////////////////////////////////////////////////
Double UtsusemiChopCondInfoReaderTrignet::PutDeltaLambda(){
    std::vector<std::string> s_params;
    UInt4 conv_type=0;    //[inamura 170612]
    if (_parserWirInfo->hasPath("wiringInfo/tofBinInfo/tofBin/") ){
        std::string s_val = _parserWirInfo->PutContent("wiringInfo/tofBinInfo/tofBin","patternId");
        if (s_val!=""){
            if (_parserWirInfo->hasPath("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val)){
                std::string ss_val=_parserWirInfo->PutContent("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val);
                s_params = stools->SplitString( ss_val, "," );
                conv_type = stools->StringToUInt4( _parserWirInfo->PutContent("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val,"type") );//[inamura 170612]
                }
            }
        }

    //[inamura 170612]-->
    if ((conv_type==2)||(conv_type==21)){
        std::string xmlpath = "caseInfo/lambdaDelta";
        if (mxReader->hasPath(_CF_KEY,xmlpath)){
            std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath);
            if (s_val!="")
                return stools->StringToDouble(s_val);
        }
    }
    //<--[inamura 170612]
    std::vector<Double> params;
    for (UInt4 i=0;i<s_params.size();i++)
        params.push_back( stools->StringToDouble(s_params.at(i) ) );

    UInt4 index;

    if (params.size()==8)
        {
        index=4;
        }
    else if (params.size()==5)
        {
        index=4;
        }
    else
        {
        index=1;
        }

    if (s_params.size()>index)
        return params[index];
    else
        return 1.0;
    }
//////////////////////////////////////////////////////////
Double UtsusemiChopCondInfoReaderTrignet::PutTOFoffset(){
/*
    if(PutTOFbintype()==27 || PutTOFbintype()==28 )
        {
        std::vector<std::string> s_params;
        if (_parserWirInfo->hasPath("wiringInfo/tofBinInfo/tofBin/") ){
            std::string s_val = _parserWirInfo->PutContent("wiringInfo/tofBinInfo/tofBin","patternId");
            if (s_val!=""){
                if (_parserWirInfo->hasPath("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val)){
                    std::string ss_val=_parserWirInfo->PutContent("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val);
                    s_params = stools->SplitString( ss_val, "," );
                    }
                }
            }

        std::vector<Double> params;
        for (UInt4 i=0;i<s_params.size();i++)
            params.push_back( stools->StringToDouble(s_params.at(i) ) );

        UInt4 index;
        if (params.size()==8)
            {
            index=5;
            }
        else if (params.size()==5)
            {
            index=3;
            }
        else
            {
            index=2;
            }

        if (s_params.size()>index)
            return params[index];
        else
            return 0.0;
        }
    else
        {
*/
        Double val;
        std::string xmlpath_root = "caseInfo";

        std::string xmlpath = xmlpath_root+"/tofOffset";
        if (mxReader->hasPath(_CF_KEY,xmlpath)){
            std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath);
            if (s_val!="")
                {
                val = stools->StringToDouble(s_val);
                return val;
                }
            }
        return 0.0;
//        }
    }
//////////////////////////////////////////////////////////
/*
Double UtsusemiChopCondInfoReaderTrignet::PutTOFResolver()
    {
    Double val;
    std::string xmlpath_root = "caseInfo";

    std::string xmlpath = xmlpath_root+"/tofResolver";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath);
        if (s_val!="")
            {
            val = stools->StringToDouble(s_val);
            return val;
            }
        }
    return 0.0;
    }
*/
//////////////////////////////////////////////////////////
Double UtsusemiChopCondInfoReaderTrignet::PutTOFResolver1()
    {
    Double val;
    std::vector<std::string> s_params;

    std::string xmlpath_root = "caseInfo";
    std::string xmlpath = xmlpath_root+"/tofResolver";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath);
        if (s_val!="")
            {

            UInt8 loc = s_val.find( ",", 0 );
            if( loc != std::string::npos )
                {
                s_params = stools->SplitString( s_val, "," );
                val= stools->StringToDouble(s_params.at(0) );
                return val;
                }
            else
                {
                val = stools->StringToDouble(s_val);
                return val;
                }
            }
        }
    return 0.0;
    }
//////////////////////////////////////////////////////////
Double UtsusemiChopCondInfoReaderTrignet::PutTOFResolver2()
    {
    Double val;
    std::vector<std::string> s_params;

    std::string xmlpath_root = "caseInfo";
    std::string xmlpath = xmlpath_root+"/tofResolver";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath);
        if (s_val!="")
            {

            UInt8 loc = s_val.find( ",", 0 );
            if( loc != std::string::npos )
                {
                s_params = stools->SplitString( s_val, "," );
                val= stools->StringToDouble(s_params.at(1) );
                return val;
                }
            else
                {
                val = stools->StringToDouble(s_val);
                return val;
                }
            }
        }
    return 0.0;
    }

//////////////////////////////////////////////////////////
Double UtsusemiChopCondInfoReaderTrignet::PutTOFSourceMin()
    {
    Double val;
    std::vector<std::string> s_params;
    std::string xmlpath_root = "caseInfo";

    std::string xmlpath = xmlpath_root+"/tofSource";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath);
        if (s_val!="")
            {
            s_params = stools->SplitString( s_val, "," );
            val= stools->StringToDouble(s_params.at(0) );
            return val;
            }
        }
    return 0.0;
    }
//////////////////////////////////////////////////////////
Double UtsusemiChopCondInfoReaderTrignet::PutTOFSourceMax()
    {
    Double val;
    std::vector<std::string> s_params;
    std::string xmlpath_root = "caseInfo";

    std::string xmlpath = xmlpath_root+"/tofSource";
    if (mxReader->hasPath(_CF_KEY,xmlpath)){
        std::string s_val = mxReader->putTextContent( _CF_KEY, xmlpath);
        if (s_val!="")
            {
            s_params = stools->SplitString( s_val, "," );
            val= stools->StringToDouble(s_params.at(1) );
            return val;
            }
        }
    return 0.0;
    }
//////////////////////////////////////////////////////////
Int4 UtsusemiChopCondInfoReaderTrignet::PutTOFbintype()
    {
    if (_parserWirInfo->hasPath("wiringInfo/tofBinInfo/tofBin/") ){
        std::string s_val = _parserWirInfo->PutContent("wiringInfo/tofBinInfo/tofBin","patternId");
        if (s_val!=""){
            if (_parserWirInfo->hasPath("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val)){
                std::string ss_val=_parserWirInfo->PutContent("wiringInfo/tofBinPatternList/tofBinPattern,patternId="+s_val,"type");
                Int4 val = stools->StringToUInt4(ss_val);
                return val;
                }
            }
        }
    return -1;
    }
//////////////////////////////////////////////////////////
