
// File: classAdvCorrectionAbsorptionDNA.xml
%feature("docstring") AdvCorrectionAbsorptionDNA "

AdvCorrectionAbsorptionDNA Class calculates absorption factor and desired value of the scattering from the sample corrected for absorption, based on the following paper. H.H. Paalman and C.J. Pings :: J. Appl. Phys. 33, 2635 (1962).

@author skoike@advancesoft @vertion 1.0

C++ includes: AdvCorrectionAbsorptionDNA.hh ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::AdvCorrectionAbsorptionDNA "AdvCorrectionAbsorptionDNA::AdvCorrectionAbsorptionDNA(void)

constructor ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::AdvCorrectionAbsorptionDNA "AdvCorrectionAbsorptionDNA::AdvCorrectionAbsorptionDNA(string) ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::AdvCorrectionAbsorptionDNA "AdvCorrectionAbsorptionDNA::AdvCorrectionAbsorptionDNA(string, string) ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::~AdvCorrectionAbsorptionDNA "AdvCorrectionAbsorptionDNA::~AdvCorrectionAbsorptionDNA(void)

destructor ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::GetACC "Double AdvCorrectionAbsorptionDNA::GetACC(Double, Double, Double, Double)

return threshold value used for judgement of convergence in numerial integral

@return epsilon return threshold value of ratio used for judgement of convergence in numerial integral

@return epsilonRatio set threshold value used for judgement of convergence in numerial integral

@set epsilon set threshold value Ratio used for judgement of convergence in numerial integral

@set epsilonRatio calculate coefficient factor A_C_C A_C_C is coefficent factor of sell scattered at cell.

@return ACC ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::GetACSS "Double AdvCorrectionAbsorptionDNA::GetACSS(Double, Double, Double, Double)

calculate coefficient factor A_CS_S A_CS_S is coefficent factor of sell+sample scattered at sample.

@return ACSS ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::GetACSC "Double AdvCorrectionAbsorptionDNA::GetACSC(Double, Double, Double, Double)

calculate coefficient factor A_CS_C A_CS_C is coefficent factor of sell+sample scattered at sample.

@return ACSS ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::GetASS "Double AdvCorrectionAbsorptionDNA::GetASS(Double, Double, Double, Double)

calculate coefficient factor A_S_S A_S_S is coefficent factor of sample scattered at sample. only use in the case of column shape

@return ASS ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::GetModifiedIntensity "void AdvCorrectionAbsorptionDNA::GetModifiedIntensity(Double, char *, char *)

calculate intensity correctrion ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::GetThetaPhi "vector< Double > AdvCorrectionAbsorptionDNA::GetThetaPhi(PyObject *) ";

%feature("docstring")  AdvCorrectionAbsorptionDNA::GetCorrectIntensity "Double AdvCorrectionAbsorptionDNA::GetCorrectIntensity(Double, Double, Double, Double, Double) ";


// File: classAdvDetectorManagerDNA.xml
%feature("docstring") AdvDetectorManagerDNA "

detector's absorption correction

KOIKE Soh, AdvanceSoft Corp. (original, core)

TANIMORI Souichirou, AdvanceSoft Corp. (rewrite comment, interface)

0.0

C++ includes: AdvDetectorManagerDNA.hh ";

%feature("docstring")  AdvDetectorManagerDNA::AdvDetectorManagerDNA "AdvDetectorManagerDNA::AdvDetectorManagerDNA(void)

constructor ";

%feature("docstring")  AdvDetectorManagerDNA::AdvDetectorManagerDNA "AdvDetectorManagerDNA::AdvDetectorManagerDNA(string filepath) ";

%feature("docstring")  AdvDetectorManagerDNA::~AdvDetectorManagerDNA "AdvDetectorManagerDNA::~AdvDetectorManagerDNA(void)

destructor ";

%feature("docstring")  AdvDetectorManagerDNA::GetSigmas "void AdvDetectorManagerDNA::GetSigmas(Double energy, Double *sigmaDA, Double *sigmaWA, Double *sigmaWS)

get the values of effective cross sections from an energy value

---------------
Parameters:
---------------

energy:  neutron's energy in meV

sigmaDA:  detector's effective absorption cross section

sigmaWA:  wall's effective absorption cross section

sigmaWS:  wall's effective scattering cross section ";

%feature("docstring")  AdvDetectorManagerDNA::GetSigmaDA "Double AdvDetectorManagerDNA::GetSigmaDA(Double enenrgy)

evaluate detector's effective absorption cross section from energy.

---------------
Parameters:
---------------

energy:  neutron's enenrgy, unit meV ";

%feature("docstring")  AdvDetectorManagerDNA::GetSigmaWA "Double AdvDetectorManagerDNA::GetSigmaWA(Double enenrgy)

evaluate wall's effective absorption cross section from energy.

---------------
Parameters:
---------------

energy:  neutron's enenrgy, unit meV ";

%feature("docstring")  AdvDetectorManagerDNA::GetSigmaWS "Double AdvDetectorManagerDNA::GetSigmaWS(Double enenrgy)

evaluate wall's effective scatterring cross section from energy.

---------------
Parameters:
---------------

energy:  neutron's enenrgy, unit meV ";

%feature("docstring")  AdvDetectorManagerDNA::CalcEfficiencyDetector "Double AdvDetectorManagerDNA::CalcEfficiencyDetector(Double angle, Double sigmaDA, Double sigmaWA, Double sigmaWS)

evaluate detection efficiency.

---------------
Parameters:
---------------

angle:  incedent angle in degrees

sigmeDA:  detector's effective absorption cross section

sigmeWA:  wall's effective absorption cross section

sigmeWS:  wall's effective scattering cross section ";

%feature("docstring")  AdvDetectorManagerDNA::GetEfficiency "Double AdvDetectorManagerDNA::GetEfficiency(Double eneNutron, Double thetaDetector)

evaluate the efficiency from nutrin's enenrgy and theta

---------------
Parameters:
---------------

eneNeutron:  neutron's energy

thetaDetector:  theta ";

%feature("docstring")  AdvDetectorManagerDNA::CalcCoefEfficiencyDetector "Double AdvDetectorManagerDNA::CalcCoefEfficiencyDetector(UInt4 num, Double thetaDetector, Double sigmaDA, Double sigmaWS, Double sigmaWA, Double lamda0)

evaluate the efficiency of detector

---------------
Parameters:
---------------

num:  ?

thetaDetector:  angle

sigmaDA:  detector's effective absorption cross section

sigmaWS:  wall's effective scattering cross section

sigmaWA:  wall's effective absorption cross section

lamda0:  ? ";

%feature("docstring")  AdvDetectorManagerDNA::GetEfficiencyTable "Double AdvDetectorManagerDNA::GetEfficiencyTable(Double, Double)

evaluate the efficiency from nutrin's enenrgy and theta and print out coefficients

---------------
Parameters:
---------------

eneNeutron:  neutron's energy

thetaDetector:  theta ";

%feature("docstring")  AdvDetectorManagerDNA::GetCorrectEff2 "Double AdvDetectorManagerDNA::GetCorrectEff2(Double eneNeutron, Double thetaDetector, Double deltaEne, Double hosei0, Double hosei1, Double hosei2, Double hosei3, Double hosei4)

evaluate the 2nd order correction

---------------
Parameters:
---------------

eneNeutron:  neutron's energy

thetaDetector:  angle

deltaEne:  delta energy

hosei0:  0-th. order coefficient for correction

hosei1:  1st. order coefficient for correction

hosei2:  2nd. order coefficient for correction

hosei3:  dummy

hosei4:  dummy ";

%feature("docstring")  AdvDetectorManagerDNA::GetCorrectEff4 "Double AdvDetectorManagerDNA::GetCorrectEff4(Double eneNeutron, Double thetaDetector, Double deltaEne, Double hosei0, Double hosei1, Double hosei2, Double hosei3, Double hosei4)

evaluate up to the 4th. order correction

---------------
Parameters:
---------------

eneNeutron:  neutron's energy

thetaDetector:  angle

deltaEne:  delta energy

hosei0:  0th. order coefficient for correction

hosei1:  1st. order coefficient for correction

hosei2:  2nd. order coefficient for correction

hosei3:  3rd. order coefficient for correction

hosei4:  4th. order coefficient for correction ";

%feature("docstring")  AdvDetectorManagerDNA::GetCorrectThetaEff2 "Double AdvDetectorManagerDNA::GetCorrectThetaEff2(Double eneNutron, Double thetaDetector, Double deltaTheta, Double hosei0, Double hosei1, Double hoseie2, Double hosei3, Double energy)

evaluate up to the 4th. order correction

---------------
Parameters:
---------------

eneNeutron:  neutron's energy

thetaDetector:  angle

deltaTheta:  delta theta

hosei0:  0th. order coefficient for correction

hosei1:  1st. order coefficient for correction

hosei2:  2nd. order coefficient for correction

hosei3:  dummy

hosei4:  dummy ";

%feature("docstring")  AdvDetectorManagerDNA::GetCorrectThetaEff4 "Double AdvDetectorManagerDNA::GetCorrectThetaEff4(Double, Double, Double, Double, Double, Double, Double, Double)

evaluate up to the 4th. order correction

---------------
Parameters:
---------------

eneNeutron:  neutron's energy

thetaDetector:  angle

deltaTheta:  delta theta

hosei0:  0th. order coefficient for correction

hosei1:  1st. order coefficient for correction

hosei2:  2nd. order coefficient for correction

hosei3:  3rd. order coefficient for correction

hosei4:  4th. order coefficient for correction ";

%feature("docstring")  AdvDetectorManagerDNA::MakeTable "void AdvDetectorManagerDNA::MakeTable(Double inputMiniEnenrgy, Double inputMaxEnenrgy, UInt4 devnum, Double inputThetaDetector, ElementContainer &ec)

output integral values to table file.

---------------
Parameters:
---------------

inputMinEnergy:  the lower bound of energy range (in m eV)

inputMaxEnergy:  the upper bound of energy range (in m eV

divnum:  the number of division of the energy range [in] thetaDetector angle (in Degree) [out] ec a container for results ";

%feature("docstring")  AdvDetectorManagerDNA::MakeTableTheta "void AdvDetectorManagerDNA::MakeTableTheta(Double inputMinTheta, Double inputMaxTheta, UInt4 divnum, Double inputEnergy, ElementContainer &ec)

output integral values to table file.

---------------
Parameters:
---------------

inputMinTheta:  the lower bound of angle range (in degrees)

inputMaxTheta:  the upper bound of angle range (in degrees)

divnum:  the number of division of the angle range [in] inputEnergyr neutron's energy (in meV) [out] ec a container for results ";

%feature("docstring")  AdvDetectorManagerDNA::GetCorrectIntensity "vector< Double > AdvDetectorManagerDNA::GetCorrectIntensity(vector< Double > inputEnenrgyList, vector< Double > inputIntensityList, Double thetaDetector)

get corrected intensity.

---------------
Parameters:
---------------

inputEnenrgyList:

inputIntensityList:

thetaDetactor:

---------------
Return objects:
---------------

a list of corrected intensity value ";

%feature("docstring")  AdvDetectorManagerDNA::GetCorrectIntensityFromPython "PyObject * AdvDetectorManagerDNA::GetCorrectIntensityFromPython(PyObject *value1, PyObject *value2, Double thetaDetector)

get correctord intensity forPython.

---------------
Parameters:
---------------

value1:  a list of input energy, Python's llist

value2:  a list of input intensity, Python's list

thetaDetactor:

---------------
Return objects:
---------------

a list of corrected intensity value, Python's list ";

%feature("docstring")  AdvDetectorManagerDNA::SetIntegThresholdValue "void AdvDetectorManagerDNA::SetIntegThresholdValue(Double a)

set threshold value used for judgement of convergence in numerial integral

epsilon ";

%feature("docstring")  AdvDetectorManagerDNA::SetIntegThresholdRatio "void AdvDetectorManagerDNA::SetIntegThresholdRatio(Double a)

set threshold value Ratio used for judgement of convergence in numerial integral

epsilonRatio ";

%feature("docstring")  AdvDetectorManagerDNA::GetIntegThresholdValue "Double AdvDetectorManagerDNA::GetIntegThresholdValue(void)

return threshold value used for judgement of convergence in numerial integral

---------------
Return objects:
---------------

epsilon ";

%feature("docstring")  AdvDetectorManagerDNA::GetIntegThresholdRatio "Double AdvDetectorManagerDNA::GetIntegThresholdRatio(void)

return threshold value of ratio used for judgement of convergence in numerial integral

---------------
Return objects:
---------------

epsilonRatio ";


// File: classAdvEquipmentManagerDNA.xml
%feature("docstring") AdvEquipmentManagerDNA "

AdvEquipmentManagerDNA Class manages the data of DNA equipment.

skoike

C++ includes: AdvEquipmentManagerDNA.hh ";

%feature("docstring")  AdvEquipmentManagerDNA::AdvEquipmentManagerDNA "AdvEquipmentManagerDNA::AdvEquipmentManagerDNA(void)

constructor

A constructor.

Set filename of DNA data, and read data

Set default value for wBin, offset, phi560, phi127, d12, psdRadius, theta0, wTheta. ";

%feature("docstring")  AdvEquipmentManagerDNA::AdvEquipmentManagerDNA "AdvEquipmentManagerDNA::AdvEquipmentManagerDNA(string) ";

%feature("docstring")  AdvEquipmentManagerDNA::~AdvEquipmentManagerDNA "AdvEquipmentManagerDNA::~AdvEquipmentManagerDNA(void)

destructor

A destructor.

Delete dynamical variables, upperDetInfo[][] and lowerDetInfo[][]. ";

%feature("docstring")  AdvEquipmentManagerDNA::GetL1 "Double AdvEquipmentManagerDNA::GetL1(void)

return L1 value.

---------------
Return objects:
---------------

value of \"L1\" ";

%feature("docstring")  AdvEquipmentManagerDNA::GetUpperRadius "Double AdvEquipmentManagerDNA::GetUpperRadius(void)

return the value of radius of the upper analyzer mirror

---------------
Return objects:
---------------

value of radius of the upper analyzer mirror ";

%feature("docstring")  AdvEquipmentManagerDNA::GetLowerRadius "Double AdvEquipmentManagerDNA::GetLowerRadius(void)

return the value of radius of the lower analyzer mirror

---------------
Return objects:
---------------

value of radius of the lower analyzer mirror ";

%feature("docstring")  AdvEquipmentManagerDNA::GetUppLtcSpc "Double AdvEquipmentManagerDNA::GetUppLtcSpc(void)

return the value of distance between atomic surface of the upper analyzer mirror

---------------
Return objects:
---------------

value of distance between atomic surface of the upper analyzer mirror ";

%feature("docstring")  AdvEquipmentManagerDNA::GetLowLtcSpc "Double AdvEquipmentManagerDNA::GetLowLtcSpc(void)

return the value of distance between atomic surface of the lower analyzer mirror

---------------
Return objects:
---------------

value of distance between atomic surface of the lower analyzer mirror ";

%feature("docstring")  AdvEquipmentManagerDNA::GetMaxThetaUpperMirror "Double AdvEquipmentManagerDNA::GetMaxThetaUpperMirror(void)

return the value of the polar angle of the highest point of the upper analyzer mirror in NeXus-coordinate system

---------------
Return objects:
---------------

value of the polar angle of the highest point of the upper analyzer mirror in NeXus-coordinate system ";

%feature("docstring")  AdvEquipmentManagerDNA::GetMinThetaUpperMirror "Double AdvEquipmentManagerDNA::GetMinThetaUpperMirror(void)

return the value of the polar angle of the lowest point of the upper analyzer mirror in NeXus-coordinate system

---------------
Return objects:
---------------

value of the polar angle of the lowest point of the upper analyzer mirror in NeXus-coordinate system ";

%feature("docstring")  AdvEquipmentManagerDNA::GetMaxThetaLowerMirror "Double AdvEquipmentManagerDNA::GetMaxThetaLowerMirror(void)

return the value of the polar angle of the highest point of the lower analyzer mirror in NeXus-coordinate system

---------------
Return objects:
---------------

value of the polar angle of the highest point of the lower analyzer mirror in NeXus-coordinate system ";

%feature("docstring")  AdvEquipmentManagerDNA::GetMinThetaLowerMirror "Double AdvEquipmentManagerDNA::GetMinThetaLowerMirror(void)

return the value of the polar angle of the lowest point of the lower analyzer mirror in NeXus-coordinate system

---------------
Return objects:
---------------

value of the polar angle of the lowest point of the lower analyzer mirror in NeXus-coordinate system ";

%feature("docstring")  AdvEquipmentManagerDNA::GetCenterPosUpperMirror "Int4 AdvEquipmentManagerDNA::GetCenterPosUpperMirror(struct coordinate *)

get the value of center position of the sphere of the upper analyzer mirror

---------------
Parameters:
---------------

r:  value of center position of the sphere of the upper analyzer mirror ";

%feature("docstring")  AdvEquipmentManagerDNA::GetCenterPosLowerMirror "Int4 AdvEquipmentManagerDNA::GetCenterPosLowerMirror(struct coordinate *)

get the value of center position of the sphere of the lower analyzer mirror

---------------
Parameters:
---------------

r:  value of center position of the sphere of the lower analyzer mirror ";

%feature("docstring")  AdvEquipmentManagerDNA::GenerateNeutron "void AdvEquipmentManagerDNA::GenerateNeutron(UInt4, UInt4, Double, Double, Double, Double, Double, Double)

generate neutron scattered by sample, reflected by analyzer and detected by detector.

generate neutron scattered by sample, reflected by analyzer and detected by detector.

calculate TOF and the efficiency of detector at each detection point.

---------------
Parameters:
---------------

measType:  0: calculation of delt TOF data. 1: calculation of delta Einc data.

nBrag:  Brag reflection rule; 2d sin(theta) = nBrag lambda

startValue:  starting value of TOF (in the case of measType=0) or Einc (in the case of measType=1).

endValue:  ending value of TOF (in the case of measType=0) or Einc (in the case of measType=1).

intervalValue:  interval value of TOF (in the case of measType=0) or Einc (in the case of measType=1).

scaPos:  position of scattering point ";

%feature("docstring")  AdvEquipmentManagerDNA::GetIntegThresholdValue "Double AdvEquipmentManagerDNA::GetIntegThresholdValue(void)

return threshold value used for judgement of convergence in numerial integral

---------------
Return objects:
---------------

epsilon ";

%feature("docstring")  AdvEquipmentManagerDNA::GetIntegThresholdRatio "Double AdvEquipmentManagerDNA::GetIntegThresholdRatio(void)

return threshold value of ratio used for judgement of convergence in numerial integral

---------------
Return objects:
---------------

epsilonRatio ";

%feature("docstring")  AdvEquipmentManagerDNA::SetIntegThresholdValue "void AdvEquipmentManagerDNA::SetIntegThresholdValue(Double a)

set threshold value used for judgement of convergence in numerial integral

epsilon ";

%feature("docstring")  AdvEquipmentManagerDNA::SetIntegThresholdRatio "void AdvEquipmentManagerDNA::SetIntegThresholdRatio(Double a)

set threshold value Ratio used for judgement of convergence in numerial integral

epsilonRatio ";

%feature("docstring")  AdvEquipmentManagerDNA::GetPhi625 "Double AdvEquipmentManagerDNA::GetPhi625(void)

return the value of diameter of sample room

---------------
Return objects:
---------------

value of diameter of sample room ";

%feature("docstring")  AdvEquipmentManagerDNA::GetUpperDetectorPhi "Double AdvEquipmentManagerDNA::GetUpperDetectorPhi(int i, int j)

return the value of diameter for group of PSD units

---------------
Parameters:
---------------

i:  PSD unit number in group

j:  PSD number in unit

---------------
Return objects:
---------------

value of diameter for group of PSD units ";

%feature("docstring")  AdvEquipmentManagerDNA::GetW120 "Double AdvEquipmentManagerDNA::GetW120(void)

return the value of upper hight of sample room measured from sample position

---------------
Return objects:
---------------

value of upper hight of sample room measured from sample position ";

%feature("docstring")  AdvEquipmentManagerDNA::GetW92 "Double AdvEquipmentManagerDNA::GetW92(void)

return the value of lower hight of sample room measured from sample position

---------------
Return objects:
---------------

value of lower hight of sample room measured from sample position ";

%feature("docstring")  AdvEquipmentManagerDNA::GetUpperDetectorWindowLower "Double AdvEquipmentManagerDNA::GetUpperDetectorWindowLower(void)

return the value of the lowest height of the window for the upper detector

---------------
Return objects:
---------------

value of the lowest height of the window for the upper detector ";

%feature("docstring")  AdvEquipmentManagerDNA::GetUpperDetectorWindowUpper "Double AdvEquipmentManagerDNA::GetUpperDetectorWindowUpper(void)

return the value of the highest height of the window for the upper detector

---------------
Return objects:
---------------

value of the highest height of the window for the upper detector ";

%feature("docstring")  AdvEquipmentManagerDNA::GetLowerDetectorWindowLower "Double AdvEquipmentManagerDNA::GetLowerDetectorWindowLower(void)

return the value of the lowest height of the window for the lower detector

---------------
Return objects:
---------------

value of the lowest height of the window for the lower detector ";

%feature("docstring")  AdvEquipmentManagerDNA::GetLowerDetectorWindowUpper "Double AdvEquipmentManagerDNA::GetLowerDetectorWindowUpper(void)

return the value of the highest height of the window for the lower detector

---------------
Return objects:
---------------

value of the highest height of the window for the lower detector ";

%feature("docstring")  AdvEquipmentManagerDNA::GetThetaEnergy "PyObject * AdvEquipmentManagerDNA::GetThetaEnergy(void) ";


// File: classAdvILambdaCorrectionDNA.xml
%feature("docstring") AdvILambdaCorrectionDNA "";

%feature("docstring")  AdvILambdaCorrectionDNA::AdvILambdaCorrectionDNA "AdvILambdaCorrectionDNA::AdvILambdaCorrectionDNA()

Constructor. ";

%feature("docstring")  AdvILambdaCorrectionDNA::AdvILambdaCorrectionDNA "AdvILambdaCorrectionDNA::AdvILambdaCorrectionDNA(ElementContainerMatrix *ecm)

Constructor.

---------------
Parameters:
---------------

ecm:  ElementContainerMatrix for the target ";

%feature("docstring")  AdvILambdaCorrectionDNA::~AdvILambdaCorrectionDNA "AdvILambdaCorrectionDNA::~AdvILambdaCorrectionDNA()

Destructor. ";

%feature("docstring")  AdvILambdaCorrectionDNA::ILCorrection "ElementContainerMatrix AdvILambdaCorrectionDNA::ILCorrection(ElementContainerMatrix ecm, ElementContainer ec0, bool UseMonitorEfficiency, string filepath) ";

%feature("docstring")  AdvILambdaCorrectionDNA::DummyECCreate "ElementContainer AdvILambdaCorrectionDNA::DummyECCreate(ElementContainerMatrix *ecm)

< executes I Lambda Correction

<

---------------
Return objects:
---------------

Noneexecutes I Lambda Correction

None ";


// File: classAdvMultiScatteringDNA.xml
%feature("docstring") AdvMultiScatteringDNA "

ScatAbsoTestSample Class calculates absorption factor and desired value of the scattering from the sample corrected for absorption, based on the following paper. H.H. Paalman and C.J. Pings :: J. Appl. Phys. 33, 2635 (1962).

skoike  0.0  0.0

C++ includes: AdvMultiScatteringDNA.hh ";

%feature("docstring")  AdvMultiScatteringDNA::AdvMultiScatteringDNA "AdvMultiScatteringDNA::AdvMultiScatteringDNA(void) ";

%feature("docstring")  AdvMultiScatteringDNA::AdvMultiScatteringDNA "AdvMultiScatteringDNA::AdvMultiScatteringDNA(string) ";

%feature("docstring")  AdvMultiScatteringDNA::~AdvMultiScatteringDNA "AdvMultiScatteringDNA::~AdvMultiScatteringDNA(void) ";

%feature("docstring")  AdvMultiScatteringDNA::GetIntegThresholdValue "Double AdvMultiScatteringDNA::GetIntegThresholdValue(void)

return threshold value used for judgement of convergence in numerial integral

---------------
Return objects:
---------------

epsilon ";

%feature("docstring")  AdvMultiScatteringDNA::GetIntegThresholdRatio "Double AdvMultiScatteringDNA::GetIntegThresholdRatio(void)

return threshold value of ratio used for judgement of convergence in numerial integral

---------------
Return objects:
---------------

epsilonRatio ";

%feature("docstring")  AdvMultiScatteringDNA::SetIntegThresholdValue "void AdvMultiScatteringDNA::SetIntegThresholdValue(Double a)

set threshold value used for judgement of convergence in numerial integral

epsilon ";

%feature("docstring")  AdvMultiScatteringDNA::SetIntegThresholdRatio "void AdvMultiScatteringDNA::SetIntegThresholdRatio(Double a)

set threshold value Ratio used for judgement of convergence in numerial integral

epsilonRatio ";

%feature("docstring")  AdvMultiScatteringDNA::GetEffectMultiScatSlab "Double AdvMultiScatteringDNA::GetEffectMultiScatSlab(Double, Double, Double)

calculate coefficient factor A_C_C A_C_C is coefficent factor of sell scattered at cell.

---------------
Return objects:
---------------

ACC calculate coefficient factor A_CS_S A_CS_S is coefficent factor of sell+sample scattered at sample.

ACSS calculate coefficient factor A_CS_C A_CS_C is coefficent factor of sell+sample scattered at sample.

ACSS calculate coefficient factor A_S_S A_S_S is coefficent factor of sample scattered at sample. only use in the case of column shape

ASS ";

%feature("docstring")  AdvMultiScatteringDNA::GetEffectMultiScatSlab "Double AdvMultiScatteringDNA::GetEffectMultiScatSlab(Double, Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetEffectMultiScatColumn "Double AdvMultiScatteringDNA::GetEffectMultiScatColumn(Double, Double, Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetEffectMultiScatCylinder "Double AdvMultiScatteringDNA::GetEffectMultiScatCylinder(Double, Double, Double, Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetDeltaForSlab "Double AdvMultiScatteringDNA::GetDeltaForSlab(Double, Double, Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetDeltaForSlab "Double AdvMultiScatteringDNA::GetDeltaForSlab(Double, Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetLargeDeltaForSlab "Double AdvMultiScatteringDNA::GetLargeDeltaForSlab(Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetDeltaForColumn "Double AdvMultiScatteringDNA::GetDeltaForColumn(Double, Double, Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetLargeDeltaForColumn "Double AdvMultiScatteringDNA::GetLargeDeltaForColumn(Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetDeltaForCylinder "Double AdvMultiScatteringDNA::GetDeltaForCylinder(Double, Double, Double, Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetLargeDeltaForCylinder "Double AdvMultiScatteringDNA::GetLargeDeltaForCylinder(Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetFracSingle "Double AdvMultiScatteringDNA::GetFracSingle(Double, Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetFracDouble "Double AdvMultiScatteringDNA::GetFracDouble(Double, Double) ";

%feature("docstring")  AdvMultiScatteringDNA::GetFracOverTriple "Double AdvMultiScatteringDNA::GetFracOverTriple(Double, Double) ";


// File: classAdvNeutronManagerDNA.xml
%feature("docstring") AdvNeutronManagerDNA "

Class AdvNeutronManagerDNA This class manages each neutron information scattered at sample.

Koike Soh, AdvanceSoft Corp.

0.0

C++ includes: AdvNeutronManagerDNA.hh ";

%feature("docstring")  AdvNeutronManagerDNA::AdvNeutronManagerDNA "AdvNeutronManagerDNA::AdvNeutronManagerDNA(void)

A constructor.

set default value for private variables. ";

%feature("docstring")  AdvNeutronManagerDNA::AdvNeutronManagerDNA "AdvNeutronManagerDNA::AdvNeutronManagerDNA(class AdvEquipmentManagerDNA *)

A constructor

set default value for private variables.

---------------
Parameters:
---------------

*equipmentMan:  pointer for the instance of EquipmentManager class ";

%feature("docstring")  AdvNeutronManagerDNA::~AdvNeutronManagerDNA "AdvNeutronManagerDNA::~AdvNeutronManagerDNA(void)

A destructor.

do nothing ";

%feature("docstring")  AdvNeutronManagerDNA::SetNeutronData "Int4 AdvNeutronManagerDNA::SetNeutronData(Int4)

set neutron data to neutronInfo variable.

calculate the value of energy, theta, tof, etc of the neutron.

---------------
Parameters:
---------------

nBrag:  nBrag times Lambda = 2d sin (thetaBrag) ";

%feature("docstring")  AdvNeutronManagerDNA::GetNeutronInfo "Int4 AdvNeutronManagerDNA::GetNeutronInfo(struct neutronInfo *)

give the information of neutron.

---------------
Parameters:
---------------

neutronOutput:  neutronInfo-type struct variable in which information of neutron is saved ";

%feature("docstring")  AdvNeutronManagerDNA::PutDetPos "Int4 AdvNeutronManagerDNA::PutDetPos(Double, Double, Double)

obtain the coordinate of detected point from outer subroutine.

---------------
Parameters:
---------------

detPosX:  x-coordinate of detected point of neutron

detPosY:  y-coordinate of detected point of neutron

detPosZ:  z-coordinate of detected point of neutron ";

%feature("docstring")  AdvNeutronManagerDNA::PutScaPos "Int4 AdvNeutronManagerDNA::PutScaPos(Double, Double, Double)

obtain the coordinate of the scattering center point from outer subroutine.

---------------
Parameters:
---------------

scaPosX:  x-coordinate of scattering point of neutron in the sample

scaPosY:  y-coordinate of scattering point of neutron in the sample

scaPosZ:  z-coordinate of scattering point of neutron in the sample ";

%feature("docstring")  AdvNeutronManagerDNA::CalcIncEnergies "Int4 AdvNeutronManagerDNA::CalcIncEnergies(Double, Double, Double)

calculate incident energies for neutrons

---------------
Parameters:
---------------

startTime:  start value of TOF

endTime:  end value of TOF

intervalTime:  interval value of TOF for calculation ";

%feature("docstring")  AdvNeutronManagerDNA::CalcTof "Int4 AdvNeutronManagerDNA::CalcTof(Double, Double, Double)

calculate TOF

---------------
Parameters:
---------------

minEnergy:  minimum energy for neutron

maxEnergy:  maxmum energy for neutron

intervalEnergy:  interval energy for calculation ";

%feature("docstring")  AdvNeutronManagerDNA::ReturnEfficiencyDetector "Double AdvNeutronManagerDNA::ReturnEfficiencyDetector(Double, Double)

return effciency of detector

---------------
Return values:
---------------

efficiency:  of detector ";


// File: classAdvNeutronMonitorDNA.xml
%feature("docstring") AdvNeutronMonitorDNA "";

%feature("docstring")  AdvNeutronMonitorDNA::AdvNeutronMonitorDNA "AdvNeutronMonitorDNA::AdvNeutronMonitorDNA(void) ";

%feature("docstring")  AdvNeutronMonitorDNA::AdvNeutronMonitorDNA "AdvNeutronMonitorDNA::AdvNeutronMonitorDNA(string) ";

%feature("docstring")  AdvNeutronMonitorDNA::~AdvNeutronMonitorDNA "AdvNeutronMonitorDNA::~AdvNeutronMonitorDNA(void) ";

%feature("docstring")  AdvNeutronMonitorDNA::TranslateFromTToE "void AdvNeutronMonitorDNA::TranslateFromTToE(void) ";

%feature("docstring")  AdvNeutronMonitorDNA::TranslateFromTToE "ElementContainer & AdvNeutronMonitorDNA::TranslateFromTToE(ElementContainer &ec) ";

%feature("docstring")  AdvNeutronMonitorDNA::SetLengthFromSource "void AdvNeutronMonitorDNA::SetLengthFromSource(Double) ";

%feature("docstring")  AdvNeutronMonitorDNA::GetMonitorEfficiency "Double AdvNeutronMonitorDNA::GetMonitorEfficiency(Double) ";

%feature("docstring")  AdvNeutronMonitorDNA::GetWallEfficiency "Double AdvNeutronMonitorDNA::GetWallEfficiency(Double) ";

%feature("docstring")  AdvNeutronMonitorDNA::SetIntensityAtSource "void AdvNeutronMonitorDNA::SetIntensityAtSource(void) ";

%feature("docstring")  AdvNeutronMonitorDNA::SetIntensityAtSource "void AdvNeutronMonitorDNA::SetIntensityAtSource(ElementContainer &monitorCount) ";

%feature("docstring")  AdvNeutronMonitorDNA::GetIntensityAtSample "void AdvNeutronMonitorDNA::GetIntensityAtSample(void) ";

%feature("docstring")  AdvNeutronMonitorDNA::GetIntensityAtSample "void AdvNeutronMonitorDNA::GetIntensityAtSample(ElementContainer &monitorCount, ElementContainerArray &eca) ";

%feature("docstring")  AdvNeutronMonitorDNA::GetIntensityAtSample "void AdvNeutronMonitorDNA::GetIntensityAtSample(ElementContainer &monitorCount, ElementContainer &ec) ";

%feature("docstring")  AdvNeutronMonitorDNA::outputResult "void AdvNeutronMonitorDNA::outputResult(string &fileName) ";

%feature("docstring")  AdvNeutronMonitorDNA::toContainer "void AdvNeutronMonitorDNA::toContainer(ElementContainerArray &eca) ";

%feature("docstring")  AdvNeutronMonitorDNA::toContainer "void AdvNeutronMonitorDNA::toContainer(ElementContainer &ec) ";

%feature("docstring")  AdvNeutronMonitorDNA::GetIntensityAtSample "ElementContainer AdvNeutronMonitorDNA::GetIntensityAtSample(ElementContainer monitorCount) ";

%feature("docstring")  AdvNeutronMonitorDNA::getCorrection "ElementContainerArray AdvNeutronMonitorDNA::getCorrection() ";


// File: classAdvQECalculation.xml
%feature("docstring") AdvQECalculation "

Function to calculate QE from Pixel position.

C++ includes: AdvQECalculation.hh ";

%feature("docstring")  AdvQECalculation::AdvQECalculation "AdvQECalculation::AdvQECalculation()

Constructor. ";

%feature("docstring")  AdvQECalculation::AdvQECalculation "AdvQECalculation::AdvQECalculation(ElementContainerMatrix *ecm)

Constructor.

---------------
Parameters:
---------------

ecm:  ElementContainerMatrix for the target ";

%feature("docstring")  AdvQECalculation::~AdvQECalculation "AdvQECalculation::~AdvQECalculation()

Destructor. ";

%feature("docstring")  AdvQECalculation::CalcQE "ElementContainerArray AdvQECalculation::CalcQE(double startQ, double endQ, double deltaQ)

executes calclulation of QE

---------------
Return objects:
---------------

None ";


// File: classAdvScatAbsoBodyManagerDNA.xml
%feature("docstring") AdvScatAbsoBodyManagerDNA "

Scatterer and Absoannt

Koike Soh, AdvanceSoft Corp. (original)

TANIMORI Souichirou, AdvanceSoft Corp.

0.0

C++ includes: AdvScatAbsoBodyManagerDNA.hh ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::AdvScatAbsoBodyManagerDNA "AdvScatAbsoBodyManagerDNA::AdvScatAbsoBodyManagerDNA(void)

A constructor

set default atomicDataFile ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::AdvScatAbsoBodyManagerDNA "AdvScatAbsoBodyManagerDNA::AdvScatAbsoBodyManagerDNA(string) ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::~AdvScatAbsoBodyManagerDNA "virtual AdvScatAbsoBodyManagerDNA::~AdvScatAbsoBodyManagerDNA(void)

A destructor

do nothing ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetAtomSigmaFromVelocityRule "Double AdvScatAbsoBodyManagerDNA::GetAtomSigmaFromVelocityRule(string atomname, Char state, double velocity)

get measured value of scattering/absorption cross section of the specified nuclide or atom

---------------
Parameters:
---------------

atomname:  atomic name

state:  'a': absorption, 's': scattering, 't': total

velocity:  incident neutron velocity

---------------
Return values:
---------------

cross:  section for specified atom ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetSigmaFromVelocityRule "void AdvScatAbsoBodyManagerDNA::GetSigmaFromVelocityRule(struct ScatAbsoInfo *, struct ScatAbsoInfo *, double, double *, double *, double *)

get the cross cection data

---------------
Parameters:
---------------

*wInfo:  pointer for struct variable wallInfo

*bInfo:  pointer for struct variable bodyInfo

energy:  incident energy of neutron

*sigmaBA:  absorption cross section for body

*sigmaWA:  absorption cross section for wall

*sigmaWS:  scattering cross section for wall

get cross section data for body and wall by use of velocity rule.

---------------
Parameters:
---------------

*wInfo:  pointer for struct variable wallInfo

*bInfo:  pointer for struct variable bodyInfo

energy:  incident energy of neutron

*sigmaBA:  absorption cross section for body

*sigmaWA:  absorption cross section for wall

*sigmaWS:  scattering cross section for wall ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::ReturnSigmaFromVelocityRule "Double AdvScatAbsoBodyManagerDNA::ReturnSigmaFromVelocityRule(struct ScatAbsoInfo *, Double, Char)

return cross section data obtained by velocity rule.

---------------
Parameters:
---------------

*info:  pointer for struct variable AdvScatAbsoBodyManagerDNA

energy:  neutron energy

state:  'a' (absorption), 's' (scattering), t: total

---------------
Return values:
---------------

cross:  section for wall or body

return cross section obtained by velocity rule.

---------------
Parameters:
---------------

info:  pointer for struct variable AdvScatAbsoBodyManagerDNA

energy:  incident energy of neutron

state:  'a': absorption, 's': scattering

---------------
Return values:
---------------

cross:  section for wall or body ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::SetInfoData "void AdvScatAbsoBodyManagerDNA::SetInfoData(string filename, struct ScatAbsoInfo *wallInfo, struct ScatAbsoInfo *bodyInfo)

set AdvScatAbsoBodyManagerDNA variables to values from specified file.

---------------
Parameters:
---------------

filename:  scatterer and/or absorbent data file

wallInfo:  information of wall of container

bodyInfo:  information of scatterer and/or absorbent

set value to AdvScatAbsoBodyManagerDNA variable.

---------------
Parameters:
---------------

filename:  scatterer and/or absorbent data file

wallInfo:  information of wall of container

bodyInfo:  information of scatterer and/or absorbent ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::SetSigmaDataNIST "void AdvScatAbsoBodyManagerDNA::SetSigmaDataNIST(Double velocity, string atomname, string typeCS)

set an array to cross section data from the file recorded NIST data.

---------------
Parameters:
---------------

velocity:

atomname:  atomic name

typeCS:  type of scattering and absorption data. available values of typeCS 't' sum of scattering cross section and absorption cross sction midefied using user specified velocity

'a' absorption cross sction midefied using user specified velocity

's' scattering cross section

'c' cohrent length

'i' incoherent length

array dataCS[][] in the class keeps NIST data in following way, dataCS[0][0] incident neutron velocity at measurement

dataCS[0][1] user specified data using character symbol

set sigma by use of database file made by NIST

---------------
Parameters:
---------------

atomname:  atomic name

typeCS:  mass number, atomic name and scattering type ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetIntegThresholdValue "Double AdvScatAbsoBodyManagerDNA::GetIntegThresholdValue(void)

return threshold value used for judgement of convergence in numerial integral

---------------
Return objects:
---------------

epsilon ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetIntegThresholdRatio "Double AdvScatAbsoBodyManagerDNA::GetIntegThresholdRatio(void)

return threshold value of ratio used for judgement of convergence in numerial integral

---------------
Return objects:
---------------

epsilonRatio ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::SetIntegThresholdValue "void AdvScatAbsoBodyManagerDNA::SetIntegThresholdValue(Double a)

set threshold value used for judgement of convergence in numerial integral

epsilon ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::SetIntegThresholdRatio "void AdvScatAbsoBodyManagerDNA::SetIntegThresholdRatio(Double a)

set threshold value Ratio used for judgement of convergence in numerial integral

epsilonRatio ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::SetSigmaCoefficient "void AdvScatAbsoBodyManagerDNA::SetSigmaCoefficient(Double, Double, Double) ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::SetSigmaCoefficient "void AdvScatAbsoBodyManagerDNA::SetSigmaCoefficient(ElementContainerArray, Double, Double) ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetCohCSF "Double AdvScatAbsoBodyManagerDNA::GetCohCSF() ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetIncCSF "Double AdvScatAbsoBodyManagerDNA::GetIncCSF() ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetAbsCSF "Double AdvScatAbsoBodyManagerDNA::GetAbsCSF() ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetQDepCohCSF "Double AdvScatAbsoBodyManagerDNA::GetQDepCohCSF(Double) ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetQDepCohCSF "vector< Double > AdvScatAbsoBodyManagerDNA::GetQDepCohCSF() ";

%feature("docstring")  AdvScatAbsoBodyManagerDNA::GetQDepCohCSFq "vector< Double > AdvScatAbsoBodyManagerDNA::GetQDepCohCSFq() ";


// File: classAdvSliceQE.xml
%feature("docstring") AdvSliceQE "";

%feature("docstring")  AdvSliceQE::AdvSliceQE "AdvSliceQE::AdvSliceQE()

Constructor.

Constructor

---------------
Parameters:
---------------

ecm:  ElementContainerMatrix for the target ";

%feature("docstring")  AdvSliceQE::~AdvSliceQE "AdvSliceQE::~AdvSliceQE()

Destructor. ";

%feature("docstring")  AdvSliceQE::Slice "ElementContainer AdvSliceQE::Slice(ElementContainerArray *eca, double lowerValue, double upperValue) ";


// File: classAdvSolidAngleCorrectionDNA.xml
%feature("docstring") AdvSolidAngleCorrectionDNA "";

%feature("docstring")  AdvSolidAngleCorrectionDNA::AdvSolidAngleCorrectionDNA "AdvSolidAngleCorrectionDNA::AdvSolidAngleCorrectionDNA()

Constructor. ";

%feature("docstring")  AdvSolidAngleCorrectionDNA::AdvSolidAngleCorrectionDNA "AdvSolidAngleCorrectionDNA::AdvSolidAngleCorrectionDNA(ElementContainerMatrix *ecm)

Constructor.

---------------
Parameters:
---------------

ecm:  ElementContainerMatrix for the target ";

%feature("docstring")  AdvSolidAngleCorrectionDNA::~AdvSolidAngleCorrectionDNA "AdvSolidAngleCorrectionDNA::~AdvSolidAngleCorrectionDNA()

Destructor. ";

%feature("docstring")  AdvSolidAngleCorrectionDNA::SACorrection "ElementContainerMatrix AdvSolidAngleCorrectionDNA::SACorrection(ElementContainerMatrix ecm, bool UseDetectorEfficiency, bool UseSampleAbsoCorr, bool UseCorrEfficiency, string sampleType, string sampleDataPath, string detectorDataPath, char *corrEffDataPath) ";


// File: classConvManyoDoxy2Swig_1_1Doxy2SWIG.xml
%feature("docstring") ConvManyoDoxy2Swig::Doxy2SWIG "

Converts Doxygen generated XML files into a file containing docstrings that can be used by SWIG-1.3.x that have support for feature(\"docstring\").  Once the data is parsed it is stored in self.pieces. ";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::__init__ "def ConvManyoDoxy2Swig.Doxy2SWIG.__init__ Initialize the instance given a source object (file or filename). ";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::generate "def ConvManyoDoxy2Swig.Doxy2SWIG.generate Parses the file set in the initialization.  The resulting data is stored in `self.pieces`. ";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::parse "def ConvManyoDoxy2Swig.Doxy2SWIG.parse Parse a given node.  This function in turn calls the `parse_<nodeType>` functions which handle the respective nodes. ";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::parse_Document "def ConvManyoDoxy2Swig.Doxy2SWIG.parse_Document";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::parse_Text "def ConvManyoDoxy2Swig.Doxy2SWIG.parse_Text";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::parse_Element "def ConvManyoDoxy2Swig.Doxy2SWIG.parse_Element Parse an `ELEMENT_NODE`.  This calls specific `do_<tagName>` handers for different elements.  If no handler is available the `generic_parse` method is called.  All tagNames specified in `self.ignores` are simply ignored. ";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::add_text "def ConvManyoDoxy2Swig.Doxy2SWIG.add_text Adds text corresponding to `value` into `self.pieces`. ";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::get_specific_nodes "def ConvManyoDoxy2Swig.Doxy2SWIG.get_specific_nodes Given a node and a sequence of strings in `names`, return a dictionary containing the names as keys and child `ELEMENT_NODEs`, that have a `tagName` equal to the name. ";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::generic_parse "def ConvManyoDoxy2Swig.Doxy2SWIG.generic_parse A Generic parser for arbitrary tags in a node.  Parameters:   - node:  A node in the DOM.  - pad: `int` (default: 0)     If 0 the node data is not padded with newlines.  If 1 it    appends a newline after parsing the childNodes.  If 2 it    pads before and after the nodes are processed.  Defaults to    0. ";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::space_parse "def ConvManyoDoxy2Swig.Doxy2SWIG.space_parse";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_compoundname "def ConvManyoDoxy2Swig.Doxy2SWIG.do_compoundname";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_compounddef "def ConvManyoDoxy2Swig.Doxy2SWIG.do_compounddef";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_includes "def ConvManyoDoxy2Swig.Doxy2SWIG.do_includes";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_parameterlist "def ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterlist";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_para "def ConvManyoDoxy2Swig.Doxy2SWIG.do_para";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_parametername "def ConvManyoDoxy2Swig.Doxy2SWIG.do_parametername";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_parameterdefinition "def ConvManyoDoxy2Swig.Doxy2SWIG.do_parameterdefinition";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_detaileddescription "def ConvManyoDoxy2Swig.Doxy2SWIG.do_detaileddescription";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_briefdescription "def ConvManyoDoxy2Swig.Doxy2SWIG.do_briefdescription";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_memberdef "def ConvManyoDoxy2Swig.Doxy2SWIG.do_memberdef";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_definition "def ConvManyoDoxy2Swig.Doxy2SWIG.do_definition";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_sectiondef "def ConvManyoDoxy2Swig.Doxy2SWIG.do_sectiondef";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_simplesect "def ConvManyoDoxy2Swig.Doxy2SWIG.do_simplesect";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_argsstring "def ConvManyoDoxy2Swig.Doxy2SWIG.do_argsstring";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_member "def ConvManyoDoxy2Swig.Doxy2SWIG.do_member";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::do_doxygenindex "def ConvManyoDoxy2Swig.Doxy2SWIG.do_doxygenindex";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::write "def ConvManyoDoxy2Swig.Doxy2SWIG.write";

%feature("docstring")  ConvManyoDoxy2Swig::Doxy2SWIG::clean_pieces "def ConvManyoDoxy2Swig.Doxy2SWIG.clean_pieces Cleans the list of strings given as `pieces`.  It replaces multiple newlines by a maximum of 2 and returns a new list. It also wraps the paragraphs nicely. ";


// File: classUtsusemiChopCondInfoReaderTrignet.xml
%feature("docstring") UtsusemiChopCondInfoReaderTrignet "";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::UtsusemiChopCondInfoReaderTrignet "UtsusemiChopCondInfoReaderTrignet::UtsusemiChopCondInfoReaderTrignet()

Constructor. ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::UtsusemiChopCondInfoReaderTrignet "UtsusemiChopCondInfoReaderTrignet::UtsusemiChopCondInfoReaderTrignet(string filename)

Constructor.

---------------
Parameters:
---------------

filename:  (string) path to CaseInfo.xml ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::~UtsusemiChopCondInfoReaderTrignet "UtsusemiChopCondInfoReaderTrignet::~UtsusemiChopCondInfoReaderTrignet()

Destructor. ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutFastChopperFrequency "Double UtsusemiChopCondInfoReaderTrignet::PutFastChopperFrequency() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutNumOfFastChopperSlit "UInt4 UtsusemiChopCondInfoReaderTrignet::PutNumOfFastChopperSlit() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutFastChopperSlitWidth "vector< Double > UtsusemiChopCondInfoReaderTrignet::PutFastChopperSlitWidth() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutFastChopperSlitAngle "vector< Double > UtsusemiChopCondInfoReaderTrignet::PutFastChopperSlitAngle() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutFastChopperMode "UInt4 UtsusemiChopCondInfoReaderTrignet::PutFastChopperMode() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutL1 "Double UtsusemiChopCondInfoReaderTrignet::PutL1() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutLChopper "Double UtsusemiChopCondInfoReaderTrignet::PutLChopper() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutLBandChopper "Double UtsusemiChopCondInfoReaderTrignet::PutLBandChopper() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutLambdaCenter "Double UtsusemiChopCondInfoReaderTrignet::PutLambdaCenter() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutDeltaLambda "Double UtsusemiChopCondInfoReaderTrignet::PutDeltaLambda() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutTOFoffset "Double UtsusemiChopCondInfoReaderTrignet::PutTOFoffset() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutTOFResolver1 "Double UtsusemiChopCondInfoReaderTrignet::PutTOFResolver1() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutTOFResolver2 "Double UtsusemiChopCondInfoReaderTrignet::PutTOFResolver2() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutTOFSourceMin "Double UtsusemiChopCondInfoReaderTrignet::PutTOFSourceMin() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutTOFSourceMax "Double UtsusemiChopCondInfoReaderTrignet::PutTOFSourceMax() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::PutTOFbintype "Int4 UtsusemiChopCondInfoReaderTrignet::PutTOFbintype() ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::ImportDetectorInfo "Int4 UtsusemiChopCondInfoReaderTrignet::ImportDetectorInfo(string filepath) ";

%feature("docstring")  UtsusemiChopCondInfoReaderTrignet::ImportWiringInfo "Int4 UtsusemiChopCondInfoReaderTrignet::ImportWiringInfo(string filepath) ";


// File: classUtsusemiEventDataConverterDNA.xml
%feature("docstring") UtsusemiEventDataConverterDNA "

Load Event Data and convert to Histogram for Inelastic scattering.

LoadParamFiles( \"WiringInfo.xml\", \"DetectorInfo.xml\", \"CaseInfo.xml\" ) LoadTrignetEventFile( runNo, \"/data\", \"\" ) SetHistAllocation() ecm = ElementContainerMatrix() SetElementContainerMatrix( ecm, runNo, \"/data\", \"\" )

C++ includes: UtsusemiEventDataConverterDNA.hh ";

%feature("docstring")  UtsusemiEventDataConverterDNA::UtsusemiEventDataConverterDNA "UtsusemiEventDataConverterDNA::UtsusemiEventDataConverterDNA()

Constructor. ";

%feature("docstring")  UtsusemiEventDataConverterDNA::~UtsusemiEventDataConverterDNA "UtsusemiEventDataConverterDNA::~UtsusemiEventDataConverterDNA()

Destructor. ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetLambdaParam "void UtsusemiEventDataConverterDNA::SetLambdaParam(Double LambdaCenter, Double deltaLambda) ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetTOFOffset "void UtsusemiEventDataConverterDNA::SetTOFOffset(Double tofOffset) ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetTOFResolver "void UtsusemiEventDataConverterDNA::SetTOFResolver(Double tofResolver) ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetTOFResolver "void UtsusemiEventDataConverterDNA::SetTOFResolver(Double tofResolver1, Double tofResolver2) ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetTimeParamAtSource "void UtsusemiEventDataConverterDNA::SetTimeParamAtSource(Double tofSourceMin, Double tofSourceMax) ";

%feature("docstring")  UtsusemiEventDataConverterDNA::LoadParamFiles "void UtsusemiEventDataConverterDNA::LoadParamFiles(string w_file, string d_file, string c_file=\"\")

Loads parameter files.

This executes SetEventParams and SetCaseInfoParams of EventDataConverterTemplate.

---------------
Parameters:
---------------

w_file:  (string) Wiring Info file path

d_file:  (string) Detector Info file path

c_file:  (string) Case Info file path

---------------
Return objects:
---------------

None ";

%feature("docstring")  UtsusemiEventDataConverterDNA::LoadChopCondFile "void UtsusemiEventDataConverterDNA::LoadChopCondFile(string w_file, string d_file, string cc_file) ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetElementContainerDNA "void UtsusemiEventDataConverterDNA::SetElementContainerDNA(UInt4 outer_pixel_id, ElementContainer *ec, UInt4 caseId=1)

Sets Histogram into ElementContainer.

---------------
Parameters:
---------------

outer_pixel_id:  (UInt4) pixel_id

ec:  (ElementContainer*)

caseId:  (UInt4)

---------------
Return objects:
---------------

None ";

%feature("docstring")  UtsusemiEventDataConverterDNA::LoadEventDataFiles "Int4 UtsusemiEventDataConverterDNA::LoadEventDataFiles(UInt4 runNumber, string pathToData=\"\", string pathToT0data=\"\")

Loads event data files.

---------------
Parameters:
---------------

runNumber:  (UInt4) run number

pathToData:  (string) path to root directory of instruments event data folders (\"/data\")

pathToT0data:  (string) path to directory to store T0Index event data files

---------------
Return objects:
---------------

None ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetElementContainerMatrix "void UtsusemiEventDataConverterDNA::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 caseId=1) ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetElementContainerMatrix "void UtsusemiEventDataConverterDNA::SetElementContainerMatrix(ElementContainerMatrix *ecm, UInt4 runNuber, string pathToData, string pathToT0data=\"\", UInt4 caseId=1)

Sets Histogram into ElementContainerMatrix.

SetElementContainerMatrix( ElementContainerMatrix* ecm, UInt4 caseId=1 ) SetElementContainerMatrix( ElementContainerMatrix* ecm, string instCode, UInt4 runNuber, string pathToData=\"\", string pathToT0data=\"\", UInt4 caseId=1 )

---------------
Parameters:
---------------

ecm:  (ElementContainerMatrix*)

instCode:  (string) Instrument code

runNumber:  (UInt4) run number

pathToData:  (string) path to root directory of instruments event data folders (\"/data\")

pathToT0data:  (string) path to directory to store T0Index event data files

caseId:  (UInt4) case ID

---------------
Return objects:
---------------

None ";

%feature("docstring")  UtsusemiEventDataConverterDNA::LoadTrignetChopFile "void UtsusemiEventDataConverterDNA::LoadTrignetChopFile(UInt4 runno, string pathToData, string pathToT0data) ";

%feature("docstring")  UtsusemiEventDataConverterDNA::LoadTrignetEventFile "void UtsusemiEventDataConverterDNA::LoadTrignetEventFile(UInt4 runno, string pathToData=\"\", string pathToT0data=\"\") ";

%feature("docstring")  UtsusemiEventDataConverterDNA::ReadTrignetEventFile "void UtsusemiEventDataConverterDNA::ReadTrignetEventFile(string pathToTrigData, UInt4 index=0)

Reads Trignet Event data file for cases.

---------------
Parameters:
---------------

pathToTrigData:  (string) path to TrigNET event data files

index:  (UInt4) event file index

---------------
Return objects:
---------------

None ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetRangeOfSingleTimeSlicing "void UtsusemiEventDataConverterDNA::SetRangeOfSingleTimeSlicing(double startSec, double endSec)

Sets time range for time slice of event data.

Values for time are indicated the passed time [sec] from head of event data

---------------
Parameters:
---------------

startSec:  start time [sec]

endSec:  end time [sec]

---------------
Return objects:
---------------

None ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetRangeOfSingleTimeSlicing "Int4 UtsusemiEventDataConverterDNA::SetRangeOfSingleTimeSlicing(string startDate, string endDate)

Sets time range for time slice of event data.

Values for time are indicated the passed time [sec] from head of event data string format : \"YYYY,MM,DD,hh,mm,ss,s.ss\", \"2011,1,22,13,54,22,0.54\"

---------------
Parameters:
---------------

startDate:  start date string

endDate:  end date string

---------------
Return objects:
---------------

None ";

%feature("docstring")  UtsusemiEventDataConverterDNA::DumpCaseTable "vector< UInt4 > UtsusemiEventDataConverterDNA::DumpCaseTable(UInt4 i1, UInt4 i2, bool isI1Size, bool isI2Size)

Dumps table of cases.

---------------
Parameters:
---------------

i1:  (UInt4)

i2:  (UInt4)

isI1Size:  (bool)

isI2Size:  (bool)

---------------
Return objects:
---------------

None ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetElementContainerMatrixForPseudOnLineMon "void UtsusemiEventDataConverterDNA::SetElementContainerMatrixForPseudOnLineMon(ElementContainerMatrix *ecm, UInt4 caseId=1, UInt4 runNo=999999)

Sets histograms to ElementContainermatrix as pseud on-line monitor.

---------------
Parameters:
---------------

ecm:  (ElementContainerMatrix*)

caseId:  (UInt4) case ID

runNo:  (UInt4) run number

isI2Size:  (bool)

---------------
Return objects:
---------------

None ";

%feature("docstring")  UtsusemiEventDataConverterDNA::PutListOfCases "vector<UInt4> UtsusemiEventDataConverterDNA::PutListOfCases()

Puts list of cases.

---------------
Parameters:
---------------

None:

---------------
Return objects:
---------------

list of cases ";

%feature("docstring")  UtsusemiEventDataConverterDNA::SetDataPathTest "Int4 UtsusemiEventDataConverterDNA::SetDataPathTest(string dataPath, string t0Path, UInt4 runNo) ";


// File: classUtsusemiFilterTrignetConditionDNA.xml
%feature("docstring") UtsusemiFilterTrignetConditionDNA "";

%feature("docstring")  UtsusemiFilterTrignetConditionDNA::UtsusemiFilterTrignetConditionDNA "UtsusemiFilterTrignetConditionDNA::UtsusemiFilterTrignetConditionDNA() ";

%feature("docstring")  UtsusemiFilterTrignetConditionDNA::~UtsusemiFilterTrignetConditionDNA "UtsusemiFilterTrignetConditionDNA::~UtsusemiFilterTrignetConditionDNA() ";

%feature("docstring")  UtsusemiFilterTrignetConditionDNA::CalcBandRange "vector< Double > UtsusemiFilterTrignetConditionDNA::CalcBandRange() ";

%feature("docstring")  UtsusemiFilterTrignetConditionDNA::CalcTOFRange "vector< vector< Double > > UtsusemiFilterTrignetConditionDNA::CalcTOFRange(vector< vector< Double > > ChopperCaseTablesIn) ";

%feature("docstring")  UtsusemiFilterTrignetConditionDNA::CalcTOFRangeDebug "vector< vector< Double > > UtsusemiFilterTrignetConditionDNA::CalcTOFRangeDebug(vector< vector< Double > > ChopperCaseTablesIn) ";

%feature("docstring")  UtsusemiFilterTrignetConditionDNA::CalcTOFSlit "vector< vector< Double > > UtsusemiFilterTrignetConditionDNA::CalcTOFSlit(vector< vector< UInt4 > >, vector< Double >) ";

%feature("docstring")  UtsusemiFilterTrignetConditionDNA::CalcTOFSlit "vector< vector< Double > > UtsusemiFilterTrignetConditionDNA::CalcTOFSlit(vector< vector< UInt4 > >, vector< vector< UInt4 > >, vector< Double >) ";


// File: classUtsusemiFilterTrignetDNA.xml
%feature("docstring") UtsusemiFilterTrignetDNA "";

%feature("docstring")  UtsusemiFilterTrignetDNA::UtsusemiFilterTrignetDNA "UtsusemiFilterTrignetDNA::UtsusemiFilterTrignetDNA() ";

%feature("docstring")  UtsusemiFilterTrignetDNA::~UtsusemiFilterTrignetDNA "UtsusemiFilterTrignetDNA::~UtsusemiFilterTrignetDNA() ";

%feature("docstring")  UtsusemiFilterTrignetDNA::SetTOFL2L3 "void UtsusemiFilterTrignetDNA::SetTOFL2L3(vector< Double > pixelTOFL2L3) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::ClearAllChopTables "void UtsusemiFilterTrignetDNA::ClearAllChopTables(UInt4 index, bool makeNew=false) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::ClearAllMulthChopTables "void UtsusemiFilterTrignetDNA::ClearAllMulthChopTables(UInt4 index, UInt4 multh_num, bool makeNew=false) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::LoadTrignetChopEventFile "Int4 UtsusemiFilterTrignetDNA::LoadTrignetChopEventFile(UInt4 index, vector< string > evt_files, vector< string > t0b_files) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::SetChopCondFile "void UtsusemiFilterTrignetDNA::SetChopCondFile(string w_file, string d_file, string cc_file) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::SetLambdaParam "void UtsusemiFilterTrignetDNA::SetLambdaParam(Double lambdaCenter, Double deltaLambda) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::SetTOFOffset "void UtsusemiFilterTrignetDNA::SetTOFOffset(Double offset) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::SetTOFResolver "void UtsusemiFilterTrignetDNA::SetTOFResolver(Double offset) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::SetTOFResolver "void UtsusemiFilterTrignetDNA::SetTOFResolver(Double offset1, Double offset2) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::SetTimeParamAtSource "void UtsusemiFilterTrignetDNA::SetTimeParamAtSource(Double tofSourceMin, Double tofSourceMax) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::ReadTrignetChopEvent "void UtsusemiFilterTrignetDNA::ReadTrignetChopEvent(vector< std::string > trig_event_files, vector< std::string > trig_t0_files, UInt4 index) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::ChopCondSorting "void UtsusemiFilterTrignetDNA::ChopCondSorting(const UChar *data, UInt4 size, UInt4 index, UInt4 ThNum) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::PreChopCondSorting "void UtsusemiFilterTrignetDNA::PreChopCondSorting(const UChar *data, vector< UInt4 > T0Table, UInt4 index) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::MakeChopCondTable "void UtsusemiFilterTrignetDNA::MakeChopCondTable() ";

%feature("docstring")  UtsusemiFilterTrignetDNA::ReadCaseEvent "Int4 UtsusemiFilterTrignetDNA::ReadCaseEvent(UInt4 index, vector< string > evt_files, vector< string > t0b_files) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::ReadTrigEvent "void UtsusemiFilterTrignetDNA::ReadTrigEvent(vector< string > trig_event_files, vector< string > trig_t0_files, UInt4 index) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::MakeCaseTable "void UtsusemiFilterTrignetDNA::MakeCaseTable() ";

%feature("docstring")  UtsusemiFilterTrignetDNA::DumpCaseTable "void UtsusemiFilterTrignetDNA::DumpCaseTable(vector< vector< UInt4 > > ChopperCaseTables1, vector< vector< Double > > ChopperCaseTables2) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::DumpCaseTable "void UtsusemiFilterTrignetDNA::DumpCaseTable(vector< vector< Double > > ChopperCaseTables1, string tag) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::DumpCaseTable "void UtsusemiFilterTrignetDNA::DumpCaseTable(vector< Double > ChopperCaseTables1, string tag) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::DumpCaseTable "void UtsusemiFilterTrignetDNA::DumpCaseTable(vector< Double > ChopperCaseTables1, string tag, Double offset) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::DumpCaseTable "void UtsusemiFilterTrignetDNA::DumpCaseTable(vector< vector< UInt4 > > ChopperCaseTables1, string tag) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::DumpCaseTable "void UtsusemiFilterTrignetDNA::DumpCaseTable(vector< vector< UInt4 > * > *ChopperCaseTables1, string tag) ";

%feature("docstring")  UtsusemiFilterTrignetDNA::GetCaseFromTof "UInt4 UtsusemiFilterTrignetDNA::GetCaseFromTof(const UInt4 pixelId, Double *tof, vector< UInt4 > *caseVec) ";


// File: classUtsusemiNeunetEventDecoderDNA.xml
%feature("docstring") UtsusemiNeunetEventDecoderDNA "

Decode Event Data of NEUNET for Utsusemi of DNA.

C++ includes: UtsusemiNeunetEventDecoderDNA.hh ";

%feature("docstring")  UtsusemiNeunetEventDecoderDNA::UtsusemiNeunetEventDecoderDNA "UtsusemiNeunetEventDecoderDNA::UtsusemiNeunetEventDecoderDNA()

Constructor.

< XML parser

< XML parser

< XML parser ";

%feature("docstring")  UtsusemiNeunetEventDecoderDNA::~UtsusemiNeunetEventDecoderDNA "UtsusemiNeunetEventDecoderDNA::~UtsusemiNeunetEventDecoderDNA()

Destructor. ";

%feature("docstring")  UtsusemiNeunetEventDecoderDNA::SetParametersFromFiles "Int4 UtsusemiNeunetEventDecoderDNA::SetParametersFromFiles(string wiring_file, string detector_file)

set parameters from files

---------------
Parameters:
---------------

wiring_file:  (string) Wiring Info xml file

detector_file:  (string) DetectorInfo xml file

---------------
Return values:
---------------

0:  no error

-1:  Troubles happened ";

%feature("docstring")  UtsusemiNeunetEventDecoderDNA::SetChopperParametersFromFiles "Int4 UtsusemiNeunetEventDecoderDNA::SetChopperParametersFromFiles(string chopper_file) ";

%feature("docstring")  UtsusemiNeunetEventDecoderDNA::PutHistBin "vector< Double > UtsusemiNeunetEventDecoderDNA::PutHistBin(UInt4 outerPixelId)

put binning calculated by Efix

For direct convertion from tof to phisical values, calculated binning(tof) is required to construct histograms.

outerPixelId (UInt4) pixel id

---------------
Return objects:
---------------

binning vector ";

%feature("docstring")  UtsusemiNeunetEventDecoderDNA::PutXaxis "vector< Double > UtsusemiNeunetEventDecoderDNA::PutXaxis()

put x axis values

When TofBinType is for direct conversion from event data to energy, this returns calculated x-axis values.

None

---------------
Return objects:
---------------

vector for values on calculated x-axis ";

%feature("docstring")  UtsusemiNeunetEventDecoderDNA::DecodeEventData "UInt4 UtsusemiNeunetEventDecoderDNA::DecodeEventData(UInt4 daqId, const UChar *data, UInt4 *pixel_id, double *tof, vector< Double > *Clock, UInt4 ThNum)

decode Event data

This decodes any one event data and return type of event. If a given event is neutron, this sets pixel_id and tof and return 1 (_isNeutronEvent) If T0 event, this event is stored and return 2 (_isT0Event) If clock event, return 3 If any other event, return 0

---------------
Parameters:
---------------

daqId:  (UInt4) daq ID

data:  (UChar) one event data

pixel_id:  (UInt4) Pixel ID calculated by given event

tof:  (double) TOF calculated by given event

Clock:  (vector<Double>)

ThNum:  (UInt4) Thread number

---------------
Return values:
---------------

_isNeutronEvent:  if neutron event

_isT0Event:  if T0 event

_isClockEvent:  if clock event

0:  if any other event ";

