#ifndef QECALCULATIONCHOPPER
#define QECALCULATIONCHOPPER

#include "Header.hh"
#include "OperatorBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "HeaderBase.hh"
#include "StringTools.hh"
#include "MlfPhysicalConstants.hh"

//////////////////////////////////
// QE calculation for DNA
// Advance soft 12/03/06
/////////////////////////////////

//! Function to calculate QE from Pixel position
/*!
 *
 *
 *
 *
 */
class AdvQECalculation :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    std::string commentHead;
    void Initialize();
    StringTools *stools;
public:
    AdvQECalculation();
        //!< Constructor
        /*!<
         */
    AdvQECalculation(ElementContainerMatrix *ecm);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    ~AdvQECalculation();
        //!< Destructor
        /*!<
         */
    //void CalcQE();
    ElementContainerArray CalcQE(double startQ, double endQ, double deltaQ);
    void CalcQE(ElementContainerArray* ECA, double startQ, double endQ, double deltaQ);

        //!< executes calclulation of QE
        /*!<
         *   @return None
         */
};

#endif
