#ifndef SCATABSOBODYMONITOR
#define SCATABSOBODYMONITOR

#include <vector>
#include <algorithm>

#include "Header.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"

//#include "AdvScatAbsoBodyManagerDNA.hh"
#include "AdvScatAbsoBodyManagerMLF.hh"
#include "UtsusemiHeader.hh"
/**
 */
//class AdvNeutronMonitorDNA : public AdvScatAbsoBodyManagerDNA {
class AdvNeutronMonitorDNA : public AdvScatAbsoBodyManagerMLF {
  private:
    std::string filename;
    std::string filepath;

    struct ScatAbsoInfo monitorInfo;
    struct ScatAbsoInfo wallInfo;
    Double LengthFromSource;
    std::vector <Double> time;
    std::vector <Double> energy;
    std::vector <Double> observedAtMonitor;
    std::vector <Double> observedAtMonitorErr; //
    std::vector <Double> intensityAtMonitor;
    std::vector <Double> intensityAtMonitorErr;
    std::vector <Double> intensityAtSample;
    std::vector <Double> intensityAtSampleErr;

    Double monitorEfficiency;
    Double wallEfficiency;
    Double sigmaNitroAbs;
    Double sigmaMonitorTotal;
    Double sigmaWallEffAbs;

    ElementContainer* monitorCount;
    ElementContainer* sampleIntensity;

  private:
    void vectorReverse(std::vector<Double>& v);
  public:
    AdvNeutronMonitorDNA(void);
    AdvNeutronMonitorDNA(std::string);
    ~AdvNeutronMonitorDNA(void);

    void TranslateFromTToE(void);
    ElementContainer& TranslateFromTToE(ElementContainer& ec);
    void SetLengthFromSource(Double);
    Double GetMonitorEfficiency(Double);
    Double GetWallEfficiency(Double);
    void SetIntensityAtSource(void);
    void SetIntensityAtSource(ElementContainer& monitorCount);
    void GetIntensityAtSample(void);
    void GetIntensityAtSample(ElementContainer& monitorCount, ElementContainerArray& eca);
    void GetIntensityAtSample(ElementContainer& monitorCount, ElementContainer& ec);
    void GetProfileUseMonAtSample(ElementContainer& monitorCount, ElementContainer& result);
    void outputResult(std::string& fileName);
    void toContainer(ElementContainerArray& eca);
    void toContainer(ElementContainer& ec);
    ElementContainer GetIntensityAtSample(ElementContainer monitorCount);
    ElementContainerArray getCorrection();
    bool Status(){return isReady();}
};

#endif


