#ifndef AdvILambdaCorrectionDNACHOPPER
#define AdvILambdaCorrectionDNACHOPPER

#include "Header.hh"
#include "OperatorBase.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"
#include "HeaderBase.hh"
#include "StringTools.hh"
#include "AdvNeutronMonitorDNA.hh"

//////////////////////////////////
// I Lambda Correction for DNA
// Advance soft 12/03/06
/////////////////////////////////

//!
/*!
 *
 *
 *
 *
 */
class AdvILambdaCorrectionDNA :
  public ManipulatorBase< ElementContainerMatrix >
{
private:
    std::string commentHead;
    void Initialize();
 StringTools *stools;
public:
    AdvILambdaCorrectionDNA();
        //!< Constructor
        /*!<
         */
    AdvILambdaCorrectionDNA(ElementContainerMatrix *ecm);
        //!< Constructor
        /*!<
         *  @param ecm ElementContainerMatrix for the target
         */
    ~AdvILambdaCorrectionDNA();
        //!< Destructor
        /*!<
         */

    ElementContainerMatrix ILCorrection(ElementContainerMatrix ecm, ElementContainer ec0, bool UseMonitorEfficiency, std::string filepath, bool isMonAtSmp=false);
    bool ILCorrection(ElementContainerMatrix* ret_ecm, ElementContainerMatrix* ecm, ElementContainer ec0, bool UseMonitorEfficiency, std::string filepath, bool isMonAtSmp=false);
    // ElementContainerMatrix ILCorrection(ElementContainerMatrix ecm, ElementContainer ec0, bool UseMonitorEfficiency, std::string filepath);
    //  ElementContainer ILCorrection(ElementContainerMatrix *ecm, ElementContainer *ec0);

        //!< executes I Lambda Correction
        /*!<
         *   @return None
         */
    ElementContainer DummyECCreate(ElementContainerMatrix *ecm);

        //!< executes I Lambda Correction
        /*!<
         *   @return None
         */


};

#endif
