#include "AdvSimulatedAnnealingConsts.hh"

const string AdvSimulatedAnnealingConsts::className=string("AdvSimulatedAnnealingConsts");

/**
 *  keys for contrioling AdvSimulatedAnnealingConsts
 */
/** key for the kind of the constrain */
const string AdvSimulatedAnnealingConsts::CONSTRAIN         =string("constrain");

/** key for the flag of using data weights */
const string AdvSimulatedAnnealingConsts::USE_DATA_WEIGHTS=string("use data weights");

/** key for output interval */
const string AdvSimulatedAnnealingConsts::OUTPUT_INTERVAL = string("output interval");

/** key for simulated annealing */
const string AdvSimulatedAnnealingConsts::N_TRIES       = string("n_tries");
const string AdvSimulatedAnnealingConsts::ITERS_FIXED_T = string("iters_fixed_t");
const string AdvSimulatedAnnealingConsts::STEP_SIZE     = string("step_size");
const string AdvSimulatedAnnealingConsts::K             = string("k");
const string AdvSimulatedAnnealingConsts::T_INITIAL     = string("t_initial");
const string AdvSimulatedAnnealingConsts::MU_T          = string("mu_t");
const string AdvSimulatedAnnealingConsts::T_MIN         = string("t_min");

/**
 *  key for input data for fitting using AdvSimulatedAnnealingConsts
 */
/** key for fitting function */
const string AdvSimulatedAnnealingConsts::FUNCTIONS= string("functions");

/** keys for a set of values of fitting parameters */
const string AdvSimulatedAnnealingConsts::INITIAL_PARAM_VALUES=string("initial param values");

const string AdvSimulatedAnnealingConsts::PARAMETER_VALUES    =string("parameter values");

/** key for a set of the refference data */
const string AdvSimulatedAnnealingConsts::REFERENCE_VALUES  =string("reference values");

/** keys for lower bound of box constrains */
const string AdvSimulatedAnnealingConsts::LOWER_BOUNDS      =string("lower bounds");
/** keys for upper bound of box constrains */
const string AdvSimulatedAnnealingConsts::UPPER_BOUNDS      =string("upper bounds");
/** key for weights of box constrains */
const string AdvSimulatedAnnealingConsts::BOX_WEIGHTS       =string("box weights");

/** key for current iterations */
const string AdvSimulatedAnnealingConsts::ITERATION_COUNT    =string("iteration count");
/** key for parameter errors */
const string AdvSimulatedAnnealingConsts::PARAM_ERRORS       =string("param errors");

/** the number times of function evaluations */
const string AdvSimulatedAnnealingConsts::FUNCTION_EVALUATIONS  = string("function evaluations");
/** iteration time */
const string AdvSimulatedAnnealingConsts::ITERATION_TIME= string("iteration time");

/*
 *  default values of parametes with keys
 */
/** default constrain */
const AdvSimulatedAnnealingConsts::Constrain  AdvSimulatedAnnealingConsts::DEFAULT_CONSTRAIN=AdvSimulatedAnnealingConsts::BOX;

/** default value of the flag to fit with weight */
const Bool               AdvSimulatedAnnealingConsts::DEFAULT_USE_DATA_WEIGHTS  =true;

/** default value for output interval */
const UInt4              AdvSimulatedAnnealingConsts::DEFAULT_OUTPUT_INTERVAL =1000U;

const Int4               AdvSimulatedAnnealingConsts::DEFAULT_N_TRIES       = 200;
const Int4               AdvSimulatedAnnealingConsts::DEFAULT_ITERS_FIXED_T = 1000;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_STEP_SIZE     = 1.0;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_K             = 1.0;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_T_INITIAL     = 0.008;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_MU_T          = 1.003;
const Double             AdvSimulatedAnnealingConsts::DEFAULT_T_MIN         = 2.0e-6;

/** constrain string */
const string AdvSimulatedAnnealingConsts::CONSTRAIN_STR[] = {
    "no constrain",                                  // NO_CONSTRAIN
    "box",                                           // BOX
};

/** termination reason */
//const string AdvSimulatedAnnealingConsts::TERMINATION_REASON[] = {
//    "",  // 0
//    "",  // 1
//    "",  // 2
//    "",  // 3
//    "",  // 4
//    "",  // 5
//    "",  // 6
//    "",  // 7
//    "continue",            // 8
//    "force-quit by user",  // 9
//    "suspend",             // 10
//};

