#!/usr/bin/python

from math import *
import numpy as np
import Manyo as m
import MethodFactory

####    linear combination of gaussian    ####
def dist(x, n, a, c, w):
    sum=0.0
    for i in range(n):
        sum = sum + a[i]*exp(-1.0*((x-c[i])/w[i])**2)
    return sum

####    sign function    ####
def sign(r):
    if r > 0.0:
        s = 1.0
    elif r == 0.0:
        s = 0.0
    else:
        s = -1.0
    return s

####    initialize an ElementContainer    ####
def initElementContainer(xmin, xmax, nDiv):

    bin = m.MakeDoubleVector(nDiv+1)
    delta = (xmax - xmin)/nDiv
    for i in range(nDiv+1):
        bin[i] = xmin + delta*i

    xc = m.MakeDoubleVector(nDiv)
    for i in range(nDiv):
        xc[i] = (bin[i] + bin[i+1])/2.0

    nPeak=1
    a=m.MakeDoubleVector(nPeak)
    c=m.MakeDoubleVector(nPeak)
    w=m.MakeDoubleVector(nPeak)
    a[0]=100000.0
    c[0]=7.5
    w[0]=2.5
    y = m.MakeDoubleVector(nDiv)
    e = m.MakeDoubleVector(nDiv)
    for i in range(nDiv):
        p = dist(xc[i], nPeak, a, c, w)
        q = sign(np.random.rand(1)-0.5)*(p/10.0)*sqrt(-1.0*log(np.random.rand(1)))
        y[i] = p + q
        e[i] = p/10.0

    ec = m.ElementContainer()
    ec.AddToHeader("run number", 1)
    ec.AddToHeader("level",      1)
    ec.AddToHeader("Inst.",      "manyo")
    ec.Add("TOF",       bin, "sec." )
    ec.Add("Intensity", y,   "count")
    ec.Add("Error",     e,   "count")
    ec.SetKeys("TOF", "Intensity", "Error")

    return ec

def outputElementContainer(ec):
    bin = ec.Put(ec.PutXKey())
    y   = ec.Put(ec.PutYKey())
    e   = ec.Put(ec.PutEKey())

    print str("No.").rjust(4), str("----------- bin -----------").rjust(27), str("xc").rjust(10), str("Intensity").rjust(23), str("error").rjust(23)
    for i in range(ec.PutSize(ec.PutYKey())):
         print str(i).rjust(4), "[", str(bin[i]).rjust(10), ",", str(bin[i+1]).rjust(10), ")", str((bin[i]+bin[i+1])/2.0).rjust(10), str(y[i]).rjust(23), str(e[i]).rjust(23)

def outputMethodType(methodType):
    print "value=", methodType.value, ", name=", methodType.name, ", symbol=", methodType.symbol

####    main routine    ####

outputMethodType(MethodFactory.BSPLINE)
outputMethodType(MethodFactory.MOVING_AVERAGE)
outputMethodType(MethodFactory.LEVMAR)
outputMethodType(MethodFactory.NEW_LEVMAR)

xmin = 0.0
xmax = 15.0
nDiv = 1500
src = initElementContainer(xmin, xmax, nDiv)
outputElementContainer(src)
src1 = initElementContainer(xmin, xmax, nDiv)
outputElementContainer(src1)
src1.Dump()

domain = MethodFactory.Domain()
domain.setSource(src)
domain.setRange(xmin, xmax)
print "[", str(domain.getLowerBound()).rjust(10), ",", str(domain.getUpperBound()).rjust(10), "]"
print "[", str(domain.getLowerBoundID()).rjust(10), ",", str(domain.getUpperBoundID()).rjust(10), "]"
print
print "type of the domain", domain.getType()
#domain.setType(Domain.OO)
#print "type of the domain", domain.getType()

print "issubclass(MethodFactory.BSpline, MethodFactory.Method )", issubclass(MethodFactory.BSpline, MethodFactory.Method )
print "issubclass(MethodFactory.Method,  MethodFactory.BSpline)", issubclass(MethodFactory.Method,  MethodFactory.BSpline)

param = MethodFactory.ParamSet()
param.add(MethodFactory.BSpline.ORDER,                    3 )
param.add(MethodFactory.BSpline.AUTOMATIC_KNOTS,          0 )
param.add(MethodFactory.BSpline.USE_UNIFORM_BREAK_POINTS, 1 )
param.add(MethodFactory.BSpline.NUMBER_OF_BREAK_POINTS,   10)
param.dump()

method = MethodFactory.MethodFactory.getInstance().createMethod(MethodFactory.BSPLINE)
print method.getMethodName()
print method.differentiable()
#method = specialMethod

param = method.setDefaultParam(src)
method.setDefaultParam(src).dump()
print "check param: ", method.checkParam(src, domain, param)

if method.checkParam(src, domain, param) :
    method.toInnerForm(src, domain, param)
    method.fit()
    method.eval()
    result = m.ElementContainer(src.PutHeader())
    method.toElementContainer(src, result)
    result.dump()
    outputElementContainer(result)

