#include "AdvMethodFactory.hh"

const string className = string("AdvMethodFactroy");

/* initial value is  NULL */
AdvMethodFactory *AdvMethodFactory::instance=static_cast<AdvMethodFactory*>(NULL);

/**
 *  default constructor
 */
AdvMethodFactory::AdvMethodFactory() {
}


/**
 *  return the singleton instance of the AdvMethodFactory class
 */
AdvMethodFactory * AdvMethodFactory::getInstance() {
    if (AdvMethodFactory::instance == static_cast<AdvMethodFactory*>(NULL) ) {
        AdvMethodFactory::instance = new AdvMethodFactory();
    }
    return AdvMethodFactory::instance;
}

/**
 *  create specified method
 */
AdvMethod *AdvMethodFactory::createMethod(const AdvMethodType &type) {

    AdvMethod *method;

    switch (type.value) {
        case BSPLINE_ID:
            method = new AdvBSpline();
            break;
        case MOVING_AVERAGE_ID:
            method = new AdvMovingAverage();
            break;
//        case LEVMAR_ID:
//            method = new Levmar();
//            break;
        case NEW_LEVMAR_ID:
            method = new AdvNewLevmar();
            break;
//        case MULTIDATA_LEVMAR_ID:
//            method = new MultiDataLevmar();
//            break;
        default:
            method = static_cast<AdvMethod*>(NULL);
            break;
    }
    return method;
}

/**
 *  create specified method
 */
AdvMethod *AdvMethodFactory::createMethod(string methodName) {
    AdvMethod *method;

    if (methodName == BSPLINE.name ) {
        method = new AdvBSpline();
    } else if (methodName == MOVING_AVERAGE.name ) {
        method = new AdvMovingAverage();
//    } else if (methodName == LEVMAR.name ) {
//        method = new Levmar();
    } else if (methodName == NEW_LEVMAR.name ) {
        method = new AdvNewLevmar();
//    } else if (methodName == MULTIDATA_LEVMAR.name ) {
//        method = new MultiDataLevmar();
    } else {
        method=static_cast<AdvMethod*>(NULL);
    }
    return method;
}
