#ifndef LEVMAR_CONSTS
#define LEVMAR_CONSTS

#include <cmath>
#include <cstdlib>
#include <pthread.h>

#include <exception>

/* headrs for levmar */
#include "compiler.h"
#include "levmar.h"
#include "lm.h"
#include "misc.h"

#include "Header.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"

#include "AdvMessage.hh"
#include "AdvMethod.hh"
#include "AdvFuncBase.hh"

class AdvLevmarConsts {

    private:
        static const string className; // =string("AdvLevmarConsts");

    public:
        /** key for the kind of the constrain */
        static const string CONSTRAIN;          //=string("constrain");
        /** key for the flag of using the numerical differential Jaccobian */
        static const string USE_NUMERICAL_DIFF; //=string("use numerical diff");
        /** key for the method of numerical differentiation */
        static const string DIFF_METHOD;        //=string("diff method");
        /** ley for the flag of using data weight */
        static const string USE_DATA_WEIGHTS;  //=string("use data weights");

        /** key for maxmum iterations */
        static const string MAX_ITERATIONS;    //=string("max iteration");
        /** key for output interval */
        static const string OUTPUT_INTERVAL;    //=string("output interval");

        /** histroy depth */
        static const string HISTORY_CAPACITY; //=string("history capacity");


        /** key for fitting function */
        static const string FUNCTIONS;         //= string("function");

        /** keys for a set of initial values of fitting parameters */

        /** key for data mask */
        static const string MASK;

        /** key for initival values for fitting parameters */
        static const string INITIAL_PARAM_VALUES; //=string("initial param values");
        static const string PARAMETER_VALUES;   //=string("parameter values");
        static const string LINK_IDS;   //=string("link ids");

        /** key for a set of the refference data,
         * @ deprecated
         */
        static const string REFERENCE_VALUES;  //=string("reference values");

        /** keys for lower bound of box constrains */
        static const string LOWER_BOUNDS;     //=string("lower bound");
        /** keys for upper bound of box constrains */
        static const string UPPER_BOUNDS;     //=string("upper bound");
        /** key for weights of box constrains */
        static const string BOX_WEIGHTS;      //=string("box weight");
        /** key for linear equations */
        static const string EQUATIONS;        //=string("equations");
        /** key for linear inequalities */
        static const string INEQUALITIES;     //=string("inequalites");

        /** key for scaling factor */
        static const string SCALING_FACTOR;     //=string("scaling factor");
        /** key for threshold values for stopping conditions */
        /** \deprecated */
        static const string TOLERANCE;          //=string("tolerance");
        /** \deprecated */
        static const string RELATIVE_TOLERANCE; //=string("relatice tolerance");
        /** \deprecated */
        static const string GRADIENT_TOLERANCE; //=string("gradient tolerance");

        static const string RESIDU_ERR_THRESH;  //=string("residu. err. threshold")
        static const string GRADIENT_THRESH;    //=string("gradient threshold")
        static const string PARAM_DIFF_THRESH;  //=string("param. diff. threshold")

        /** key for step width for numerical differential Jaccobian */
        static const string DIFF_DELTA;         //=string("delta");

        /** iteration count */
        static const string ITERATION_COUNT;    //=string("iteration count");
        /** termination stat */
        static const string TERMINATION_STAT;   //=string("termination stat")
        /** key for R-factor */
        static const string R_FACTOR;           //=string("R factor");
        /** norm of residual error (L2) */
        static const string RESIDUAL_ERR_NORM;  //=string("residual error norm");
        /** norm of residual error (infinity) */
        static const string GRADIENT_NORM;      //=string("gradiend norm");
        /** norm of parameter difference (L2) */
        static const string PARAM_DIFF_NORM;    //=string("param. diff. norm");
        /** parameter errors */
        static const string PARAM_ERRORS;       //=string("param. errors");
        /** covariance matrix */
        static const string COVARIANCE_MATRIX;  //=string("param. errors");

        /** mu ratio i.e. mu/max{ [J^T J]_ii} */
        static const string MU_RATIO;              //=string("mu ratio");
        /** the number times of function evaluations */
        static const string FUNCTION_EVALUATIONS;  //=string("function evaluations")
        /** the number times of Jacobian evaluations */
        static const string JACOBIAN_EVALUATIONS;  //=string("Jacobian evaluations")
        /** the number times of linear systems solved */
        static const string LINEAR_SYSTEMS_SOLVED; //=string("linear systems solved")
        /** the time of iteration */
        static const string ITERATION_TIME;        //=string("iteration time")

        /** constrain for Levmar */
        enum Constrain {
            NO_CONSTRAIN, /* no constrain */
            BOX,          /* box */
#ifdef HAVE_LAPACK
            LEC,          /* linear equations */
            LIC,          /* linear inequalities */
            BLEC,         /* box and linear equations */
            BLIC,         /* box and linear inequalities */
            LEIC,         /* linear equations and linear inequalities */
            BLEIC,        /* box, linear equations and linear inequalities */
#endif // HAVE_LAPACK
        };
        /** constrain */
        static const string CONSTRAIN_STR[];

        /** differential method */
        enum DiffMethod {
            FORWARD,
            CENTRAL,
        };
        static const string DIFF_METHOD_STR[];

        static const Constrain  DEFAULT_CONSTRAIN;          //=Levmar::BOX;
        static const Bool       DEFAULT_USE_NUMERICAL_DIFF; //=false;
        static const DiffMethod DEFAULT_DIFF_METHOD;    //Levmar::FORWARD
        static const Bool       DEFAULT_USE_DATA_WEIGHTS;   //=true;

        static const UInt4      DEFAULT_MAX_ITERATIONS;    //=1000U;
        static const UInt4      DEFAULT_OUTPUT_INTERVAL;    // =10U;

        static const UInt4      DEFAULT_HISTORY_CAPACITY;   //=50;

        static const Double     DEFAULT_SCALING_FACTOR;     // =LM_INIT_MU;

        /** \deprecated */
        static const Double     DEFAULT_GRADIENT_TOLERANCE; // =LM_STOP_THRESH;
        /** \deprecated */
        static const Double     DEFAULT_TOLERANCE;          // =LM_STOP_THRESH
        /** \deprecated */
        static const Double     DEFAULT_RELATIVE_TOLERANCE; // =LM_STOP_THRESH

        static const Double     DEFAULT_RESIDU_ERR_THRESH;  //=LM_STOP_THRESH
        static const Double     DEFAULT_GRADIENT_THRESH;    //=LM_STOP_THRESH
        static const Double     DEFAULT_PARAM_DIFF_THRESH;  //=LM_STOP_THRESH

        static const Double     DEFAULT_DIFF_DELTA;     // =LM_DIFF_DELTA

        /** stopping stat of Levmar
         *
         *  the values that Levmar ver. 2.5 returns are 1 -- 7. 
         */
        enum LevmarStat {
            /* termination symbol ane their value that Levmar returns */
            SMALL_GRADIENT            = 1,
            SMALL_DP                  = 2,
            REACH_MAX_ITERATION       = 3,
            SINGULAR_MATRIX           = 4,
            NO_FURTHER_ERROR_REDUCTION= 5,
            SMALL_RESIDUAL_ERROR      = 6,
            INVALID_FUNC              = 7,
            /* additional symbol and their value for wrapper class*/
            CONTINUE                  = 8,
            FORCE_QUIT_BY_USER        = 9,
            SUSPEND                   =10,
        };
        /** termination reason, translate a LevmarStat value to a string */
        static const string TERMINATION_REASON[];
};

#endif // METHODTEST
