#include <typeinfo>
#include <string>
#include "Message.hh"
#include "MessageTestClass.hh"


const string MessageTestClass::className=string("MessageTestClass");

MessageTestClass::MessageTestClass() {
};

MessageTestClass::~MessageTestClass() {
};

void MessageTestClass::method1() {
    Int2 error_Int2=0;
    Int4 error_Int4=0;
    Int8 error_Int8=0;
    UInt2 error_UInt2=0;
    UInt4 error_UInt4=0;
    UInt8 error_UInt8=0;
    Double value=0.0;

    string memberName="method1";

    std::cerr << "Debug: typeid().name() =" << string(typeid(this).name()) << endl;
    std::cerr << "Debug: class name =" << string(typeid(this).name()+2) << endl;
    std::cerr << "Debug: error_Int2 =" << string(typeid(error_Int2).name()) << endl;
    std::cerr << "Debug: error_Int4 =" << string(typeid(error_Int4).name()) << endl;
    std::cerr << "Debug: error_Int8 =" << string(typeid(error_Int8).name()) << endl;
    std::cerr << "Debug: error_UInt2=" << string(typeid(error_UInt2).name()) << endl;
    std::cerr << "Debug: error_UInt4=" << string(typeid(error_UInt4).name()) << endl;
    std::cerr << "Debug: error_UInt8=" << string(typeid(error_UInt8).name()) << endl;
    std::cerr << "Debug: value      =" << string(typeid(value).name()) << endl;

    errorMessage(className, memberName, __FILE__, __LINE__, string("test error message: %d\n").c_str(), error_Int2);
    errorMessage(className, memberName, __FILE__, __LINE__, string("test error message"));
    errorMessage(string(typeid(this).name()+2), memberName, __FILE__, __LINE__, string("test error message: %d\n").c_str(), error_Int2);
    errorMessage(string(typeid(this).name()+2), memberName, __FILE__, __LINE__, string("test error message"));

    warningMessage(className, memberName, __FILE__, __LINE__, string("test warning message: %u\n").c_str(), error_UInt2);
    warningMessage(className, memberName, __FILE__, __LINE__, string("test warning message"));

    infoMessage(className, memberName, string("test info message: %f\n").c_str(), value);
    infoMessage(className, memberName, string("test info message"));

    debugMessage(className, memberName, __FILE__, __LINE__, string("test debug message: %d %u %f\n").c_str(), error_Int8, error_UInt4, value);
    debugMessage(className, memberName, __FILE__, __LINE__, string("test debug message"));

    DebugMessage(className, memberName, __FILE__, __LINE__, string("test debug macro: %d %u %f\n").c_str(), error_Int8, error_UInt4, value);
    DebugMessage(className, memberName, __FILE__, __LINE__, string("test debug macro"));
};

