#ifndef VECTOR_ARRAY_CONV
#define VECTOR_ARRAY_CONV

#include "Header.hh"

class AdvVectorArrayConv {

    public:
        /** transform Double array to vector<double> */
        vector<Double> *arrayToVector(const Double *array, const UInt4 n);

        /** transform Double array (1d) to vector< vector<Double> ) */
        vector< vector<Double> > *arrayToMatrix(const Double *attay, const UInt4 rN, const UInt4 cN);

        /** transform vector<Double> to Double array */
        Double *vectorToArray(const vector<Double> &);

        /** transform vector< vector<Double> > to Double array (1d) */
        Double *MatrixTo1DArray(const vector< vector<Double> > &m);

};
#endif // VECTOR_ARRAY_CONV
