#include "PeakData.hh"

Int4 main(Int4 argc, Char *argv[]) {

    //                    type           x         h     w     xl   xu
    Peak *peak0 = new Peak(SHOLDER_I, -2.5,  50000.0,  4.5, -7.0, -2.5);
    Peak *peak1 = new Peak(PEAK,       0.0, 100000.0,  2.5, -2.5,  2.5);
    Peak *peak2 = new Peak(SHOLDER_D,  2.5,  50000.0,  4.5,  2.5,  7.0);
    Peak::title(stdout);
    peak0->dump(stdout);
    peak1->dump(stdout);
    peak2->dump(stdout);

    PeakData pc;
    pc.add(*peak0);
    pc.add(*peak1);
    pc.add(*peak2);
    pc.Dump();

    Peak peak=pc.getPeak(0);
    peak.dump(stdout);

    std::cout << "short size = " << Peak::shortSize << endl;
    std::cout << "full size  = " << Peak::fullSize << endl;
    std::cout << "number of peaks = " << pc.size() << endl;

    vector<Double> v;
    v=pc.toVector();
    std::cout << "size of vector = " << v.size() << endl;
    for (UInt4 i=0; i<v.size(); ++i) {
        std::cout << "v(" << i << ")=" << v.at(i) << endl;
    }

    v=pc.toFullVector();
    std::cout << "size of full vector = " << v.size() << endl;
    for (UInt4 i=0; i<v.size(); ++i) {
        std::cout << "v(" << i << ")=" << v.at(i) << endl;
    }

    Double *array;
    std::cout << "size of array = " << pc.sizeOfArray() << endl;
    array=pc.toArray();
    for (UInt4 i=0; i<pc.sizeOfArray(); ++i) {
        std::cout << "array(" << i << ")=" << array[i] << endl;
    }

    std::cout << "size of full array = " << pc.sizeOfFullArray() << endl;
    array=pc.toFullArray();
    for (UInt4 i=0; i<pc.sizeOfFullArray(); ++i) {
        std::cout << "array(" << i << ")=" << array[i] << endl;
    }

    gsl_vector *gsl_v;
    gsl_v=pc.toGslVector();
    std::cout << "size of gsl_vector = " << gsl_v->size << endl;
    for (UInt4 i=0; i<gsl_v->size; ++i) {
        std::cout << "gsl_vector(" << i << ")=" << gsl_vector_get(gsl_v, i) << endl;
    }

    gsl_v=pc.toFullGslVector();
    std::cout << "size of full gsl_vector = " << gsl_v->size << endl;
    for (UInt4 i=0; i<gsl_v->size; ++i) {
        std::cout << "gsl_vector(" << i << ")=" << gsl_vector_get(gsl_v, i) << endl;
    }
}
