#!/usr/bin/python

import Manyo
import ParamSet

v = Manyo.MakeDoubleVector()
v.push_back(1.0)
v.push_back(2.0)
v.push_back(3.0)

v1 = Manyo.MakeDoubleVector()
v1.push_back(1.0)
v1.push_back(2.0)
v1.push_back(3.0)
v1.push_back(4.0)
v1.push_back(5.0)
v1.push_back(6.0)

pc = ParamSet.PeakData()
pc.add(ParamSet.PEAK, -3.5, 100000.0, 3.5, -7.0, 0.0)
pc.add(ParamSet.PEAK,  3.5, 100000.0, 3.5,  0.0, 7.0)
print "number of peaks", pc.size()
pc.Dump()

param = ParamSet.ParamSet()

#    boolean value
param.add("uniform knots", 1)
#param.add("uniform knots", 1)  # error will occurs
param.add("unformatted",   0)

#    Int4 type value
param.add("window width", 1)
param.add("upper bound",  1)
param.add("order",        4)
#param.add("order",        4)   # error will occurs

#    UInt4 type value
#param.add("order", 4)
#param.add("order", 4)    # error will occuers

#    Double type value
param.add("pi", 3.1415926)
#param.add("pi", 3.1415926)    # error will occurs
param.add("base of natural logalithm", 2.7189)

#    vector
param.add("v0", v)
#param.add("v0", v)    # error will occurs

#    PeakData
param.add("peak data", pc)

param.dump()


print "uniforn knots:", param.getUInt4("uniform knots")
print "unformatted  :", param.getUInt4("unformatted")
print "window width :", param.getUInt4("window width")
#print "window upper :", param.getUInt4("window upper")    # error will occurs
print "upper bound  :", param.getUInt4("upper bound")
print "order        :", param.getUInt4("order")

print "pi                       :", param.getDouble("pi")
print "base of natural logalithm:", param.getDouble("base of natural logalithm")
print "gamma                    :", param.getDouble("gamma")

v0 = param.getVector("v0")
for i in range(v0.size()):
    print "v0[", i, "]=", v0[i]
print ""

####    replace    ####
param.replace("uniform knots",  0)
#param.replace("formatted",      1)
param.replace("unformatted",    1)
param.replace("window width",  11)
param.replace("order",         10)

param.replace("pi",           3.0)

param.replace("v0", 2, 4.0)
param.dump()

param.replace("v0", v1)
param.dump()

keyList=param.getKeyList()
print keyList
for i in range(keyList.size()):
    print "key=", keyList[i]
