#include "ContainerForVector.hh"

Int4 main(Int4 argc, Char *argv[] ) {

    UInt4 indentDepth=4;
    string keyTitle  ="key";
    string sizeTitle ="size";
    string valueTitle="value";

    ContainerForVector< Int4 > int4VectorMap;

    std::cout << "empty() = " << int4VectorMap.empty() << endl;

    string key1 = "key1";
    string key2 = "key2";
    string key3 = "key3";
    vector<Int4> value1 = vector< Int4 >(10, 1);
    vector<Int4> value2 = vector< Int4 >(20, 2);

    int4VectorMap.add(key1, value1);
    int4VectorMap.add(key2, value2);

    std::cout << "map.empty() = " << int4VectorMap.empty() << endl;
    std::cout << "map.size() = " << int4VectorMap.size() << endl;

    int4VectorMap.dump(0, indentDepth, keyTitle, sizeTitle, valueTitle);
    std::cout << "getVectorSize(key1) = " << int4VectorMap.getVectorSize(key1) << endl;
    std::cout << "getVectorSize(key2) = " << int4VectorMap.getVectorSize(key2) << endl;
    std::cout << "getVectorSize(key3) = " << int4VectorMap.getVectorSize(key3) << endl;

    std::cout << "get(key1,  0) = " << int4VectorMap.get(key1,  0) << endl;
    try {
        std::cout << "get(key3,  0) = " << int4VectorMap.get(key3,  0) << endl;
    } catch (invalid_argument& e) {
        std::cerr << e.what() << endl;
    }

    try {
        std::cout << "get(key1, 10) = " << int4VectorMap.get(key1, 10) << endl;
    } catch (out_of_range& e) {
        std::cerr << e.what() << endl;
    }
}
