#ifndef FUNCTION_TEST_BASE
#define FUNCTION_TEST_BASE

#include <iostream>
#include <ostream>
#include <fstream>
#include <ios>
#include <streambuf>
#include <iomanip>

#include "Header.hh"
#include "FuncBase.hh"


/**
 *  a class for testing a build-in function
 */
class FunctionTestBase {

    private:
        FuncBase *func;
        vector<Double> *param;

        // output file
        ofstream  *ofs;
        streambuf *buf;

        // output format
        Int4 precision;  // 1--15
        Int4 width;      // = precision + digit(1)+"." + "-" + "E|e" + exponent(4)

    private:
        void initIO();

    protected:

    public:
        /** constructor */
        FunctionTestBase();
        /** constructor */
        FunctionTestBase(FuncBase *func, vector<Double> *param);
        /** destructor */
        virtual ~FunctionTestBase();

        /** set a built-in function */
        void setFunc(FuncBase *func);
        /** set parameters for the built-in function */
        void setParam(vector<Double> *param);
        /** set default IO parameters */
        void setDefaultIO();
        /** set the output file */
        void setOutputFile(string fileName);
        /** set the precision of a double type variable */
        void setFormat(UInt4 precision);

        /** output column headers */
        void outputHeader();
        /** output the various values of the function at the given point */
        void outputValues(const Double x);
        /** output the various values of the function at the each point */
        void outputValues(const vector<Double> &xv);
};

#endif // TEST_FUNC
