#ifndef TRIANGLE_FUNC_H
#define TRIANGLE_FUNC_H

#include "Header.hh"
#include "AdvFuncBase.hh"

#define NumberOfParamForTriangle 4
#undef USE_POINTER

class AdvTriangle : public AdvFuncBase {

    public:
        /** default constructor */
        AdvTriangle();
        /** copy constructor */
        AdvTriangle(const AdvTriangle &);

        /** destructor */
        ~AdvTriangle();

        Double eval(  const Double x, const Double h, const Double t0, const Double t1, const Double t2);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const Double h, const Double t0, const Double t1, const Double t2);
        Double der2nd(const Double x, const Double h, const Double t0, const Double t1, const Double t2);
        Double derH(  const Double x, const Double h, const Double t0, const Double t1, const Double t2);
        Double derT0( const Double x, const Double h, const Double t0, const Double t1, const Double t2);
        Double derT1( const Double x, const Double h, const Double t0, const Double t1, const Double t2);
        Double derT2( const Double x, const Double h, const Double t0, const Double t1, const Double t2);
#endif // HAVE_DIFFERENTIAL_MEMBER

#ifdef USE_POINTER
        /** evaluate the value of the function */
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const Double *p);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const Double *p);
        /** evaluate the gradient of the function for parametes */
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER

#ifdef USE_VECTOR
        /** evaluate the value of the function */
        Double eval(const Double x, const vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        /** evaluate the value of the 1st. differential coefficient */
        Double der1st(const Double x, const vector<Double> &p);
        /** evaluate the value of the 2nd. differential coefficient */
        Double der2nd(const Double x, const vector<Double> &p);
        /** evaluate the gradient of the function for parametes */
        vector<Double> gradient(const Double x, const vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif // USE_POINTER
};

#endif // TRIANGLE_H
