#ifndef FUNC_PARSER_H
#define FUNC_PARSER_H

#include <string>
#include <cctype>
#include <vector>

#include "Header.hh"
#include "AdvMessage.hh"

//#include "AdvFuncData.hh"

#include "AdvFuncBase.hh"
#include "AdvConstant.hh"
#include "AdvConstantConv.hh"
#include "AdvPolynomial1.hh"
#include "AdvPolynomial1Conv.hh"
#include "AdvPolynomial2.hh"
#include "AdvPolynomial2Conv.hh"
#include "AdvPolynomial3.hh"
#include "AdvPolynomial3Conv.hh"
#include "AdvDeltaConv.hh"
#include "AdvExponential.hh"
#include "AdvErrorFunction.hh"
#include "AdvGaussian.hh"
#include "AdvGaussianConv.hh"
#include "AdvLorentzian.hh"
#include "AdvLorentzianConv.hh"
#include "AdvAugmentedLorentzian.hh"
#include "AdvAugmentedLorentzianConv.hh"
#include "AdvPseudoVoigt1.hh"
#include "AdvPseudoVoigt2.hh"
#include "AdvPseudoVoigt1Conv.hh"
#include "AdvPseudoVoigt2Conv.hh"
#include "AdvDampedHarmonicOscillator.hh"
#include "AdvDampedHarmonicOscillatorConv.hh"
#include "AdvTriangle.hh"
#include "AdvTrapezoid.hh"

class AdvFuncParser : public AdvMessage {

    private:
        static const string className; // = string("AdvFuncParser");

    private:
        /** expression parsed */
        string expr;

        /** index of expr */
        UInt4 i;

        enum tokenType { TOKEN_END, TOKEN_IDENTIFIER, TOKEN_OPERATOR,  };
        struct Token { tokenType type; string str; };

        vector<AdvFuncBase*> *buildInFuncList;

    public:
        ///** default constructor */
        //AdvFuncParser();
        /** constructor */
        AdvFuncParser(const string expr);
        /** destructor */
        virtual ~AdvFuncParser();

        //vector<string> *getBuildInFuncList();

        vector<AdvFuncBase*> parse();

    private:
        void createBuildInFuncList();
        Token getToken();
};

#endif
