#include "AdvFuncConv.hh"

AdvFuncConv::AdvFuncConv()
{
}

// create Resolution test data(xbin)
vector <Double> AdvFuncConv::ResolTestXbin(Double initial,Double final,Double delta) {
    vector<Double> resX;
    resX.clear();
    UInt4 num_of_bin;
    num_of_bin = UInt4((final-initial)/delta);
    for (int i=0;i<num_of_bin+2;i++)
        {
        resX.push_back(initial+delta*i);
        }
    return resX;
}

// create Resolution test data(ybin)
vector <Double> AdvFuncConv::ResolTestYbin(Double initial,Double final,Double delta,Double a) {
    vector<Double> resY;
    resY.clear();
    UInt4 num_of_bin;
    num_of_bin = UInt4((final-initial)/delta);
    for (int i=0;i<num_of_bin+1;i++)
        {
        if(initial+delta*i < 0)
            {
            resY.push_back(0);
            }
        else
            {
            resY.push_back(exp(-i*a));
            }
        }
    return resY;
}

void AdvFuncConv::SetResolutionEC(ElementContainer ec)
    {
    vector<Double> ecX=ec.PutX();
    vector<Double> ecY=ec.PutY();
    ResY.clear();
    ResX.clear();

    if (ec.PutHeaderPointer()->CheckKey("CONVOLRANGE")==1)
        {
        vector<Double> xrange = ec.PutHeader().PutDoubleVector("CONVOLRANGE");
        UInt4 j=0;
        for (UInt4 i=0;i<ecY.size();i++)
            {
            if (xrange[0]<=(ecX[i]+ecX[i+1])*0.5 && (ecX[i]+ecX[i+1])*0.5<=xrange[1])
                {
                ResX.push_back(ecX[i]);
                ResY.push_back(ecY[i]);
                j=i;
                }
            }
        ResX.push_back(ecX[j+1]);
        }
    else
        {
        UInt4 j=0;
        for (UInt4 i=0;i<ecY.size();i++)
            {
            ResX.push_back(ecX[i]);
            ResY.push_back(ecY[i]);
            j=i;
            }
        ResX.push_back(ecX[j+1]);
        }
    }

void AdvFuncConv::ReadResolutionFile()
    {
//        ifstream fi("/home/dnaadmin/convo_fit_test/res.dat");
        ifstream fi("/usr/local/mlf/DNA/tmp/res.dat");
        string buf;
        size_t found;
        ResY.clear();
        ResX.clear();
        while(fi && getline(fi, buf)) {
              size_t count =0;
              UInt4 numm=0;
              UInt4 flug=0;
              while((found = buf.find(" ", count)) != string::npos){
                  string StringBuf = string(buf, count, found - count);
                  if (StringBuf != ""){
                        double rt;
                        stringstream ss;
                        ss << StringBuf;
                        ss >> rt;
                        if (flug == 0) ResX.push_back(rt);
                        if (flug == 1) ResY.push_back(rt);                            
                        flug = flug + 1;
                     }
                  count = found+1;
                  numm = numm+1;
                 }
                    if(buf.size() != count)
                          {
                        double rt;
                        stringstream ss;
                        string StringBuf = string(buf, count, buf.size() - count);
                        ss << StringBuf;
                        ss >> rt;
                        if (flug == 1) ResY.push_back(rt);
                          }
             }

    }
