#ifndef THREADBASE
#define THREADBASE

#include "Header.hh"
#include <pthread.h>


//! Interface class for pthread
/*! This class is a interface class for pthread and
  a pure-virtual class.
  
  The procedure executed in the sub-thread created
  by this class should be defined in "void Run()" of the child class.
*/

class ThreadBase{

protected:
  pthread_t ThreadDescriptor;
  UInt4 CancelFlag;

public:
  ThreadBase();
  virtual ~ThreadBase();
  Int4 Start();
  /*!< This method starts the sub-thread.
    Parameters and settings for "Run()" should be given 
    before executing of this method.*/
  void Join();
  /*!< This method will wait for the finish of "Run()".*/
  void Cancel();
  /*!< This method will cancel the execution of the sub-thread.*/
  void Detach();

  virtual void Run()=0;
  /*!< Pure virtual method. 
    This method should be concreted in the derived class.
    The procedure in this method will be executed in the sub-thread
    created by this class.
  */
  pthread_t PutDescriptor(){ return ThreadDescriptor; }
  /*!< This method should be called after "Start()".*/
};


#endif 
