#ifndef VECTOR_COMPLEX_TOOL
#define VECTOR_COMPLEX_TOOL

#include "gsl/gsl_complex.h"
#include "gsl/gsl_complex_math.h"
#include "gsl/gsl_vector.h"
#include "gsl/gsl_vector_double.h"
#include "gsl/gls_vector_complex.h"
#include "gsl/gls_vector_complex_double.h"

#include "Header.hh"

class VectorComplexTool {

    public:
        enum Part {
            REAL; /** the symbol for real      part of std::complex */
            IMAG; /** the symbol for imagenary prat of std::complex */
        };

    public:
        /** constructor */
        VectorComplexConv() {};

        /** constructor */
        virtual ~VectorComplexConv() {};

        /** transport a vector as the real part to a std::complex std::vector.
         *  @retval the pointer to a gsl_vector_complex type std::vector
         */
        gsl_vector_complex* toGslVectorComplexReal(const Double*         real, const UInt4 n);
        gsl_vector_complex* toGslVectorComplexReal(const std::vector<Double>& real);
        gsl_vector_complex* toGslVectorComplexReal(const gsl_vector*     real);

        /** transport a vector as the imagenary part to a std::complex std::vector.
         *  @retval the pointer to a gsl_vector_complex type std::vector
         */
        gsl_vector_complex* toGslVectorComplexImag(const Double*         imag, const UInt4 n);
        gsl_vector_complex* toGslVectorComplexImag(const std::vector<Double>& imag);
        gsl_vector_complex* toGslVectorComplexImag(const gsl_vector*     imag);

        /** transport two std::vector to a std::complex std::vector.
         *  @retval the pointer to a gsl_vector_complex type std::vector
         */
        gsl_vector_complex* toGslVectorComplex(const Double*         real, const Double*         imag, const UInt4 n);
        gsl_vector_complex* toGslVectorComplex(const std::vector<Double>& real, const std::vector<Double>& imag);
        gsl_vector_complex* toGslVectorComplex(const gsl_vector*     real, const gsl_vector*     imag);

        /** type chage of a vector.
         *  @retval the pointer to a gsl_vector_complex type std::vector
         */
        gsl_vector_complex* toGslVectorComplex(std::vector< complex<Double> >& v);

        /** transport a vector as the real part to a std::complex std::vector.
         *  @retval the pointer to a vector< std::complex<Double> > type std::vector
         */
        std::vector< std::complex<Double> >* toVectorComplexReal(const Double*         real, const UInt4 real);
        std::vector< std::complex<Double> >* toVectorComplexReal(const std::vector<Double>& real);
        std::vector< std::complex<Double> >* toVectorComplexReal(const gsl_vector*     real);

        /** transport a vector as the imagenary part to a std::complex std::vector.
         *  @retval the pointer to a vector< std::complex<Double> > type std::vector
         */
        std::vector< std::complex<Double> >* toVectorComplexImag(const Double*         imag, const UInt4 real);
        std::vector< std::complex<Double> >* toVectorComplexImag(const std::vector<Double>& imag);
        std::vector< std::complex<Double> >* toVectorComplexImag(const gsl_vector*     imag);

        /** transport two std::vector to a std::complex std::vector.
         *  @retval the pointer to a vector< std::complex<Double> > type std::vector
         */
        std::vector< std::complex<Double> >* toVectorComplex(const Double*         real, const Double*         imag, const UInt4 n);
        std::vector< std::complex<Double> >* toVectorComplex(const std::vector<Double>& real, const std::vector<Double>& imag);
        std::vector< std::complex<Double> >* toVectorComplex(const gsl_vector*     real, const gsl_vector*     imag);

        /** type chage of a vector.
         *  @retval the pointer to a vector< std::complex<Double> > type std::vector
         */
        std::vector< complex<Double> >* toVectorComplex(const gsl_vector_complex* v);

}
#endif // VECTOR_GSL_VECTOR_COMPLEX_H
