#ifndef VECTOR_GSL_VECTOR_CONV_H
#define VECTOR_GSL_VECTOR_CONV_H

#include "Header.hh"
#include "gsl/gsl_vector.h"
#include "gsl/gsl_matrix.h"

class AdvVectorGSLVectorConv {

    public:
        /** convert a vector<Double> to a GSL std::vector */
        gsl_vector *vectorToGSLVector(const std::vector<Double> &v);

        /** convert a vector<Double> to a GSL std::vector */
        std::vector<Double> *gslVectorToVector(const gsl_vector *v);

        /** convert a vector< std::vector<Double> > to a GSL matrix */
        gsl_matrix *matrixToGSLMatrix(const std::vector< std::vector<Double> > &m);

        /** convert a GSL matrix to a vector< std::vector<Double> > */
        std::vector< std::vector<Double> > *gslMatrixToMatrix(const gsl_matrix *m);

};
#endif //  VECTOR_GSL_VECTOR_CONV_H
