#ifndef VECTOR_ARRAY_CONV
#define VECTOR_ARRAY_CONV

#include "Header.hh"

class AdvVectorArrayConv {

    public:
        /** transform Double array to std::vector<double> */
        std::vector<Double> *arrayToVector(const Double *array, const UInt4 n);

        /** transform Double array (1d) to std::vector< std::vector<Double> ) */
        std::vector< std::vector<Double> > *arrayToMatrix(const Double *attay, const UInt4 rN, const UInt4 cN);

        /** transform std::vector<Double> to Double array */
        Double *vectorToArray(const std::vector<Double> &);

        /** transform std::vector< std::vector<Double> > to Double array (1d) */
        Double *MatrixTo1DArray(const std::vector< std::vector<Double> > &m);

};
#endif // VECTOR_ARRAY_CONV
