#include "AdvVectorArrayConv.hh"

/**
 *  transform an array to std::vector<Double>
 *
 *  \param[in]  a  an Double type array
 *  \param[in]  n  the size of a
 *  \retval NULL, if a == NULL
 */
std::vector<Double> *AdvVectorArrayConv::arrayToVector(const Double *a, const UInt4 n) {
    std::vector<Double> *retval = NULL;
    if ( a != NULL ) {
        retval = new std::vector<Double>(n);
        for (UInt4 i=0; i<n; ++i) {
            retval->at(i) = a[i];
        }
    }
    return retval;
}

/**
 *  transform an array to an matrix (std::vector< std::vector<Double> >)
 *
 *  \param[in]  a   an Double type array
 *  \param[in]  rN  the number of the row
 *  \param[in]  cN  the number of the column
 *  \retval NULL, if a == NULL
 */
std::vector< std::vector<Double> > *AdvVectorArrayConv::arrayToMatrix(const Double *a, const UInt4 rN, const UInt4 cN) {

    std::vector< std::vector<Double> > *retval = NULL;
    if ( a != NULL ) {
        retval = new std::vector< std::vector<Double> >(rN);
        for (UInt4 i=0; i<rN; ++i) {
            retval->at(i)=*(new std::vector<Double>(cN));
        }
        for (UInt4 i=0; i<rN; ++i) {
            for (UInt4 j=0; j<cN; ++j) {
                retval->at(i).at(j) = a[i*cN+j];
            }
        }
    }
    return retval;
}

/**
 *  transform std::vector<Double> to (the pointer to) an array
 *
 *  \param[in]  v  an vecto<Double> std::vector
 */
Double *AdvVectorArrayConv::vectorToArray(const std::vector<Double> &v) {
    Double *retval = new Double[v.size()];
    for (UInt4 i=0; i<v.size(); ++i) {
        retval[i] = v[i];
    }
    return retval;
}

/**
 *  transform std::vector<Double> to (the pointer to) an array
 *
 *  \param[in]  v  an vecto<Double> std::vector
 */
Double *AdvVectorArrayConv::MatrixTo1DArray(const std::vector< std::vector<Double> > &v) {

    UInt4 nElements=0;
    for (UInt4 i=0; i<v.size(); ++i) {
        nElements += v.at(i).size();
    }
    Double *retval = new Double[nElements];
    UInt4 ct=0;
    for (UInt4 i=0; i<v.size(); ++i) {
        for (UInt4 j=0; j<v.at(i).size(); ++j) {
            retval[ct]=v.at(i).at(j);
            ++ct;
        }
    }
    return retval;;
}
