#include "AdvPeakFit.hh"
#include "AdvFuncComb.hh"

/**
 *  class name
 */
const std::string AdvPeakFit::className = std::string("AdvPeakFit");

AdvPeakFit::AdvPeakFit() {
};


AdvPeakFit::AdvPeakFit(ElementContainer *src) : AdvOperationBase(src) {
}

#ifndef SWIGPYTHON
AdvPeakFit::AdvPeakFit(ElementContainer *src, AdvMethod *method              ) : AdvOperationBase(src, method) {
}
#endif

AdvPeakFit::AdvPeakFit(ElementContainer *src, const AdvMethodType &methodType) : AdvOperationBase(src, methodType) {
}

AdvPeakFit::AdvPeakFit(ElementContainer *src, const std::string &methodName    ) : AdvOperationBase(src, methodName) {
}

#ifndef SWIGPYTHON
AdvPeakFit::AdvPeakFit(ElementContainer *src, AdvMethod           *method,     const Double xLower, const Double xUpper) : AdvOperationBase(src, method,     xLower, xUpper) {
}
#endif

AdvPeakFit::AdvPeakFit(ElementContainer *src, const AdvMethodType &methodType, const Double xLower, const Double xUpper) : AdvOperationBase(src, methodType, xLower, xUpper) {
}

AdvPeakFit::AdvPeakFit(ElementContainer *src, const std::string     &methodName, const Double xLower, const Double xUpper) : AdvOperationBase(src, methodName, xLower, xUpper) {
}

#ifndef SWIGPYTHON
AdvPeakFit::AdvPeakFit(ElementContainer *src, AdvMethod           *method,     const UInt4 lower, const UInt4 upper) : AdvOperationBase(src, method,     lower, upper) {
}
#endif

AdvPeakFit::AdvPeakFit(ElementContainer *src, const AdvMethodType &methodType, const UInt4 lower, const UInt4 upper) : AdvOperationBase(src, methodType, lower, upper) {
}

AdvPeakFit::AdvPeakFit(ElementContainer *src, const std::string     &methodName, const UInt4 lower, const UInt4 upper) : AdvOperationBase(src, methodName, lower, upper) {
}

AdvPeakFit::~AdvPeakFit() {
};

void AdvPeakFit::execute() {

    if ( ! this->method->checkParam(*(this->source), this->domain, this->param) ) {
        return;
    }

    this->method->toInnerForm(*(this->source), this->domain, this->param);
    this->method->fit();
    if ( this->method->isMultiThreaded() ) {
        while (this->method->isFitting()) {
            sleep(1);
        }
    }
    this->method->eval();

    //std::vector< std::vector<Double> > trend = this->method->getTrend();

}

Double AdvPeakFit::chiSq() {
    return 0.0;
}

AdvParamSet *AdvPeakFit::getLatestConvergenceStat() const {
    return this->method->isMultiThreaded() ? this->method->getLatestConvergenceStat() : NULL;
}

ElementContainer AdvPeakFit::getResult() {

    ElementContainer *ec=new ElementContainer(this->source->PutHeader());
    this->method->toElementContainer(*(this->source), *ec);

    return *ec;
}

//ElementContainerArray AdvPeakFit::getResultArray() {
//
//    ElementContainerArray *eca=new ElementContainerArray();
//    this->method->toElementContainerArray()
//}

ElementContainerArray AdvPeakFit::getResultComponents() {
    std::string memberName = std::string("getResultComponents()");

    DebugMessage(className, memberName, "enter\n");

    std::string xKey =this->source->PutXKey();
    std::string yKey =this->source->PutYKey();
    std::string eKey =this->source->PutEKey();
    std::string xUnit=this->source->PutUnit(xKey);
    std::string yUnit=this->source->PutUnit(yKey);
    std::string eUnit=this->source->PutUnit(yKey);
    HeaderBase header = this->source->PutHeader();
    std::string FUNC_KEY     =std::string("functions");
    std::string PARAM_KEY    =std::string("parameter values");
    std::string PARAM_ERR_KEY=std::string("param errors");

    AdvParamSet fittedParamSet = this->method->getFittedParam();
    //fittedParamSet.dump();

    ElementContainerArray *ecArray = new ElementContainerArray();
    if ( ! fittedParamSet.contain(FUNC_KEY) ) {
        errorMessage(className, memberName, "can't get functions\n");
    } else if ( ! fittedParamSet.contain(PARAM_KEY) ) {
        errorMessage(className, memberName, "can't get fitted parameters\n");
    } else if ( ! fittedParamSet.contain(PARAM_ERR_KEY) ) {
        errorMessage(className, memberName, "can't get parameter errors\n");
    } else {
        AdvFuncComb *func = new AdvFuncComb(fittedParamSet.getFuncList(FUNC_KEY), fittedParamSet.getVector(PARAM_KEY), fittedParamSet.getVector(PARAM_ERR_KEY));
        //func->dump();

        std::vector<Double> *resultBin=domain.getBin();
        std::vector<Double> *resultX  =domain.createXC();

        for (UInt4 i=0; i<func->getNumberOfComponents(); ++i) {
            DebugMessage(className, memberName, "%u-th. component\n", i);
            ElementContainer *ec = new ElementContainer(header);

            ec->Add(xKey, *resultBin,                            xUnit);
            ec->Add(yKey, func->evalComponent(     *resultX, i), yUnit);
            DebugMessage(className, memberName, "evaluate values\n", i);
            ec->Add(eKey, func->evalErrorComponent(*resultX, i), eUnit);
            DebugMessage(className, memberName, "evaluate errors\n", i);
            ec->SetKeys(xKey, yKey, eKey);

            ec->AddToHeader(std::string(FUNC_KEY),      func->getName(i));
            ec->AddToHeader(std::string(PARAM_KEY),     func->getSubsequenceOfParam(i));
            ec->AddToHeader(std::string(PARAM_ERR_KEY), func->getSubsequenceOfParamError(i));
            ecArray->Add(*ec);
        }
        delete func;
    }
    DebugMessage(className, memberName, "exit\n");
    return *ecArray;
}

