#ifndef LEVMAR_IMMUTABLES
#define LEVMAR_IMMUTABLES

//#ifdef SWIGPYTHON
//class AdvLevmarImmutables ;
//#else // SWIGPYTHON

/* headrs for levmar */
#include "compiler.h"
#include "levmar.h"
#include "lm.h"
#include "misc.h"

#include "Header.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "AdvMessage.hh"
#include "AdvFuncBase.hh"
#include "AdvDomain.hh"
#include "AdvParamSet.hh"

#include "AdvLevmarConsts.hh"
#include "AdvLevmarControl.hh"
#include "AdvAdditionalData.hh"
#include "AdvLevmarArgs.hh"

/**
 *  immutable parameters for Levmar during fitting
 */
class AdvLevmarImmutables : public AdvMessage {

    private:
        static const std::string className;

    public:
        /** control parameters for Levmar */
        AdvLevmarControl control;
        /** input parameters for Levmar */
        AdvLevmarArgs    args;

    public:
        /** constructor */
        AdvLevmarImmutables();
        /** constructor */
        AdvLevmarImmutables(ElementContainer &src, AdvDomain &domain, AdvParamSet &param);
        /** constructor */
        AdvLevmarImmutables(ElementContainerArray &src, std::vector<AdvDomain> &domainArray, AdvParamSet &param);
        /** destructor */
        ~AdvLevmarImmutables();

        /** set some parameters to their default values */
        //void setDefaultParam(ElementContainer &src);
        //void setDefaultParam(ElementContainerArray &src);
        /** check control and input data for Levmar */
        Bool checkParam(ElementContainer      &src, AdvDomain         &domain,      AdvParamSet &param);
        Bool checkParam(ElementContainerArray &src, std::vector<AdvDomain> &domainArray, AdvParamSet &param);
        /** translat parameters to inner form */
        void toInnerForm(ElementContainer      &src, AdvDomain         &domain,      AdvParamSet &param);
        void toInnerForm(ElementContainerArray &src, std::vector<AdvDomain> &domainArray, AdvParamSet &param);
        /** output parameter values to the standard out */
        void output();
};

//#endif // SWIGPYTHON

#endif // AdvLevmarImmutables
