#ifndef ADVINSMEM
#define ADVINSMEM

#include <cstdio>
#include <cstdlib>
#include <string>
#include <cstring>
#include <cmath>

/*
       decombolution of resolution function by Maximum Entropy Method
         for high-resolution inelastic x-ray scattering spectra
             measured at SPring8 BL35XU
                  Copy right     Yukinobu KAWAKITA (Kyushu Univ.)
                  2002.9.13

       transfer insmem2.for (Fortran)  to Insmem.c (C) by AdvanceSoft. 2010.05.12
       add to Manyo Library                            by AdvanceSoft. 2012.06.12
*/

//! 
/*! 
 * 
 * 
 *  
 * 
 */
class AdvInsMEM
{
private:
    int execute();
    int read_data_spectrum(int*, float*, float*, float*, char*);
    int set_column_num(int*, int*);
    int read_data_resolution(int*, float*, float*, char*);
    int graphics_treatment(int, int, float*, float*, float*, float*);
    int init_mem_proc(int, int, float*, float*, float*, float*, float*, float*);
    int init0_Lorentzian(int, float*, float*);
    int init0_ObservedData(int, float*, float*);
    int convol(int, float*, float*, int, float*, float*, float*);
    int main_mem_proc(int*, int, int, float*, float*, float*, float*, float*, float*, float*, float*, int, int);
    int memproc(int, float*, float*, float*, float*, int, float*, float*, float*);
    int trap(float x[], float y[], int n, float* s);
    int spline3(int, float*, float*, int, float*, float*);
    int Thomas(int, float*, float*, float*, float*, float*);

    float* alloc_float(int size);

    /** maximaum number of treated data */
    int max_data_size;
    /** maximum number of Lorentzian functions used for initialization in MEM */
    int max_num_lorentzian_functions;
    /** pi */
    float pi;
    /** length of buffer used for analysis of input sentence */
    int length_buffer;
    /** length of filename */
    int length_filename;
    /** normalization factor */
    float sect;
    /** normalization factor */
    float rfac;
    const char *MessageTag;

    int manual;
    char *fname;
    char *fnameRes;
    char *basepath;
    int cmlineData;
    int cmlineRes;
    int KcorEin;
    int KcorSin;
    int KcorRin;
    int LcorEIn; 
    int LcorNIn;

    int memDatain;
    int nlorin;
    float *omegaIn;
    float *ene0In;
    float *valIn;
    int maxcIn;
    float constraintIn;

public:
    AdvInsMEM();
        //!< Constructor
        /*!<
         */
    AdvInsMEM(char *DataFileName,char *ResFileName,int memData,int NumOfLor,int *LineDefParam,double *omegaInParam,double *ene0InParam,double valInParam[],int Itteration,double MemThreshold,char * savepath);
        //!< Constructor
        /*!<
         */
    ~AdvInsMEM();
        //!< Destructor
        /*!<
         */
int Begin(char *DataFileName,char *ResFileName, int memData,int NumOfLor, int cmlineData, int KcorEin,int KcorSin, int KcorRin,int cmlineRes,int LcorEIn, int LcorNIn, int Itteration,double MemThreshold,char *savepath);
int Manual();
        //!< Constructor
        /*!<
         */    


};

#endif
