#ifndef DECONVOLUTIONBYFFT
#define DECONVOLUTIONBYFFT

#include "AdvVectorComplexTool.hh"
#include "AdvConvolutionBase.hh"
#include "AdvGslFFTComplex.hh"

class AdvDeconvolutionByFFT : virtual public AdvConvolutionBase, virtual public AdvVectorComplexTool {
    private:
        static const std::string className;

    protected:
        void setDefaultConvolutionType(AdvParamSet& paramSet); 
        Bool checkConvolutionType(AdvParamSet& paramSet) ;

    private:
        void addZeroSeqAtBack(std::vector<Double>& val, std::vector<Double>& err, UInt4 n) ;
        void eraseZeroSeqAtBack(std::vector<Double>& val, std::vector<Double>& err, const UInt4 n);
        void eraseZeroSeqAtBack(std::vector<Double>& val, std::vector<Double>& err);

    public:
        /** constructor */
        AdvDeconvolutionByFFT() : AdvConvolutionBase(std::string("AdvDeconvolutionByFFT")) {};
        /** destructor */
        ~AdvDeconvolutionByFFT() {};

        void eval();

        /////////////////////////////////////////////////////////////////////////////
        Double likehood() { return 0.0; };
        void fit() {};
        std::vector< std::vector<Double> > getTrend() { return *(new std::vector< std::vector<Double> >()); };
        std::vector< std::vector<Double> > getTrend(UInt4) { return *(new std::vector< std::vector<Double> >()); };
        void getParamDescription() const {};
        AdvParamSet getFittedParam() const { return *(new AdvParamSet()); };
        AdvParamSet* getLatestConvergenceStat() const { return new AdvParamSet(); };
};

#endif // DECONVOLUTIONBYFFT
