#ifndef CONVOLUTION_CONSTS
#define CONVOLUTION_CONSTS

#include <vector>
#include <string>
#include <limits>

#include "Header.hh"

/** constant values for convolution-related classes.
 *
 * @author TANIMORI Souichirou, AdvanceSoft Corp.
 * @version 0.0
 * @since   0.0
 */
class AdvConvolutionConsts {
    public:
        /** key for convolution type */
        static const std::string CONVOLUTION_TYPE;
        /** available valurs for convolution type.
         *      CIRCULAR and PERIODIC are aliases of CYCLIC,
         */
        enum ConvolutionType {
            LINEAR,
            CYCLIC,
            //CIRCULAR,
            //PERIODIC,
        };
        /** std::strings expression for available values of convolution type */
        static const std::string ConvolutionTypeStr[];
        /** default values of convolution type */
        static const ConvolutionType DEFAULT_CONVOLUTION_TYPE;

        /** key for index of resolution, responce transfer function */
        static const std::string  RES_INDEX;
        /** default value for RES_INDEX */
        static const UInt4   DEFAULT_RES_INDEX;

        /** key for the relative thresold for chcking data spacing */
        static const std::string WIDTH_THRESHOLD;
        /** default value for WIDTH_THRESHOLD */
        static const Double DEFAULT_WIDTH_THRESHOLD;
};

#endif //  CONVOLUTION_CONSTS
