#ifndef CONVDECONv
#define CONVDECONv

#include "Header.hh"
#include "ElementContainer.hh"
#include "ElementContainerArray.hh"
#include "ElementContainerMatrix.hh"

#include "AdvMultiDataMethod.hh"
#include "AdvMultiDataOperationBase.hh"


class AdvConvDeconv : public AdvMultiDataOperationBase {
    private:
        static const std::string className; // = std::string("AdvConvDeconv");

    public:
        AdvConvDeconv();

        AdvConvDeconv(ElementContainerArray *src);
#ifndef SWIGPYTHON
        AdvConvDeconv(ElementContainerArray *src, AdvMultiDataMethod  *method);
#endif
        AdvConvDeconv(ElementContainerArray *src, const AdvMethodType &methodType);
        AdvConvDeconv(ElementContainerArray *src, const std::string     &methodName);

        /**
         *  constructor
         */
#ifndef SWIGPYTHON
        AdvConvDeconv(ElementContainerArray *src, AdvMultiDataMethod  *method,     const Double xLower, const Double xUpper);
#endif
        AdvConvDeconv(ElementContainerArray *src, const AdvMethodType &methodType, const Double xLower, const Double xUpper);
        AdvConvDeconv(ElementContainerArray *src, const std::string     &methodName, const Double xLower, const Double xUpper);

        /**
         *  constructor
         */
#ifndef SWIGPYTHON
        AdvConvDeconv(ElementContainerArray *src, AdvMultiDataMethod  *method,     const UInt4 lower, const UInt4 upper);
#endif
        AdvConvDeconv(ElementContainerArray *src, const AdvMethodType &methodType, const UInt4 lower, const UInt4 upper);
        AdvConvDeconv(ElementContainerArray *src, const std::string     &methodName, const UInt4 lower, const UInt4 upper);

        /**
         *  destructor
         */
        ~AdvConvDeconv();


        void execute();

        void fit() { this->execute(); };

        Bool isFitting() { return false; };

        void stopFit() {};

        ElementContainer      getResult(UInt4 i);
        ElementContainerArray getResult();

        /////////////////////  dummy //////////////////////
        Double chiSq() { return 0.0; };
        ElementContainerArray  getResultComponents(UInt4) { return *(new ElementContainerArray()); };
        ElementContainerMatrix getResultComponents() { return *(new ElementContainerMatrix()); };
        AdvParamSet*              getLatestConvergenceStat() const { return new AdvParamSet(); };

};

#endif // CONVDECONv
