#include "AdvConvDeconv.hh"

const std::string AdvConvDeconv::className = std::string("AdvConvDeconv");

AdvConvDeconv::AdvConvDeconv() {
};


AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src) : AdvMultiDataOperationBase(src) {
}

#ifndef SWIGPYTHON
AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src, AdvMultiDataMethod *method ) : AdvMultiDataOperationBase(src, method) {
}
#endif

AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src, const AdvMethodType &methodType) : AdvMultiDataOperationBase(src, methodType) {
}

AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src, const std::string &methodName    ) : AdvMultiDataOperationBase(src, methodName) {
}

#ifndef SWIGPYTHON
AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src, AdvMultiDataMethod *method,     const Double xLower, const Double xUpper) : AdvMultiDataOperationBase(src, method,     xLower, xUpper) {
}
#endif

AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src, const AdvMethodType &methodType, const Double xLower, const Double xUpper) : AdvMultiDataOperationBase(src, methodType, xLower, xUpper) {
}

AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src, const std::string     &methodName, const Double xLower, const Double xUpper) : AdvMultiDataOperationBase(src, methodName, xLower, xUpper) {
}

#ifndef SWIGPYTHON
AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src, AdvMultiDataMethod *method,     const UInt4 lower, const UInt4 upper) : AdvMultiDataOperationBase(src, method,     lower, upper) {
}
#endif

AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src, const AdvMethodType &methodType, const UInt4 lower, const UInt4 upper) : AdvMultiDataOperationBase(src, methodType, lower, upper) {
}

AdvConvDeconv::AdvConvDeconv(ElementContainerArray *src, const std::string     &methodName, const UInt4 lower, const UInt4 upper) : AdvMultiDataOperationBase(src, methodName, lower, upper) {
}

AdvConvDeconv::~AdvConvDeconv() {
};


void AdvConvDeconv::execute() {

    if ( ! this->method->checkParam(*(this->source), this->domains, this->param) ) {
        return;
    }

    this->method->toInnerForm(*(this->source), this->domains, this->param);
    this->method->fit();
    if ( this->method->isMultiThreaded() ) {
        while (this->method->isFitting()) {
            sleep(1);
        }
    }
    this->method->eval();

    //std::vector< std::vector<Double> > trend = this->method->getTrend();

}

ElementContainer AdvConvDeconv::getResult(UInt4 i) {
    ElementContainer *ec=new ElementContainer(this->source->PutHeader());
    this->method->toElementContainer(*(this->source), i, *ec);
    return *ec;
}

ElementContainerArray AdvConvDeconv::getResult() {

    ElementContainerArray *eca=new ElementContainerArray(this->source->PutHeader());
    this->method->toElementContainerArray(*(this->source), *eca);
    return *eca;
}

