#ifndef AUGMENTED_LORENTZIAN_H
#define AUGMENTED_LORENTZIAN_H

#include "Header.hh"

#include "AdvFuncBase.hh"

#define NumberOfParamsForAugmentedLorentzian 4

class AdvAugmentedLorentzian : public AdvFuncBase {

    private:
        Double denominator(const Double x, const Double c, const Double w, const Double p, const Double m);
        Double N(const Double p);
        
    public:
        /** default constructor */
        AdvAugmentedLorentzian();

        /** destructor */
        ~AdvAugmentedLorentzian();

        /** evaluate the value of the function
         *
         *  \param[in] x
         *  \param[in] h the hight  of the function
         *  \param[in] c the center of the function
         *  \param[in] w the width  of the function
         *  \param[im] p the power  of the function
         */
        Double   eval(const Double x, const Double h, const Double c, const Double w, const Double p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const Double h, const Double c, const Double w, const Double p); 
        Double der2nd(const Double x, const Double h, const Double c, const Double w, const Double p); 
        Double   derW(const Double x, const Double h, const Double c, const Double w, const Double p); 
        Double   derP(const Double x, const Double h, const Double c, const Double w, const Double p); 
#endif // HAVE_DIFFERENTIAL_MEMBER

#ifdef USE_POINTER
        Double eval(const Double x, const Double *p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const Double *p);
        Double der2nd(const Double x, const Double *p);
        Double *gradient(const Double x, const Double *p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif //USE_POINTER

#ifdef USE_VECTOR
        Double eval(const Double x, const std::vector<Double> &p);
#ifdef HAVE_DIFFERENTIAL_MEMBER
        Double der1st(const Double x, const std::vector<Double> &p);
        Double der2nd(const Double x, const std::vector<Double> &p);
        std::vector<Double> gradient(const Double x, const std::vector<Double> &p);
#endif // HAVE_DIFFERENTIAL_MEMBER
#endif //USE_VECTOR
};

#endif
