#ifndef MINIXMLREADER
#define MINIXMLREADER

#include "MiniXmlParser.hh"
#include "StringTools.hh"


//////////////////////////////////
// MiniXmlReader
/////////////////////////////////

//! Function for read XML file
/*! This gives a simple way to access to elements 
 *  by using path-to-element text.
 */

class MiniXmlReader
{
private:
    vector< MiniXmlParser* > vXmlParsers;
    vector< vector< string > > vNameXmlFiles;
    void _showMsg( string message );
    Int4 _searchIndex( string xmlNickname );
    mxml_node_t* _getNode( UInt4 targetId, mxml_node_t* curNode, string pathToContent);
    mxml_node_t* _getNodeFromAttr( UInt4 targetId, mxml_node_t* curNode, string path );
    void _trimSpaces( string* path );
    
public:
    MiniXmlReader();
        //!< Constructor
        /*!< 
	 *   @param None
	 *   @retval None
         */
    MiniXmlReader( string xmlFile, string xmlNickname );
        //!< Constructor
        /*!< 
	 *   @param xmlFile      path to XML file
	 *   @param xmlNickname  nickname to distinguish several loaded XML files.
	 *   @retval None
         */
    MiniXmlReader( vector< string > xmlFiles, vector< string > xmlNickname );
        //!< Constructor
        /*!< 
	 *   @param xmlFiles     vector of pathes to XML files
	 *   @param xmlNickname  vector of nicknames
	 *   @retval None
         */
    ~MiniXmlReader();
        //!< Destructor
        /*!<
         */

    Int4 readXmlFile( string xmlFile, string xmlNickname );
        //!< reads XML file
        /*!< 
	 *   @param xmlFile      path to XML file
	 *   @param xmlNickname  nickname to distinguish several loaded XML files
	 *   @retval -1   Errors happened.
	 *   @retval  0   No problem
         */
    bool hasPath( string xmlNickname, string pathToContent );
        //!< checks the existence of given path-to-element 
        /*!< 
	 *   @param xmlNickname   nickname to distinguish several loaded XML files
	 *   @param pathToContent path-to-element
	 *   @retval true   given path exists
	 *   @retval false  given path does not exist
         */
    string putTextContent( string xmlNickname, string pathToElement, string attrName="NULL");
        //!< puts element as text by given a path-to-element and a given attribute
        /*!< 
	 *   @param xmlNickname    nickname to distinguish several loaded XML files
	 *   @param pathToElement  path-to-element
	 *   @param attrName       attribute name
	 *   @return element or attribute value as text
         */

    void clearXmlFiles();
        //!< deletes XML information
        /*!< 
	 *   @param None
	 *   @retval None
         */
    
    UInt4 putNumOfFiles();
    UInt4 MaxLength;
};
#endif
