/*
$Id: VectorTool.cc 2292 2011-08-09 02:25:55Z jisuzuki $
*/


#include "VectorTool.hh"
//////////////////////////////////////////
std::vector<Double> VectorTool::
ArrayToVector( Double *p, UInt4 size )
{
  std::vector<Double> v; v.clear();
  for( UInt4 i=0; i<size; i++ ){
    v.push_back( *( p+i ) );
  }
  return v;
}
std::vector<Float>  VectorTool::
ArrayToVector( Float *p,  UInt4 size )
{
  std::vector<Float> v; v.clear();
  for( UInt4 i=0; i<size; i++ ){
    v.push_back( *( p+i ) );
  }
  return v;
}
std::vector<Int4>   VectorTool::
ArrayToVector( Int4 *p,   UInt4 size )
{
  std::vector<Int4> v; v.clear();
  for( UInt4 i=0; i<size; i++ )
    v.push_back( *( p+i ) );
  return v;
}
std::vector<UInt4>  VectorTool::
ArrayToVector( UInt4 *p,  UInt4 size )
{
  std::vector<UInt4> v; v.clear();
  for( UInt4 i=0; i<size; i++ )
    v.push_back( *( p+i ) );
  return v;
}
std::vector<Int2>   VectorTool::
ArrayToVector( Int2 *p,   UInt4 size )
{
  std::vector<Int2> v; v.clear();
  for( UInt4 i=0; i<size; i++ )
    v.push_back( *( p+i ) );
  return v;
}
std::vector<UInt2>  VectorTool::
ArrayToVector( UInt2 *p,  UInt4 size )
{
  std::vector<UInt2> v; v.clear();
  for( UInt4 i=0; i<size; i++ )
    v.push_back( *( p+i ) );
  return v;
}
std::vector<std::string> VectorTool::
ArrayToVector( std::string *p, UInt4 size )
{
  std::vector<std::string> v; v.clear();
  for( UInt4 i=0; i<size; i++ )
    v.push_back( *( p+i ) );
  return v;
}
std::vector<bool> VectorTool::
ArrayToVector( bool *p, UInt4 size )
{
  std::vector<bool> v; v.clear();
  for( UInt4 i=0; i<size; i++ )
    v.push_back( *( p+i ) );
  return v;
}
////////////////////////////////////////////////
std::vector<Double> VectorTool::
MakeVectorDouble( UInt4 size )
{
  std::vector<Double> v( size );
  for( UInt4 i=0; i<size; i++ )
    v[i] = (Double)i;
  return v;
}
////////////////////////////////////////////////
std::vector<Float>  VectorTool::
MakeVectorFloat( UInt4 size )
{
  std::vector<Float> v( size );
  for( UInt4 i=0; i<size; i++ )
    v[i] = (Float)i;
  return v;
}
////////////////////////////////////////////////
std::vector<Int4>   VectorTool::
MakeVectorInt4( Int4 size )
{
  std::vector<Int4> v( size );
  for( Int4 i=0; i<size; i++ )
    v[i] = (Int4)i;
  return v;
}
////////////////////////////////////////////////
std::vector<UInt4>  VectorTool::
MakeVectorUInt4( UInt4 size )
{
  std::vector<UInt4> v( size );
  for( UInt4 i=0; i<size; i++ )
    v[i] = (UInt4)i;
  return v;
}
////////////////////////////////////////////////
std::vector<Int2>   VectorTool::
MakeVectorInt2( Int2 size )
{
  std::vector<Int2> v( size );
  for( Int2 i=0; i<size; i++ )
    v[i] = 0;
  return v;
}
////////////////////////////////////////////////
std::vector<UInt2>  VectorTool::
MakeVectorUInt2(  UInt2 size )
{
  std::vector<UInt2> v( size );
  for( UInt2 i=0; i<size; i++ )
    v[i] = 0;
  return v;
}
////////////////////////////////////////////////
std::vector<std::string> VectorTool::
MakeVectorString(  UInt4 size )
{
  std::vector<std::string> v( size );
  for( UInt4 i=0; i<size; i++ )
    v[i] = "0";
  return v;
}
////////////////////////////////////////////////
std::vector<std::string> VectorTool::
ReadVectorString( std::string FileName )
{
  ReadTextFile *rt = new ReadTextFile();
  rt -> SetFileName( FileName );
  UInt4 n = rt -> PutSize();

  std::vector<std::string> v;
  for( UInt4 i=0; i<n; i++ ){
    v.push_back( rt->Put( i ) );
  }
  delete rt;
  return v;
}
////////////////////////////////////////////////
std::vector<bool> VectorTool::
MakeVectorBool(  UInt4 size )
{
  std::vector<bool> v( size );
  for( UInt4 i=0; i<size; i++ )
    v[i] = 0;
  return v;
}
////////////////////////////////////////////////
Double * VectorTool::
VectorToArray( std::vector<Double> v )
{
  UInt4 size = (UInt4)(v.size());
  Double *p = new Double [ size ];
  for( UInt4 i=0; i<size; i++ ) p[i] = v[i];
  return p;
}
Float  * VectorTool::
VectorToArray( std::vector<Float>  v )
{
  UInt4 size = (UInt4)(v.size());
  Float *p = new Float [ size ];
  for( UInt4 i=0; i<size; i++ ) p[i] = v[i];
  return p;
}
Int4   * VectorTool::
VectorToArray( std::vector<Int4>   v )
{
  UInt4 size = (UInt4)(v.size());
  Int4 *p = new Int4 [ size ];
  for( UInt4 i=0; i<size; i++ ) p[i] = v[i];
  return p;
}
UInt4  * VectorTool::
VectorToArray( std::vector<UInt4>  v )
{
  UInt4 size = (UInt4)(v.size());
  UInt4 *p = new UInt4 [ size ];
  for( UInt4 i=0; i<size; i++ ) p[i] = v[i];
  return p;
}
Int2   * VectorTool::
VectorToArray( std::vector<Int2>  v )
{
  UInt4 size = (UInt4)(v.size());
  Int2 *p = new Int2 [ size ];
  for( UInt4 i=0; i<size; i++ ) p[i] = v[i];
  return p;
}
UInt2  * VectorTool::
VectorToArray( std::vector<UInt2> v )
{
  UInt4 size = (UInt4)(v.size());
  UInt2 *p = new UInt2 [ size ];
  for( UInt4 i=0; i<size; i++ ) p[i] = v[i];
  return p;
}
std::string * VectorTool::
VectorToArray( std::vector<std::string> v )
{
  UInt4 size = (UInt4)(v.size());
  std::string *p = new std::string [ size ];
  for( UInt4 i=0; i<size; i++ ) p[i] = v[i];
  return p;
}
bool * VectorTool::
VectorToArray( std::vector<bool> v )
{
  UInt4 size = (UInt4)(v.size());
  bool *p = new bool [ size ];
  for( UInt4 i=0; i<size; i++ ) p[i] = v[i];
  return p;
}
//////////////////////////////////////////



////////////////////////////////////////////////
std::vector<Double>* VectorTool::
MakeVectorDoubleP( UInt4 size )
{
  std::vector<Double> *v = new std::vector<Double>( size );
  for( UInt4 i=0; i<size; i++ )
    ( *v )[i] = (Double)i;
  return v;
}
////////////////////////////////////////////////
std::vector<Float>*  VectorTool::
MakeVectorFloatP(  UInt4 size )
{
  std::vector<Float> *v = new std::vector<Float>( size );
  for( UInt4 i=0; i<size; i++ )
    ( *v )[i] = (Float)i;
  return v;
}
////////////////////////////////////////////////
std::vector<Int4>*   VectorTool::
MakeVectorInt4P(  Int4 size )
{
  std::vector<Int4> *v = new std::vector<Int4>( size );
  for( Int4 i=0; i<size; i++ )
    ( *v )[i] = (Int4)i;
  return v;
}
////////////////////////////////////////////////
std::vector<UInt4>*  VectorTool::
MakeVectorUInt4P(  UInt4 size )
{
  std::vector<UInt4> *v = new std::vector<UInt4>( size );
  for( UInt4 i=0; i<size; i++ )
    ( *v )[i] = (UInt4)i;
  return v;
}
////////////////////////////////////////////////
std::vector<Int2>*   VectorTool::
MakeVectorInt2P(  Int2 size )
{
  std::vector<Int2> *v = new std::vector<Int2>( size );
  for( Int2 i=0; i<size; i++ )
    ( *v )[i] = (Int2)i;
  return v;
}
////////////////////////////////////////////////
std::vector<UInt2>*  VectorTool::
MakeVectorUInt2P(  UInt2 size )
{
  std::vector<UInt2> *v = new std::vector<UInt2>( size );
  for( UInt2 i=0; i<size; i++ )
    ( *v )[i] = (UInt2)i;
  return v;
}
////////////////////////////////////////////////
std::vector<std::string>* VectorTool::
MakeVectorStringP(  UInt4 size )
{
  std::vector<std::string> *v = new std::vector<std::string>( size );
  for( UInt4 i=0; i<size; i++ )
    ( *v )[i] = "";
  return v;
}
////////////////////////////////////////////////
std::vector<bool>* VectorTool::
MakeVectorBoolP(  UInt4 size )
{
  std::vector<bool> *v = new std::vector<bool>( size );
  for( UInt4 i=0; i<size; i++ )
    ( *v )[i] = 0;
  return v;
}
////////////////////////////////////////////////
std::pair<Double,Double> VectorTool::
MakeDoubleDoublePair( Double First, Double Second ){
  std::pair<Double,Double> r;
  r.first  = First;
  r.second = Second;
  return r;
}
////////////////////////////////////////////////
