/*
$Id: UInt4ContainerArray.hh 2110 2010-04-07 04:35:47Z jisuzuki $
*/


#ifndef UINT4CONTAINERARRAY
#define UINT4CONTAINERARRAY

#include "Header.hh"
#include "NeutronVector.hh"
#include "UInt4Container.hh"
#include "ElementContainerArray.hh"

//! Data container for a set of UInt4Container-s and HeaderBase.
/*! This class is data container class like "ElementContainerArray".
  Functionalities of class methods in this class is similar to
  the methods of "ElementContainerArray". See the manual of "ElementContainerArray".
 */
class UInt4ContainerArray
  : public NeutronVector< UInt4Container, HeaderBase >
{
public:
  using NeutronVector< UInt4Container, HeaderBase >::operator();

  UInt4ContainerArray();
  UInt4ContainerArray( HeaderBase pheader );
  UInt4ContainerArray( const NeutronVector< UInt4Container, HeaderBase > &ob );

  UInt4Container* operator[]( UInt4 index );
  std::vector<UInt4>*   operator()( UInt4 index, std::string key );
  std::vector<UInt4>*   operator()( UInt4 index, UInt4 C_index );

  ElementContainerArray ConvertIntoElementContainerArray();
};
#endif
