/*
$Id: StlMapDouble.cc 2110 2010-04-07 04:35:47Z jisuzuki $
*/


#include "StlMapDouble.hh"
////////////////////////////////////////////////
StlMapDouble ::
StlMapDouble()
{
}
////////////////////////////////////////////////
StlMapDouble ::
~StlMapDouble()
{
}
////////////////////////////////////////////////
StlMapDouble ::
StlMapDouble( const StlMapDouble &ob )
  : M(ob.M)
{
}
////////////////////////////////////////////////
StlMapDouble &StlMapDouble ::
operator=( const StlMapDouble &ob )
{
  M = ob.M;
  return *this;
}
////////////////////////////////////////////////
////////////////////////////////////////////////
Int8 StlMapDouble ::
PutIndexNumber( const std::string &Key )
{
  std::map< std::string, std::vector<Double> >::iterator ipi = M.begin();
  Int8 r = 0;
  while( ipi  != M.end() ){
    if( ipi->first == Key ){
      return r;
    }
    ipi++;
    r++;
  }
  return -1;
}
////////////////////////////////////////////////
std::vector<std::string> StlMapDouble ::
PutKeyList()
{
  std::vector<std::string> StrList;
  StrList.clear();

//  std::map< std::string, std::vector<Double> >::iterator p  = M.begin();
  std::map< std::string, std::vector<Double> >::iterator pe = M.end();

  for( std::map< std::string, std::vector<Double> >::iterator p = M.begin(); p != pe; p++ ){
    StrList.push_back( p -> first );
  }

  return StrList;
}
////////////////////////////////////////////////
void StlMapDouble ::
DumpKeyList()
{
  UInt4 i = 0;
  std::map< std::string, std::vector<Double> >::iterator pe = M.end();
  for( std::map< std::string, std::vector<Double> >::iterator p = M.begin(); p != pe; p++ ){
    std::cout << i++ << "\t" << p -> first << std::endl;
  }
}
////////////////////////////////////////////////
void StlMapDouble ::
Append( const std::string &key, std::vector<Double> &value )
{
  if( ( M.insert( std::pair< std::string, std::vector<Double> >( key, value ) ) ).second == 0 ){
    std::cout << key << " has already registered in this map." << std::endl;
    std::cout << "Please retry with the other key." << std::endl;
  }
}
////////////////////////////////////////////////
/*
void StlMapDouble ::
AppendP( std::string key, std::vector<Double> *value ){
  Append( key, *value );
}
*/
////////////////////////////////////////////////
std::vector<Double> &StlMapDouble ::
Put( const std::string &key )
{
  if( M.find( key ) == M.end() ){
    std::cout << key << " is not registered in this map." << std::endl;
    static std::vector<Double> tmp;
    return tmp;
  }
  return M[ key ];
}
////////////////////////////////////////////////
std::vector<Double> &StlMapDouble ::
Put( const UInt4 index )
{
  if( M.size() <= index ){
    std::cout << " The argument, index, is too large." << std::endl;
    static std::vector<Double> tmp;
    tmp.clear();
    return tmp;
  }

  std::map< std::string, std::vector<Double> >::iterator p = M.begin();

  for( UInt4 i=0; i<index; i++ ){
    p++;
  }
  return p->second;
}
////////////////////////////////////////////////
const std::vector<Double>& StlMapDouble ::
ref( const std::string &key ) const
{
  std::map< std::string, std::vector<Double> >::const_iterator p = M.find( key );
  if( p == M.end() ){
    std::cout << key << " is not registered in this map." << std::endl;
  }
  return p->second;
}
////////////////////////////////////////////////
const std::vector<Double>* StlMapDouble ::
PutPointer( const UInt4 index ) const
{
  if( M.size() <= index ){
    std::cout << " The argument, index, is too large." << std::endl;
    return NULL;
  }

  std::map< std::string, std::vector<Double> >::const_iterator p = M.begin();
  for( UInt4 i=0; i<index; i++ ){
    p++;
  }
  return &( p->second );
}
////////////////////////////////////////////////
void StlMapDouble ::
Erase( const std::string &key )
{
  if( M.find( key ) == M.end() ){
    std::cout << key << " has not registered in this map." << std::endl;
  }
  M.erase( key );
}
////////////////////////////////////////////////
void StlMapDouble ::
Replace( const std::string &key, std::vector<Double> &value )
{
  if( M.find( key ) == M.end() ){
    std::cout << key << " has not registered in this map." << std::endl;
    return;
  }
  M[ key ] = value;
}
////////////////////////////////////////////////
void StlMapDouble ::
Copy( const std::string &OldKey, const std::string &NewKey )
{
  if( M.find( OldKey ) == M.end() ){
    std::cout << OldKey << " has not registered in this map." << std::endl;
    std::cout << OldKey << " is not copied." << std::endl;
    return;
  }
  M[ NewKey ] = M[ OldKey ];
}
////////////////////////////////////////////////
