/*
$Id: SplitString.cc 1940 2008-06-19 04:48:52Z jisuzuki $
*/


#include "SplitString.hh"
///////////////////////////////////////////
SplitString::
SplitString()
{
  //list = NULL;
  //ListSize = 0;
}
///////////////////////////////////////////
SplitString::
~SplitString()
{
  //if( list != NULL ) delete [] list;
}
///////////////////////////////////////////
/*
void SplitString::
MakeTemp( std::string Source, std::string SplitKey )
{
  UInt4 size = Source.size();
  std::vector<UInt4> v;
  v.clear();

  for( UInt4 i=0; i<size; i++ ){
    if( Source.substr( i, 1 ) == SplitKey )
      v.push_back( i );
  }  // Check the number of elements
  ListSize = v.size()+1;

  if( list != NULL ) delete [] list;
  list = new std::string [ ListSize ];
  // Make temporary array,

  if( v.size() == 0 )
    list[0] = Source;
  else{
    list[0] = Source.substr( 0, v[0] );

    for( UInt4 i=0; i<v.size(); i++ )
      list[i+1] = Source.substr( v[i]+1, v[i+1]-v[i]-1 );
  }
}
*/
///////////////////////////////////////////
std::vector<std::string> SplitString::
PutStringArray( std::string Source, std::string SplitKey )
{
  std::vector< std::string > output;
  output.clear();

  std::string s = Source;

  std::string temp;
  UInt4  size = (UInt4)(s.size());
  UInt4  DelimSize = (UInt4)(SplitKey.size());

  UInt4 pos = 0;

  while( pos < size ){
    pos = (UInt4)(s.find( SplitKey ));
    output.push_back( s.substr( 0, pos ) );

    s = s.substr( pos + DelimSize, size );
    if( s.size() == 0 ){
      break;
    }
  }

  std::vector<std::string> v;
  v.clear();

  UInt4 OutSize = (UInt4)(output.size());
  for( UInt4 j=0; j<OutSize; j++ ){
    if( output[j].size() != 0 ){
      v.push_back( output[j] );
    }
  }
  return v;
}
///////////////////////////////////////////

std::vector<std::string> SplitString::
PutStringArrayWithSpace( std::string Source, std::string SplitKey )
{
  std::vector< std::string > output;
  output.clear();

  std::string s = Source;

  std::string temp;
  UInt4  size = (UInt4)(s.size());
  UInt4  DelimSize = (UInt4)(SplitKey.size());

  UInt4 pos = 0;

  while( pos < size ){
    pos = (UInt4)(s.find( SplitKey ));
    output.push_back( s.substr( 0, pos ) );

    s = s.substr( pos + DelimSize, size );
    if( s.size() == 0 ){
      break;
    }
  }

  return output;

  /*
  MakeTemp( Source, SplitKey );

  std::vector<std::string> v;
  v.clear();

  for( UInt4 i=0; i<ListSize; i++ )
    v.push_back( list[i] );

  return v;
  */
}
///////////////////////////////////////////
std::vector<Int4> SplitString::
PutInt4Array( std::string Source, std::string SplitKey )
{
  std::vector< std::string > vs = PutStringArray( Source, SplitKey );
  UInt4 vsSize = (UInt4)(vs.size());

  std::vector< Int4 > vi( vsSize );
  for( UInt4 j=0; j<vsSize; j++ ){
    vi[ j ] = ( Int4 ) atoi( vs[ j ].c_str() );
  }
  return vi;

  /*
  MakeTemp( Source, SplitKey );
  std::vector<Int4> v;
  v.clear();

  for( UInt4 i=0; i<ListSize; i++ )
    v.push_back( ( Int4 )atoi( list[i].data() ) );
  return v;
  */
}
///////////////////////////////////////////
std::vector<UInt4> SplitString::
PutUInt4Array( std::string Source, std::string SplitKey )
{
  std::vector< std::string > vs = PutStringArray( Source, SplitKey );
  UInt4 vsSize = (UInt4)(vs.size());

  std::vector< UInt4 > vi( vsSize );
  for( UInt4 j=0; j<vsSize; j++ ){
    vi[ j ] = abs( ( Int4 ) atoi( vs[ j ].c_str() ) );
  }
  return vi;

  /*
  MakeTemp( Source, SplitKey );
  std::vector<UInt4> v;
  v.clear();

  for( UInt4 i=0; i<ListSize; i++ )
    v.push_back( ( UInt4 )atoi( list[i].data() ) );
  return v;
  */
}
///////////////////////////////////////////
std::vector<Int2> SplitString::
PutInt2Array( std::string Source, std::string SplitKey )
{
  std::vector< std::string > vs = PutStringArray( Source, SplitKey );
  UInt4 vsSize = (UInt4)(vs.size());

  std::vector< Int2 > vi( vsSize );
  for( UInt4 j=0; j<vsSize; j++ ){
    vi[ j ] = ( Int2 ) atoi( vs[ j ].c_str() );
  }
  return vi;

  /*
  MakeTemp( Source, SplitKey );
  std::vector<Int2> v;
  v.clear();
  for( UInt4 i=0; i<ListSize; i++ )
    v.push_back( ( Int2 )atoi( list[i].data() ) );
  return v;
  */
}
///////////////////////////////////////////
std::vector<UInt2> SplitString::
PutUInt2Array( std::string Source, std::string SplitKey )
{
  std::vector< std::string > vs = PutStringArray( Source, SplitKey );
  UInt4 vsSize = (UInt4)(vs.size());

  std::vector< UInt2 > vi( vsSize );
  for( UInt4 j=0; j<vsSize; j++ ){
    vi[ j ] = abs( ( Int2 ) atoi( vs[ j ].c_str() ) );
  }
  return vi;

  /*
  MakeTemp( Source, SplitKey );
  std::vector<UInt2> v;
  for( UInt4 i=0; i<ListSize; i++ )
    v.push_back( ( UInt2 )atoi( list[i].data() ) );
  return v;
  */
}
///////////////////////////////////////////
std::vector< Float > SplitString::
PutFloatArray( std::string Source, std::string SplitKey )
{
  std::vector< std::string > vs = PutStringArray( Source, SplitKey );

  std::vector< Float > vf;
  vf.clear();

  for( UInt4 i=0; i<vs.size(); i++ ){
    std::string target = vs[ i ];
    std::string temp = "";
    for( UInt4 j=0; j<target.size(); j++ ){
      temp = temp + " ";
    }
    if( target.compare( temp ) != 0 ){
      vf.push_back( (Float)atof( vs[i].c_str() ) );
    }
  }

  return vf;

  /*
  std::vector< std::string > vs = PutStringArray( Source, SplitKey );
  UInt4 vsSize = vs.size();

  std::vector< Float > vf( vsSize );
  for( UInt4 j=0; j<vsSize; j++ ){
    vf[ j ] = ( Float ) atof( vs[ j ].c_str() );
  }
  return vf;
  */
}
///////////////////////////////////////////
std::vector<Double> SplitString::
PutDoubleArray( std::string Source, std::string SplitKey )
{
  std::vector< std::string > vs = PutStringArray( Source, SplitKey );

  std::vector< Double > vf;
  vf.clear();

  for( UInt4 i=0; i<vs.size(); i++ ){
    std::string target = vs[ i ];
    std::string temp = "";
    for( UInt4 j=0; j<target.size(); j++ ){
      temp = temp + " ";
    }
    if( target.compare( temp ) != 0 ){
      vf.push_back( (Double)atof( vs[i].c_str() ) );
    }
  }

  return vf;

  /*
  UInt4 vsSize = vs.size();
  std::vector< Double > vf( vsSize );
  for( UInt4 j=0; j<vsSize; j++ ){
    vf[ j ] = ( Double ) atof( vs[ j ].c_str() );
  }
  return vf;
  */
}
/////////////////////////////////////////////
