/*
$Id: ReadWriteTextFile.hh 1596 2006-06-30 07:15:00Z suzuki $
*/


#ifndef READWRITETEXTFILE
#define READWRITETEXTFILE

#include "Header.hh"

#ifdef WINDOWS
#include <sys/file.h>
#endif

//!
/*!
  This class cannot work on MacOS system.
  Because the function of "fopen()" is different from
  that on Linux and FreeBSD system.
 */

class ReadWriteTextFile
{
private:
  std::string FileName;
  FILE   *fin;
  std::vector<std::string> v;
  UInt4 LockFlag;
protected:

public:
  ReadWriteTextFile( std::string _FileName, UInt4 _LockFlag=0 );
  /*!< Constructor. In ordinary case, you can omit the second argument.
    The target file will be open in append mode.
   */
 ~ReadWriteTextFile();
  /*!< Destructor. When this method is called,
    the file descriptor defined in the constructor will be closed.
  */

  void ReSetTarget( std::string _FileName, UInt4 _LockFlag=0 );

  void Read();
  /*!< The file descriptor opened by the constructor
    is re-opened in read-mode, and read the target file.
    The contents of the target file can be obtained
    with std::vector<std::string> Put().
   */
  std::vector<std::string> Put(){ return v; };
  /*
    The contents of the target file can be obtained
    with this method.
  */
  void Write( std::vector<std::string> StrVec );
  /*!<
    The argument of std::vector<std::string> is written to the
    target file. Each element in "StrVec" corresponds to
    each line in the file.
    The target file will be closed in the destructor
    of this class.
   */
};

#endif
