/*
$Id: PyRunOnCPP.hh 1780 2007-06-14 04:40:33Z suzuki $
 */

#ifndef PYRUNONCPP
#define PYRUNONCPP

#include "Header.hh"


//! Execute Python script. This class must not be called from Python.
/*!
  This class must not be called from Python !!

  This class executes python scripts with C-library
  provided by Python development tools.
  Because this class uses the library of python development
  environment, python scripts are executed in the same process
  of this class.
 */


class PyRunOnCPP
{
public:
  PyRunOnCPP();
  /*!< Constructor*/
 ~PyRunOnCPP();
  /*!< Destructor.
    This method terminates the python process connected
    in this class.
   */

  Int4 PyRun( std::vector<std::string> script );
  /*!<
    Python script, the argument, is passed to
    the python called by the constructor.
   */

  Int4 PyRun( std::string script );
  /*!<
    Python script, the argument, is passed
    to the python called by the constructor.
    The argument should not contain indents.
    If you want to input "for-loop" or "if",
    you should use "PyRun(std::vector<std::string>)".
   */
};

#endif
