/*
$Id: NeutronReadBinaryData.hh 1780 2007-06-14 04:40:33Z suzuki $
*/


#ifndef NEUTRONREADBINARYDATA_HH
#define NEUTRONREADBINARYDATA_HH
#include "Header.hh"

//#include <sys/types.h>
//#include <sys/stat.h>

#include "SwapBytes.hh"
#include "CollectArchitecture.hh"
#include "CppToPython.hh"

//!Read a binary data file.
/*!This template class reads a binary data file,
  and provide its data as a array and std::vector.
  The dimensions of the reading binary file
  is not required to read, it is obtained from
  the data type and the size of the target file.

  Because this template is designed to read the whole of file,
  if the size of target file is large, the reading procedure is
  rather slow. If you want to read the section of the target file,
  you can use "NeutronReadBinaryDataSection".
 */

template <class T>
class NeutronReadBinaryData
{
private:
  UInt4 SwapFlag;

protected:

public:
  NeutronReadBinaryData( std::string _SwapFlag="None" );
  /*!<
    The mean of the argument is swap-flag.
    The argument should be selected
    from "NoSwap", "Swap", "big" and "little",
    and its default value is "None".

    If you selected "Swap", the byte-order of the target binary file
    is changed in this class.
    When the argument is "NoSwap", the byte-order of it
    is not changed.

    If the byte-order of the target file is "little-endian",
    you must set the argument as "little".
    The architecture of the computer running "Manyo-Lib" is obtained
    in this constructor, and the argument is compared with the architecture.
    This method will decide
    whether the byte-order should be changed or not.

    When the byte-order of the target file is "big-endian",
    you must set the argument as "big".
  */
  std::vector<T> ReadData( std::string Filename );
  /*!< The "FileName" is the name of the target binary file.
    The data length of "FileName" is checked and obtained automatically
    using the data type of "T" and the file size. */

  void PrintData( std::string FileName );
  /*!<
    The content of "FileName" is dumped to the standard-output.
   */

  std::vector< UInt4 >  PutUInt4Vector( std::string Filename );
  /*!< Returns a vector<UInt4>. The content of the vector is the same as
   the vector returned by the method of "std::vector<T> ReadData(Char*)". */

  std::vector< Double > PutDoubleVector( std::string Filename );
   /*!< Returns a vector<Double>. The content of the vector is the same as
   the vector returned by the method of "std::vector<T> ReadData(Char*)". */

  PyObject *PutDoubleList( std::string FileName );
  /*!< Returns a python list object. The content of the return object
   is the same as the PutDoubleVector(std::string). */
  PyObject *PutUInt4List( std::string FileName );
  /*!< Returns a python list object. The content of the return object
   is the same as the PutUInt4Vector(std::string).*/

  UInt8 ReadData( std::string FileName, T *&array );
  /*!<The "FileName" is the name of the target binary file.
    The data length of "FileName" is checked automatically
    using the data type of "T" and its file size.
    The second argument is the pointer of the array
    whose value should be NULL. The pointer will be assigned to
    the pointer of the array obtained and produced by this method.
    The returned value of this method is the size of the array.
  */
};

#include "NeutronReadBinaryData.cc"

#endif
