/*
$Id: GslHistogram.cc 2001 2009-03-16 06:28:16Z jisuzuki $
 */
#include "GslHistogram.hh"
////////////////////////////////////////////
GslHistogram::
GslHistogram( Double *Bin, UInt4 Size, UInt4 _NumOfMulTh ){
  NumOfMulTh = _NumOfMulTh;
  Set( Bin, Size );
}
////////////////////////////////////////////
PyObject * GslHistogram::
VtoL( std::vector<Double> v ){
  CppToPython c;
  return c.VectorDoubleToList( v );
}
////////////////////////////////////////////
void GslHistogram::
Set( Double *Bin, UInt4 Size ){

  h = new gsl_histogram* [ NumOfMulTh ];

  for( UInt4 i=0; i<NumOfMulTh; i++ ){
    h[i] = gsl_histogram_alloc( Size-1 );
    gsl_histogram_set_ranges( h[i], Bin, Size );
    free(h[i]->range);
    h[i]->range = Bin;
  }
}
////////////////////////////////////////////
GslHistogram::
~GslHistogram(){
  for( UInt4 i=0; i<NumOfMulTh; i++ ){
    free(h[i]->bin);
    free(h[i]);
  }
  delete [] h;
}
////////////////////////////////////////////
Int4 GslHistogram::
Increment( Double x, UInt4 ThNum, Double Weight ){
  return gsl_histogram_accumulate( h[ThNum], x, Weight );
}
////////////////////////////////////////////
void GslHistogram::
Increment( std::vector<Double> x, UInt4 ThNum ){
  for( UInt4 i=0; i<x.size(); i++ ){
    Increment( x[ i ], ThNum, 1.0 );
  }
}
////////////////////////////////////////////
void GslHistogram::
Increment( std::vector<Int4> x, UInt4 ThNum ){
  for( UInt4 i=0; i<x.size(); i++ ){
    Increment( (Double)( x[ i ] ), ThNum );
  }
}
////////////////////////////////////////////
void GslHistogram::
Reset(){
  for( UInt4 j=0; j<NumOfMulTh; j++ ){
    gsl_histogram_reset( h[j] );
  }
}
////////////////////////////////////////////
std::vector<Double> GslHistogram::
PutHistogram(){

  UInt4 size = PutHistSize();
  std::vector<Double> v( size );

  for( UInt4 j=0; j<NumOfMulTh; j++ ){
    for( UInt4 i=0; i<size; i++ ){
      v[ i ] = v[i] + gsl_histogram_get( h[j], i );
    }
  }
  return v;
}
////////////////////////////////////////////
std::vector<Double> GslHistogram::
PutHistogramErr(){

  UInt4 size = PutHistSize();
  std::vector<Double> ph = PutHistogram();
  std::vector<Double> v( ph.size() );

  for( UInt4 i=0; i<size; i++ ){
    v[ i ] = sqrt( ph[ i ] );
  }
  return v;
}
////////////////////////////////////////////
std::vector<Double> GslHistogram::
PutBin(){

  UInt4 size = PutHistSize();
  std::vector<Double> v( size+1 );
  Double min, max;
  for( UInt4 i=0; i<size; i++ ){
    gsl_histogram_get_range( h[0], i, &min, &max );
    v[ i ] = min;
  }
  v[ size ] = max;
  return v;
}
////////////////////////////////////////////
Double GslHistogram::
PutHistogramSum(){

  Double sum = 0.0;
  UInt4 size = PutHistSize();

  for( UInt4 j=0; j<NumOfMulTh; j++ ){
    for( UInt4 i=0; i<size; i++ ){
      sum = sum + gsl_histogram_get( h[j], i );
    }
  }
  return sum;
}
////////////////////////////////////////////
