/*
$Id: CppToPython.cc 2350 2012-03-11 02:27:01Z tito $
*/


#include "CppToPython.hh"
////////////////////////////////////////////
CppToPython::
CppToPython()
{
}
////////////////////////////////////////////
CppToPython::
~CppToPython()
{
}
////////////////////////////////////////////



#if PyMaj == 2

PyObject * CppToPython::
VectorStringToList( std::vector<std::string> v )
{
  PyObject *Py;
  UInt4 size = v.size();
  Py = PyList_New( size );
  for( UInt4 s=0; s<size; s++ ){
    PyList_SetItem( Py, s, Py_BuildValue( (Char*)"s", ( v[s] ).c_str() ) );
  }
  return Py;
}
////////////////////////////////////////////
PyObject * CppToPython::
VectorDoubleToList( std::vector<Double> v )
{
  PyObject *Py;
  //Py = Py_BuildValue( (Char*)"[]" );
  UInt4 size = v.size();
  Py = PyList_New( size );
  for( UInt4 s=0; s<size; s++ ){
    //PyList_Append( Py, Py_BuildValue( (Char*)"d", (Double)v[s] ) );
    PyList_SetItem( Py, s, Py_BuildValue( (Char*)"d", (Double)v[s]));
  }
  return Py;
}
////////////////////////////////////////////
PyObject * CppToPython::
MakeDoubleList( UInt4 size )
{
  PyObject *Py;
  //Py = Py_BuildValue( (Char*)"[]" );
  Py = PyList_New( size );
  PyObject *temp = Py_BuildValue( (Char*)"d", 0.0 );
  for( UInt4 s=0; s<size; s++ ){
    //PyList_Append( Py, temp );
    PyList_SetItem( Py, s, temp );
  }
  return Py;
}
////////////////////////////////////////////
PyObject * CppToPython::
MakeIntList( UInt4 size )
{
  PyObject *Py;
  //Py = Py_BuildValue( (Char*)"[]" );
  Py = PyList_New( size );
  PyObject *temp = Py_BuildValue( (Char*)"i", 0 );
  for( UInt4 s=0; s<size; s++ ){
    //PyList_Append( Py, temp );
    PyList_SetItem( Py, s, temp );
  }
  return Py;
}
////////////////////////////////////////////
std::vector<Double> CppToPython::
ListToDoubleVector( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToDoubleVector(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<Double> v;
    v.clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<Double> v( size );

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<Double>.

  for( UInt4 s=0; s<size; s++ ){
    if( PyFloat_CheckExact( PyList_GetItem( List, s ) ) ){
      v[ s ] = PyFloat_AsDouble( PyList_GetItem( List, s ) );
    }
    else if( PyLong_CheckExact( PyList_GetItem( List, s ) ) ){
      v[ s ] = ( Double )( PyLong_AsLong( PyList_GetItem( List, s ) ) );
    }
    else if( PyInt_CheckExact( PyList_GetItem( List, s ) ) ){
      v[ s ] = ( Double )( PyInt_AsLong( PyList_GetItem( List, s ) ) );
    }
    else{
      std::cout << "CppToPython::ListToDoubleVector(PyObject*)" << std::endl;
      std::cout << "The type of each element of Python-List"
                << "is not Double, long or int." << std::endl;
      std::cout << "The target Python-List-object "
                << "cannnot be converted into a vector<Double>" << std::endl;
      std::vector<Double> TmpV;
      TmpV.clear();
      return TmpV;
    }
  }

  /*
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyFloat_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<Double> TmpV;
      TmpV.clear();
      return TmpV;
    }
  }

  for( UInt4 s=0; s<size; s++ ){
    v[s] = PyFloat_AsDouble( PyList_GetItem( List, s ) );
  }
  */

  return v;
}
////////////////////////////////////////////
std::vector<Double> * CppToPython::
ListToDoubleVectorP( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToDoubleVectorP(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<Double> *v = new std::vector<Double>;
    v -> clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<Double> TmpVec = ListToDoubleVector( List );

  if( size != TmpVec.size() ){
    std::cout << "CppToPython::ListToDoubleVectorP(PyObject*)" << std::endl;
    std::cout << "The conversion from a Python-List to a vector<Double>* "
              << "is failed." << std::endl;
    return NULL;
  }

  std::vector<Double> *v = new std::vector<Double>( size );

  for( UInt4 s=0; s<size; s++ ){
    ( *v )[ s ] = TmpVec[ s ];
  }

  // Each element of input List should be Double object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<Double>.
  /*
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyFloat_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<Double> *v = new std::vector<Double>( size );
      v->clear();
      return v;
    }
  }

  std::vector<Double> *v = new std::vector<Double>( size );

  for( UInt4 s=0; s<size; s++ ){
    ( *v )[s] = PyFloat_AsDouble( PyList_GetItem( List, s ) );
  }
  */
  return v;
}
////////////////////////////////////////////
PyObject * CppToPython::
VectorUInt4ToList( std::vector<UInt4> v )
{
  PyObject *Py;
  //Py = Py_BuildValue( (Char*)"[]" );
  UInt4 size = v.size();
  Py = PyList_New( size );
  for( UInt4 s=0; s<size; s++ ){
    //PyList_Append( Py, Py_BuildValue( (Char*)"i", (UInt4)v[s] ) );
    PyList_SetItem( Py, s, Py_BuildValue( (Char*)"i", (UInt4)v[s] ) );
  }
  return Py;
}
////////////////////////////////////////////
PyObject * CppToPython::
VectorInt4ToList( std::vector<Int4> v )
{
  PyObject *Py;
  //Py = Py_BuildValue( (Char*)"[]" );
  UInt4 size = v.size();
  Py = PyList_New( size );
  for( UInt4 s=0; s<size; s++ ){
    //PyList_Append( Py, Py_BuildValue( (Char*)"i", (Int4)v[s] ) );
    PyList_SetItem( Py, s, Py_BuildValue( (Char*)"i", (Int4)v[s] ) );
  }
  return Py;
}
////////////////////////////////////////////
std::vector<UInt4> CppToPython::
ListToUInt4Vector( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToUInt4Vector(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;

    std::vector<UInt4> v;
    v.clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<UInt4> v(size);

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<std::string>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyInt_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<UInt4> v;
      v.clear();
      return v;
    }
  }

  for( UInt4 s=0; s<size; s++ ){
    //v[s] = PyLong_AsUnsignedLong( PyList_GetItem( List, s ) );
    v[s] = abs( PyInt_AsLong( PyList_GetItem( List, s ) ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector<Int4> CppToPython::
ListToInt4Vector( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToInt4Vector(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;

    std::vector<Int4> v;
    v.clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<Int4> v(size);

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<Int4>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyInt_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<Int4> v;
      v.clear();
      return v;
    }
  }


  for( UInt4 s=0; s<size; s++ ){
    //v[s] = PyLong_AsLong( PyList_GetItem( List, s ) );
    v[s] = PyInt_AsLong( PyList_GetItem( List, s ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector<UInt4> * CppToPython::
ListToUInt4VectorP( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToUInt4VectorP(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<UInt4> *v = new std::vector<UInt4>;
    v -> clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );

  // Each element of input List should be UInt4 object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<UInt4>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyInt_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<UInt4> *v = new std::vector<UInt4>( size );
      v->clear();
      return v;
    }
  }

  std::vector<UInt4> *v = new std::vector<UInt4>( size );

  for( UInt4 s=0; s<size; s++ ){
    //( *v )[s] = ( UInt4 )PyLong_AsUnsignedLong( PyList_GetItem( List, s ) );
    ( *v )[s] = ( UInt4 )abs( PyInt_AsLong( PyList_GetItem( List, s ) ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector<Int4> * CppToPython::
ListToInt4VectorP( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToInt4VectorP(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<Int4> *v = new std::vector<Int4>;
    v -> clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );

  // Each element of input List should be Int4 object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<Int4>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyInt_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<Int4> *v = new std::vector<Int4>( size );
      v->clear();
      return v;
    }
  }

  std::vector<Int4> *v = new std::vector<Int4>( size );

  for( UInt4 s=0; s<size; s++ ){
    ( *v )[s] = PyInt_AsLong( PyList_GetItem( List, s ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector<std::string> CppToPython::
ListToStringVector( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToStringVector(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<std::string> v;
    v.clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<std::string> v( size );

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<std::string>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyString_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<std::string> v;
      v.clear();
      return v;
    }
  }

  for( UInt4 s=0; s<size; s++ ){
    v[s] = std::string( PyString_AsString( PyList_GetItem( List, s ) ) );
  }

  return v;
}
////////////////////////////////////////////
std::vector<std::string> * CppToPython::
ListToStringVectorP( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToStringVectorP(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<std::string> *v = new std::vector<std::string>;
    v -> clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<std::string>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyString_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<std::string> *v = new std::vector<std::string>( size );
      v->clear();
      return v;
    }
  }

  std::vector<std::string> *v = new std::vector<std::string>( size );

  for( UInt4 s=0; s<size; s++ ){
    ( *v )[s] = std::string( PyString_AsString( PyList_GetItem( List, s ) ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector< std::vector<Int4> > CppToPython::                                                      // <-- Ito,T. [20120311]
ListToInt4VectorVector( PyObject *List )
{
    if( ! PyList_Check( List ) ){
        std::cout << "CppToPython::ListToInt4Vector(PyObject*)" << std::endl;
        std::cout << "The given object is not a Python-List object." << std::endl;
        std::cout << "Anyway, the null-vector generated in this method "
                  << "is returned." << std::endl;

        std::vector< std::vector<Int4> > v;
        v.clear();
        return v;
    }

    UInt4 size = (UInt4) PyList_Size( List );
    std::vector< std::vector<Int4> > v(size);

    for (UInt4 i=0; i < size; ++i){
        PyObject * innerList = PyList_GetItem( List, i);
        if ( ! PyList_Check( innerList ) ){
            v.clear();
            return v;
        }
        UInt4 innerSize = (UInt4) PyList_Size( innerList);
        std::vector<Int4> innerV(innerSize);
        for (UInt4 j=0; j < innerSize ; ++j){
            if ( ! PyInt_CheckExact( PyList_GetItem( innerList, j) ) ){
                v.clear();
                return v;
            } else {
                innerV[j] = PyInt_AsLong( PyList_GetItem( innerList, j ) );
            }
        }
        v[i] = innerV;
    }
  return v;
}
////////////////////////////////////////////                                    // --> Ito,T. [20120311]




#elif PyMaj == 3

PyObject * CppToPython::
VectorStringToList( std::vector<std::string> v )
{
  PyObject *Py;
  UInt4 size = (UInt4)(v.size());
  Py = PyList_New( size );
  for( UInt4 s=0; s<size; s++ ){
    PyList_SetItem( Py, s, Py_BuildValue( (Char*)"s", ( v[s] ).c_str() ) );
  }
  return Py;
}
////////////////////////////////////////////
PyObject * CppToPython::
VectorDoubleToList( std::vector<Double> v )
{
  PyObject *Py;
  UInt4 size = (UInt4)(v.size());
  Py = PyList_New( size );
  for( UInt4 s=0; s<size; s++ ){
    PyList_SetItem( Py, s, Py_BuildValue( (Char*)"d", (Double)v[s]));
  }
  return Py;
}
////////////////////////////////////////////
PyObject * CppToPython::
MakeDoubleList( UInt4 size )
{
  PyObject *Py;
  Py = PyList_New( size );
  PyObject *temp = Py_BuildValue( (Char*)"d", 0.0 );
  for( UInt4 s=0; s<size; s++ ){
    PyList_SetItem( Py, s, temp );
  }
  return Py;
}
////////////////////////////////////////////
PyObject * CppToPython::
MakeIntList( UInt4 size )
{
  PyObject *Py;
  Py = PyList_New( size );
  PyObject *temp = Py_BuildValue( (Char*)"i", 0 );
  for( UInt4 s=0; s<size; s++ ){
    PyList_SetItem( Py, s, temp );
  }
  return Py;
}
////////////////////////////////////////////
std::vector<Double> CppToPython::
ListToDoubleVector( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToDoubleVector(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<Double> v;
    v.clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<Double> v( size );

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<Double>.

  for( UInt4 s=0; s<size; s++ ){

    if( PyFloat_CheckExact( PyList_GetItem( List, s ) ) ){
      v[ s ] = PyFloat_AsDouble( PyList_GetItem( List, s ) );
    }
    else if( PyLong_CheckExact( PyList_GetItem( List, s ) ) ){
      v[ s ] = ( Double )( PyLong_AsLong( PyList_GetItem( List, s ) ) );
    }
    //else if( PyInt_CheckExact( PyList_GetItem( List, s ) ) ){
    //  v[ s ] = ( Double )( PyInt_AsLong( PyList_GetItem( List, s ) ) );
    //}
    else{
      std::cout << "CppToPython::ListToDoubleVector(PyObject*)" << std::endl;
      std::cout << "The type of each element of Python-List"
                << "is not Double, long or int." << std::endl;
      std::cout << "The target Python-List-object "
                << "cannnot be converted into a vector<Double>" << std::endl;
      std::vector<Double> TmpV;
      TmpV.clear();
      return TmpV;
    }

  }

  return v;
}
////////////////////////////////////////////
std::vector<Double> * CppToPython::
ListToDoubleVectorP( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToDoubleVectorP(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<Double> *v = new std::vector<Double>;
    v -> clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<Double> TmpVec = ListToDoubleVector( List );

  if( size != TmpVec.size() ){
    std::cout << "CppToPython::ListToDoubleVectorP(PyObject*)" << std::endl;
    std::cout << "The conversion from a Python-List to a vector<Double>* "
              << "is failed." << std::endl;
    return NULL;
  }

  std::vector<Double> *v = new std::vector<Double>( size );

  for( UInt4 s=0; s<size; s++ ){
    ( *v )[ s ] = TmpVec[ s ];
  }
  return v;
}
////////////////////////////////////////////
PyObject * CppToPython::
VectorUInt4ToList( std::vector<UInt4> v )
{
  PyObject *Py;
  UInt4 size = (UInt4)(v.size());
  Py = PyList_New( size );
  for( UInt4 s=0; s<size; s++ ){
    PyList_SetItem( Py, s, Py_BuildValue( (Char*)"i", (UInt4)v[s] ) );
  }
  return Py;
}
////////////////////////////////////////////
PyObject * CppToPython::
VectorInt4ToList( std::vector<Int4> v )
{
  PyObject *Py;
  UInt4 size = (UInt4)(v.size());
  Py = PyList_New( size );
  for( UInt4 s=0; s<size; s++ ){
    PyList_SetItem( Py, s, Py_BuildValue( (Char*)"i", (Int4)v[s] ) );
  }
  return Py;
}
////////////////////////////////////////////
std::vector<UInt4> CppToPython::
ListToUInt4Vector( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToUInt4Vector(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;

    std::vector<UInt4> v;
    v.clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<UInt4> v(size);

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<std::string>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyLong_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<UInt4> v;
      v.clear();
      return v;
    }
  }

  for( UInt4 s=0; s<size; s++ ){
    v[s] = (UInt4)abs( PyLong_AsLong( PyList_GetItem( List, s ) ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector<Int4> CppToPython::
ListToInt4Vector( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToInt4Vector(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;

    std::vector<Int4> v;
    v.clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<Int4> v(size);

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<Int4>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyLong_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<Int4> v;
      v.clear();
      return v;
    }
  }


  for( UInt4 s=0; s<size; s++ ){
    v[s] = (Int4)PyLong_AsLong( PyList_GetItem( List, s ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector<UInt4> * CppToPython::
ListToUInt4VectorP( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToUInt4VectorP(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<UInt4> *v = new std::vector<UInt4>;
    v -> clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );

  // Each element of input List should be UInt4 object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<UInt4>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyLong_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<UInt4> *v = new std::vector<UInt4>( size );
      v->clear();
      return v;
    }
  }

  std::vector<UInt4> *v = new std::vector<UInt4>( size );

  for( UInt4 s=0; s<size; s++ ){
    //( *v )[s] = ( UInt4 )PyLong_AsUnsignedLong( PyList_GetItem( List, s ) );
    ( *v )[s] = ( UInt4 )abs( PyLong_AsLong( PyList_GetItem( List, s ) ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector<Int4> * CppToPython::
ListToInt4VectorP( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToInt4VectorP(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<Int4> *v = new std::vector<Int4>;
    v -> clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );

  // Each element of input List should be Int4 object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<Int4>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyLong_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<Int4> *v = new std::vector<Int4>( size );
      v->clear();
      return v;
    }
  }

  std::vector<Int4> *v = new std::vector<Int4>( size );

  for( UInt4 s=0; s<size; s++ ){
    ( *v )[s] = (Int4)PyLong_AsLong( PyList_GetItem( List, s ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector<std::string> CppToPython::
ListToStringVector( PyObject *List ){
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToStringVector(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<std::string> v;
    v.clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector<std::string> v( size );

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<std::string>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyUnicode_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<std::string> v;
      v.clear();
      return v;
     }
  }

  for( UInt4 s=0; s<size; s++ ){
    v[s] = std::string( PyUnicode_AsUTF8( PyList_GetItem( List, s ) ) );
  }

  return v;
}
////////////////////////////////////////////
std::vector<std::string> * CppToPython::
ListToStringVectorP( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToStringVectorP(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;
    std::vector<std::string> *v = new std::vector<std::string>;
    v -> clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );

  // Each element of input List should be string object of Python-object.
  // If all of contents of the List are not string object,
  // the Python object cannot be converted into vector<std::string>.
  for( UInt4 s=0; s<size; s++ ){
    if( ! PyUnicode_CheckExact( PyList_GetItem( List, s ) ) ){
      std::vector<std::string> *v = new std::vector<std::string>( size );
      v->clear();
      return v;
    }
  }

  std::vector<std::string> *v = new std::vector<std::string>( size );

  for( UInt4 s=0; s<size; s++ ){
    ( *v )[s] = std::string( PyUnicode_AsUTF8( PyList_GetItem( List, s ) ) );
  }
  return v;
}
////////////////////////////////////////////
std::vector< std::vector<Int4> > CppToPython::
ListToInt4VectorVector( PyObject *List )
{
  if( ! PyList_Check( List ) ){
    std::cout << "CppToPython::ListToInt4Vector(PyObject*)" << std::endl;
    std::cout << "The given object is not a Python-List object." << std::endl;
    std::cout << "Anyway, the null-vector generated in this method "
              << "is returned." << std::endl;

    std::vector< std::vector<Int4> > v;
    v.clear();
    return v;
  }

  UInt4 size = (UInt4) PyList_Size( List );
  std::vector< std::vector<Int4> > v(size);

  for (UInt4 i=0; i < size; ++i){
    PyObject * innerList = PyList_GetItem( List, i);
    if ( ! PyList_Check( innerList ) ){
      v.clear();
      return v;
    }
    UInt4 innerSize = (UInt4) PyList_Size( innerList);
    std::vector<Int4> innerV(innerSize);
    for (UInt4 j=0; j < innerSize ; ++j){
      if ( ! PyLong_CheckExact( PyList_GetItem( innerList, j) ) ){
        v.clear();
        return v;
      } else {
        innerV[j] = (Int4)PyLong_AsLong( PyList_GetItem( innerList, j ) );
      }
    }
     v[i] = innerV;
  }
  return v;
}

#endif
