# -*- coding: utf-8 -*-

import sys
import string
import math

import HistOperations
import Manyo

def CreateHist( bin0 ):
    y0 = []
    e0 = []
    ec0 = Manyo.ElementContainer()
    
    for i in range( len( bin0 ) -1 ):
        y0.append( 4.0 )
        e0.append( 2.0 )
        
        ec0 = Manyo.ElementContainer()
        ec0.Add( "x", bin0 )
        ec0.Add( "y", y0 )
        ec0.Add( "e", e0 )
    ec0.SetKeys( "x", "y", "e" )
    return ec0
        
repeat = 500

bin0 = HistOperations.CreateBin( 0.0, 3000.0, math.sqrt( 2.0 ) )
bin1 = HistOperations.CreateBin( 0.0, 3000.0, math.sqrt( 3.0 ) )
ec0 = CreateHist( bin0 )
ec1 = CreateHist( bin0 )
ec2 = CreateHist( bin1 )

import time
t0 = time.time()
#print "HistOperationsHeavy.py is started, and it will be finished in 20 seconds."

# Heavy Works
for i in range( repeat ):
    
    ec0_plus_ec1 = ec0 + ec1
    ec0_sub_ec1  = ec0 - ec1
    ec0_mul_ec1  = ec0 * ec1
    ec0_div_ec1  = ec0 / ec1

    ec0_plus_ec1_1 = ec0 + ec2
    ec0_sub_ec1_1  = ec0 - ec2
    ec0_mul_ec1_1  = ec0 * ec2
    ec0_div_ec1_1  = ec0 / ec2

# eca is for module test
eca = Manyo.ElementContainerArray()
eca.Add( ec0 + ec1 )
eca.Add( ec0 - ec1 )
eca.Add( ec0 * ec1 )
eca.Add( ec0 / ec1 )


eca.Add( ec0 + ec2 )
eca.Add( ec0 - ec2 )
eca.Add( ec0 * ec2 )
eca.Add( ec0 / ec2 )

print "HistOperationHeavy.py is finished in", time.time() - t0, "seconds."
