#include "Header.hh"
#include "BinDataFileSectionReader.hh"

#ifndef EVENTDATAMONITOR
#define EVENTDATAMONITOR

class EventDataMonitorBase
{

private:



protected:
  size_t ElementSize;
  std::string WireingFile;
  std::string DetectorInfoFile;

  //UInt4 CurrentPosition;

  std::vector<std::string> TargetT0EvnetFileSet;
  std::vector<std::string> TargetEventFileSet;
  std::vector<UInt4>  DaqIdSet;
  std::vector<UInt8>  CurrentPosition;

  virtual Int8 Read( std::string TargetBinFile,
         Int8 FromBegin, Int8 SizeOfData, void *buf );
  virtual Int8 Read( std::string TargetBinFile,
         std::vector<UInt8> table, UChar *buf );
  virtual Int8 Read( std::vector<std::string> TargetBinFiles,
         std::vector<UInt8> table, UChar *buf );

public:

  EventDataMonitorBase( size_t _ElementSize=8 );
  // Constructor

  virtual ~EventDataMonitorBase();
  // Destructor



  virtual void ParameterSet( std::string _WireingFile,
                             std::string _DetectorInfoFile );

  /*
  virtual void Increment( std::string TargetT0EventFilePath,
                          std::string TargetEventDataPath,
                          UInt4 daqID )=0;
  */

  void AddDataFiles( std::string TargetT0EventFilePath,
                     std::string TargetEventDataFilePath,
                     UInt4 DaqID );

  void AddDataFiles( std::vector<std::string> TargetT0EventFilePath,
                     std::vector<std::string> TargetEventDatafilePath,
                     std::vector<UInt4> DaqID );


  virtual void Increment( UInt4 index )=0;
  // putSlicedToIndexEvents()
  // Read(), preIncrement(),

  virtual void Output( std::string OutputFileName )=0;

  virtual void Clear()=0;
  virtual void ClearDataFileSets();

};

#endif
